/**
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Autogenerated by Thrift Compiler (0.9.3)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
package org.apache.airavata.model.appcatalog.userresourceprofile;

import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;

import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;
import org.apache.thrift.server.AbstractNonblockingServer.*;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.EnumMap;
import java.util.Set;
import java.util.HashSet;
import java.util.EnumSet;
import java.util.Collections;
import java.util.BitSet;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.annotation.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings({"cast", "rawtypes", "serial", "unchecked"})
/**
 * User Resource Profile
 * 
 * userId:
 * Unique identifier used to link user to corresponding user data model
 * 
 * gatewayID:
 *  Unique identifier for the gateway assigned by Airavata. Corelate this to Airavata Admin API Gateway Registration.
 * 
 * credentialStoreToken:
 *  Gateway's defualt credential store token.
 * 
 * computeResourcePreferences:
 *  List of resource preferences for each of the registered compute resources.
 * 
 *  identityServerTenant:
 * 
 *  identityServerPwdCredToken:
 * 
 * isNull:
 *  Indicates that this instance is just a container for a null value.
 * 
 */
@Generated(value = "Autogenerated by Thrift Compiler (0.9.3)")
public class UserResourceProfile implements org.apache.thrift.TBase<UserResourceProfile, UserResourceProfile._Fields>, java.io.Serializable, Cloneable, Comparable<UserResourceProfile> {
  private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("UserResourceProfile");

  private static final org.apache.thrift.protocol.TField USER_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("userId", org.apache.thrift.protocol.TType.STRING, (short)1);
  private static final org.apache.thrift.protocol.TField GATEWAY_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("gatewayID", org.apache.thrift.protocol.TType.STRING, (short)2);
  private static final org.apache.thrift.protocol.TField CREDENTIAL_STORE_TOKEN_FIELD_DESC = new org.apache.thrift.protocol.TField("credentialStoreToken", org.apache.thrift.protocol.TType.STRING, (short)3);
  private static final org.apache.thrift.protocol.TField USER_COMPUTE_RESOURCE_PREFERENCES_FIELD_DESC = new org.apache.thrift.protocol.TField("userComputeResourcePreferences", org.apache.thrift.protocol.TType.LIST, (short)4);
  private static final org.apache.thrift.protocol.TField USER_STORAGE_PREFERENCES_FIELD_DESC = new org.apache.thrift.protocol.TField("userStoragePreferences", org.apache.thrift.protocol.TType.LIST, (short)5);
  private static final org.apache.thrift.protocol.TField IDENTITY_SERVER_TENANT_FIELD_DESC = new org.apache.thrift.protocol.TField("identityServerTenant", org.apache.thrift.protocol.TType.STRING, (short)6);
  private static final org.apache.thrift.protocol.TField IDENTITY_SERVER_PWD_CRED_TOKEN_FIELD_DESC = new org.apache.thrift.protocol.TField("identityServerPwdCredToken", org.apache.thrift.protocol.TType.STRING, (short)7);
  private static final org.apache.thrift.protocol.TField IS_NULL_FIELD_DESC = new org.apache.thrift.protocol.TField("isNull", org.apache.thrift.protocol.TType.BOOL, (short)8);

  private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
  static {
    schemes.put(StandardScheme.class, new UserResourceProfileStandardSchemeFactory());
    schemes.put(TupleScheme.class, new UserResourceProfileTupleSchemeFactory());
  }

  private String userId; // required
  private String gatewayID; // required
  private String credentialStoreToken; // optional
  private List<UserComputeResourcePreference> userComputeResourcePreferences; // optional
  private List<UserStoragePreference> userStoragePreferences; // optional
  private String identityServerTenant; // optional
  private String identityServerPwdCredToken; // optional
  private boolean isNull; // optional

  /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
  public enum _Fields implements org.apache.thrift.TFieldIdEnum {
    USER_ID((short)1, "userId"),
    GATEWAY_ID((short)2, "gatewayID"),
    CREDENTIAL_STORE_TOKEN((short)3, "credentialStoreToken"),
    USER_COMPUTE_RESOURCE_PREFERENCES((short)4, "userComputeResourcePreferences"),
    USER_STORAGE_PREFERENCES((short)5, "userStoragePreferences"),
    IDENTITY_SERVER_TENANT((short)6, "identityServerTenant"),
    IDENTITY_SERVER_PWD_CRED_TOKEN((short)7, "identityServerPwdCredToken"),
    IS_NULL((short)8, "isNull");

    private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

    static {
      for (_Fields field : EnumSet.allOf(_Fields.class)) {
        byName.put(field.getFieldName(), field);
      }
    }

    /**
     * Find the _Fields constant that matches fieldId, or null if its not found.
     */
    public static _Fields findByThriftId(int fieldId) {
      switch(fieldId) {
        case 1: // USER_ID
          return USER_ID;
        case 2: // GATEWAY_ID
          return GATEWAY_ID;
        case 3: // CREDENTIAL_STORE_TOKEN
          return CREDENTIAL_STORE_TOKEN;
        case 4: // USER_COMPUTE_RESOURCE_PREFERENCES
          return USER_COMPUTE_RESOURCE_PREFERENCES;
        case 5: // USER_STORAGE_PREFERENCES
          return USER_STORAGE_PREFERENCES;
        case 6: // IDENTITY_SERVER_TENANT
          return IDENTITY_SERVER_TENANT;
        case 7: // IDENTITY_SERVER_PWD_CRED_TOKEN
          return IDENTITY_SERVER_PWD_CRED_TOKEN;
        case 8: // IS_NULL
          return IS_NULL;
        default:
          return null;
      }
    }

    /**
     * Find the _Fields constant that matches fieldId, throwing an exception
     * if it is not found.
     */
    public static _Fields findByThriftIdOrThrow(int fieldId) {
      _Fields fields = findByThriftId(fieldId);
      if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
      return fields;
    }

    /**
     * Find the _Fields constant that matches name, or null if its not found.
     */
    public static _Fields findByName(String name) {
      return byName.get(name);
    }

    private final short _thriftId;
    private final String _fieldName;

    _Fields(short thriftId, String fieldName) {
      _thriftId = thriftId;
      _fieldName = fieldName;
    }

    public short getThriftFieldId() {
      return _thriftId;
    }

    public String getFieldName() {
      return _fieldName;
    }
  }

  // isset id assignments
  private static final int __ISNULL_ISSET_ID = 0;
  private byte __isset_bitfield = 0;
  private static final _Fields optionals[] = {_Fields.CREDENTIAL_STORE_TOKEN,_Fields.USER_COMPUTE_RESOURCE_PREFERENCES,_Fields.USER_STORAGE_PREFERENCES,_Fields.IDENTITY_SERVER_TENANT,_Fields.IDENTITY_SERVER_PWD_CRED_TOKEN,_Fields.IS_NULL};
  public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
  static {
    Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
    tmpMap.put(_Fields.USER_ID, new org.apache.thrift.meta_data.FieldMetaData("userId", org.apache.thrift.TFieldRequirementType.REQUIRED, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
    tmpMap.put(_Fields.GATEWAY_ID, new org.apache.thrift.meta_data.FieldMetaData("gatewayID", org.apache.thrift.TFieldRequirementType.REQUIRED, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
    tmpMap.put(_Fields.CREDENTIAL_STORE_TOKEN, new org.apache.thrift.meta_data.FieldMetaData("credentialStoreToken", org.apache.thrift.TFieldRequirementType.OPTIONAL, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
    tmpMap.put(_Fields.USER_COMPUTE_RESOURCE_PREFERENCES, new org.apache.thrift.meta_data.FieldMetaData("userComputeResourcePreferences", org.apache.thrift.TFieldRequirementType.OPTIONAL, 
        new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
            new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, UserComputeResourcePreference.class))));
    tmpMap.put(_Fields.USER_STORAGE_PREFERENCES, new org.apache.thrift.meta_data.FieldMetaData("userStoragePreferences", org.apache.thrift.TFieldRequirementType.OPTIONAL, 
        new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
            new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, UserStoragePreference.class))));
    tmpMap.put(_Fields.IDENTITY_SERVER_TENANT, new org.apache.thrift.meta_data.FieldMetaData("identityServerTenant", org.apache.thrift.TFieldRequirementType.OPTIONAL, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
    tmpMap.put(_Fields.IDENTITY_SERVER_PWD_CRED_TOKEN, new org.apache.thrift.meta_data.FieldMetaData("identityServerPwdCredToken", org.apache.thrift.TFieldRequirementType.OPTIONAL, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
    tmpMap.put(_Fields.IS_NULL, new org.apache.thrift.meta_data.FieldMetaData("isNull", org.apache.thrift.TFieldRequirementType.OPTIONAL, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
    metaDataMap = Collections.unmodifiableMap(tmpMap);
    org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(UserResourceProfile.class, metaDataMap);
  }

  public UserResourceProfile() {
    this.isNull = false;

  }

  public UserResourceProfile(
    String userId,
    String gatewayID)
  {
    this();
    this.userId = userId;
    this.gatewayID = gatewayID;
  }

  /**
   * Performs a deep copy on <i>other</i>.
   */
  public UserResourceProfile(UserResourceProfile other) {
    __isset_bitfield = other.__isset_bitfield;
    if (other.isSetUserId()) {
      this.userId = other.userId;
    }
    if (other.isSetGatewayID()) {
      this.gatewayID = other.gatewayID;
    }
    if (other.isSetCredentialStoreToken()) {
      this.credentialStoreToken = other.credentialStoreToken;
    }
    if (other.isSetUserComputeResourcePreferences()) {
      List<UserComputeResourcePreference> __this__userComputeResourcePreferences = new ArrayList<UserComputeResourcePreference>(other.userComputeResourcePreferences.size());
      for (UserComputeResourcePreference other_element : other.userComputeResourcePreferences) {
        __this__userComputeResourcePreferences.add(new UserComputeResourcePreference(other_element));
      }
      this.userComputeResourcePreferences = __this__userComputeResourcePreferences;
    }
    if (other.isSetUserStoragePreferences()) {
      List<UserStoragePreference> __this__userStoragePreferences = new ArrayList<UserStoragePreference>(other.userStoragePreferences.size());
      for (UserStoragePreference other_element : other.userStoragePreferences) {
        __this__userStoragePreferences.add(new UserStoragePreference(other_element));
      }
      this.userStoragePreferences = __this__userStoragePreferences;
    }
    if (other.isSetIdentityServerTenant()) {
      this.identityServerTenant = other.identityServerTenant;
    }
    if (other.isSetIdentityServerPwdCredToken()) {
      this.identityServerPwdCredToken = other.identityServerPwdCredToken;
    }
    this.isNull = other.isNull;
  }

  public UserResourceProfile deepCopy() {
    return new UserResourceProfile(this);
  }

  @Override
  public void clear() {
    this.userId = null;
    this.gatewayID = null;
    this.credentialStoreToken = null;
    this.userComputeResourcePreferences = null;
    this.userStoragePreferences = null;
    this.identityServerTenant = null;
    this.identityServerPwdCredToken = null;
    this.isNull = false;

  }

  public String getUserId() {
    return this.userId;
  }

  public void setUserId(String userId) {
    this.userId = userId;
  }

  public void unsetUserId() {
    this.userId = null;
  }

  /** Returns true if field userId is set (has been assigned a value) and false otherwise */
  public boolean isSetUserId() {
    return this.userId != null;
  }

  public void setUserIdIsSet(boolean value) {
    if (!value) {
      this.userId = null;
    }
  }

  public String getGatewayID() {
    return this.gatewayID;
  }

  public void setGatewayID(String gatewayID) {
    this.gatewayID = gatewayID;
  }

  public void unsetGatewayID() {
    this.gatewayID = null;
  }

  /** Returns true if field gatewayID is set (has been assigned a value) and false otherwise */
  public boolean isSetGatewayID() {
    return this.gatewayID != null;
  }

  public void setGatewayIDIsSet(boolean value) {
    if (!value) {
      this.gatewayID = null;
    }
  }

  public String getCredentialStoreToken() {
    return this.credentialStoreToken;
  }

  public void setCredentialStoreToken(String credentialStoreToken) {
    this.credentialStoreToken = credentialStoreToken;
  }

  public void unsetCredentialStoreToken() {
    this.credentialStoreToken = null;
  }

  /** Returns true if field credentialStoreToken is set (has been assigned a value) and false otherwise */
  public boolean isSetCredentialStoreToken() {
    return this.credentialStoreToken != null;
  }

  public void setCredentialStoreTokenIsSet(boolean value) {
    if (!value) {
      this.credentialStoreToken = null;
    }
  }

  public int getUserComputeResourcePreferencesSize() {
    return (this.userComputeResourcePreferences == null) ? 0 : this.userComputeResourcePreferences.size();
  }

  public java.util.Iterator<UserComputeResourcePreference> getUserComputeResourcePreferencesIterator() {
    return (this.userComputeResourcePreferences == null) ? null : this.userComputeResourcePreferences.iterator();
  }

  public void addToUserComputeResourcePreferences(UserComputeResourcePreference elem) {
    if (this.userComputeResourcePreferences == null) {
      this.userComputeResourcePreferences = new ArrayList<UserComputeResourcePreference>();
    }
    this.userComputeResourcePreferences.add(elem);
  }

  public List<UserComputeResourcePreference> getUserComputeResourcePreferences() {
    return this.userComputeResourcePreferences;
  }

  public void setUserComputeResourcePreferences(List<UserComputeResourcePreference> userComputeResourcePreferences) {
    this.userComputeResourcePreferences = userComputeResourcePreferences;
  }

  public void unsetUserComputeResourcePreferences() {
    this.userComputeResourcePreferences = null;
  }

  /** Returns true if field userComputeResourcePreferences is set (has been assigned a value) and false otherwise */
  public boolean isSetUserComputeResourcePreferences() {
    return this.userComputeResourcePreferences != null;
  }

  public void setUserComputeResourcePreferencesIsSet(boolean value) {
    if (!value) {
      this.userComputeResourcePreferences = null;
    }
  }

  public int getUserStoragePreferencesSize() {
    return (this.userStoragePreferences == null) ? 0 : this.userStoragePreferences.size();
  }

  public java.util.Iterator<UserStoragePreference> getUserStoragePreferencesIterator() {
    return (this.userStoragePreferences == null) ? null : this.userStoragePreferences.iterator();
  }

  public void addToUserStoragePreferences(UserStoragePreference elem) {
    if (this.userStoragePreferences == null) {
      this.userStoragePreferences = new ArrayList<UserStoragePreference>();
    }
    this.userStoragePreferences.add(elem);
  }

  public List<UserStoragePreference> getUserStoragePreferences() {
    return this.userStoragePreferences;
  }

  public void setUserStoragePreferences(List<UserStoragePreference> userStoragePreferences) {
    this.userStoragePreferences = userStoragePreferences;
  }

  public void unsetUserStoragePreferences() {
    this.userStoragePreferences = null;
  }

  /** Returns true if field userStoragePreferences is set (has been assigned a value) and false otherwise */
  public boolean isSetUserStoragePreferences() {
    return this.userStoragePreferences != null;
  }

  public void setUserStoragePreferencesIsSet(boolean value) {
    if (!value) {
      this.userStoragePreferences = null;
    }
  }

  public String getIdentityServerTenant() {
    return this.identityServerTenant;
  }

  public void setIdentityServerTenant(String identityServerTenant) {
    this.identityServerTenant = identityServerTenant;
  }

  public void unsetIdentityServerTenant() {
    this.identityServerTenant = null;
  }

  /** Returns true if field identityServerTenant is set (has been assigned a value) and false otherwise */
  public boolean isSetIdentityServerTenant() {
    return this.identityServerTenant != null;
  }

  public void setIdentityServerTenantIsSet(boolean value) {
    if (!value) {
      this.identityServerTenant = null;
    }
  }

  public String getIdentityServerPwdCredToken() {
    return this.identityServerPwdCredToken;
  }

  public void setIdentityServerPwdCredToken(String identityServerPwdCredToken) {
    this.identityServerPwdCredToken = identityServerPwdCredToken;
  }

  public void unsetIdentityServerPwdCredToken() {
    this.identityServerPwdCredToken = null;
  }

  /** Returns true if field identityServerPwdCredToken is set (has been assigned a value) and false otherwise */
  public boolean isSetIdentityServerPwdCredToken() {
    return this.identityServerPwdCredToken != null;
  }

  public void setIdentityServerPwdCredTokenIsSet(boolean value) {
    if (!value) {
      this.identityServerPwdCredToken = null;
    }
  }

  public boolean isIsNull() {
    return this.isNull;
  }

  public void setIsNull(boolean isNull) {
    this.isNull = isNull;
    setIsNullIsSet(true);
  }

  public void unsetIsNull() {
    __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __ISNULL_ISSET_ID);
  }

  /** Returns true if field isNull is set (has been assigned a value) and false otherwise */
  public boolean isSetIsNull() {
    return EncodingUtils.testBit(__isset_bitfield, __ISNULL_ISSET_ID);
  }

  public void setIsNullIsSet(boolean value) {
    __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __ISNULL_ISSET_ID, value);
  }

  public void setFieldValue(_Fields field, Object value) {
    switch (field) {
    case USER_ID:
      if (value == null) {
        unsetUserId();
      } else {
        setUserId((String)value);
      }
      break;

    case GATEWAY_ID:
      if (value == null) {
        unsetGatewayID();
      } else {
        setGatewayID((String)value);
      }
      break;

    case CREDENTIAL_STORE_TOKEN:
      if (value == null) {
        unsetCredentialStoreToken();
      } else {
        setCredentialStoreToken((String)value);
      }
      break;

    case USER_COMPUTE_RESOURCE_PREFERENCES:
      if (value == null) {
        unsetUserComputeResourcePreferences();
      } else {
        setUserComputeResourcePreferences((List<UserComputeResourcePreference>)value);
      }
      break;

    case USER_STORAGE_PREFERENCES:
      if (value == null) {
        unsetUserStoragePreferences();
      } else {
        setUserStoragePreferences((List<UserStoragePreference>)value);
      }
      break;

    case IDENTITY_SERVER_TENANT:
      if (value == null) {
        unsetIdentityServerTenant();
      } else {
        setIdentityServerTenant((String)value);
      }
      break;

    case IDENTITY_SERVER_PWD_CRED_TOKEN:
      if (value == null) {
        unsetIdentityServerPwdCredToken();
      } else {
        setIdentityServerPwdCredToken((String)value);
      }
      break;

    case IS_NULL:
      if (value == null) {
        unsetIsNull();
      } else {
        setIsNull((Boolean)value);
      }
      break;

    }
  }

  public Object getFieldValue(_Fields field) {
    switch (field) {
    case USER_ID:
      return getUserId();

    case GATEWAY_ID:
      return getGatewayID();

    case CREDENTIAL_STORE_TOKEN:
      return getCredentialStoreToken();

    case USER_COMPUTE_RESOURCE_PREFERENCES:
      return getUserComputeResourcePreferences();

    case USER_STORAGE_PREFERENCES:
      return getUserStoragePreferences();

    case IDENTITY_SERVER_TENANT:
      return getIdentityServerTenant();

    case IDENTITY_SERVER_PWD_CRED_TOKEN:
      return getIdentityServerPwdCredToken();

    case IS_NULL:
      return isIsNull();

    }
    throw new IllegalStateException();
  }

  /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
  public boolean isSet(_Fields field) {
    if (field == null) {
      throw new IllegalArgumentException();
    }

    switch (field) {
    case USER_ID:
      return isSetUserId();
    case GATEWAY_ID:
      return isSetGatewayID();
    case CREDENTIAL_STORE_TOKEN:
      return isSetCredentialStoreToken();
    case USER_COMPUTE_RESOURCE_PREFERENCES:
      return isSetUserComputeResourcePreferences();
    case USER_STORAGE_PREFERENCES:
      return isSetUserStoragePreferences();
    case IDENTITY_SERVER_TENANT:
      return isSetIdentityServerTenant();
    case IDENTITY_SERVER_PWD_CRED_TOKEN:
      return isSetIdentityServerPwdCredToken();
    case IS_NULL:
      return isSetIsNull();
    }
    throw new IllegalStateException();
  }

  @Override
  public boolean equals(Object that) {
    if (that == null)
      return false;
    if (that instanceof UserResourceProfile)
      return this.equals((UserResourceProfile)that);
    return false;
  }

  public boolean equals(UserResourceProfile that) {
    if (that == null)
      return false;

    boolean this_present_userId = true && this.isSetUserId();
    boolean that_present_userId = true && that.isSetUserId();
    if (this_present_userId || that_present_userId) {
      if (!(this_present_userId && that_present_userId))
        return false;
      if (!this.userId.equals(that.userId))
        return false;
    }

    boolean this_present_gatewayID = true && this.isSetGatewayID();
    boolean that_present_gatewayID = true && that.isSetGatewayID();
    if (this_present_gatewayID || that_present_gatewayID) {
      if (!(this_present_gatewayID && that_present_gatewayID))
        return false;
      if (!this.gatewayID.equals(that.gatewayID))
        return false;
    }

    boolean this_present_credentialStoreToken = true && this.isSetCredentialStoreToken();
    boolean that_present_credentialStoreToken = true && that.isSetCredentialStoreToken();
    if (this_present_credentialStoreToken || that_present_credentialStoreToken) {
      if (!(this_present_credentialStoreToken && that_present_credentialStoreToken))
        return false;
      if (!this.credentialStoreToken.equals(that.credentialStoreToken))
        return false;
    }

    boolean this_present_userComputeResourcePreferences = true && this.isSetUserComputeResourcePreferences();
    boolean that_present_userComputeResourcePreferences = true && that.isSetUserComputeResourcePreferences();
    if (this_present_userComputeResourcePreferences || that_present_userComputeResourcePreferences) {
      if (!(this_present_userComputeResourcePreferences && that_present_userComputeResourcePreferences))
        return false;
      if (!this.userComputeResourcePreferences.equals(that.userComputeResourcePreferences))
        return false;
    }

    boolean this_present_userStoragePreferences = true && this.isSetUserStoragePreferences();
    boolean that_present_userStoragePreferences = true && that.isSetUserStoragePreferences();
    if (this_present_userStoragePreferences || that_present_userStoragePreferences) {
      if (!(this_present_userStoragePreferences && that_present_userStoragePreferences))
        return false;
      if (!this.userStoragePreferences.equals(that.userStoragePreferences))
        return false;
    }

    boolean this_present_identityServerTenant = true && this.isSetIdentityServerTenant();
    boolean that_present_identityServerTenant = true && that.isSetIdentityServerTenant();
    if (this_present_identityServerTenant || that_present_identityServerTenant) {
      if (!(this_present_identityServerTenant && that_present_identityServerTenant))
        return false;
      if (!this.identityServerTenant.equals(that.identityServerTenant))
        return false;
    }

    boolean this_present_identityServerPwdCredToken = true && this.isSetIdentityServerPwdCredToken();
    boolean that_present_identityServerPwdCredToken = true && that.isSetIdentityServerPwdCredToken();
    if (this_present_identityServerPwdCredToken || that_present_identityServerPwdCredToken) {
      if (!(this_present_identityServerPwdCredToken && that_present_identityServerPwdCredToken))
        return false;
      if (!this.identityServerPwdCredToken.equals(that.identityServerPwdCredToken))
        return false;
    }

    boolean this_present_isNull = true && this.isSetIsNull();
    boolean that_present_isNull = true && that.isSetIsNull();
    if (this_present_isNull || that_present_isNull) {
      if (!(this_present_isNull && that_present_isNull))
        return false;
      if (this.isNull != that.isNull)
        return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    List<Object> list = new ArrayList<Object>();

    boolean present_userId = true && (isSetUserId());
    list.add(present_userId);
    if (present_userId)
      list.add(userId);

    boolean present_gatewayID = true && (isSetGatewayID());
    list.add(present_gatewayID);
    if (present_gatewayID)
      list.add(gatewayID);

    boolean present_credentialStoreToken = true && (isSetCredentialStoreToken());
    list.add(present_credentialStoreToken);
    if (present_credentialStoreToken)
      list.add(credentialStoreToken);

    boolean present_userComputeResourcePreferences = true && (isSetUserComputeResourcePreferences());
    list.add(present_userComputeResourcePreferences);
    if (present_userComputeResourcePreferences)
      list.add(userComputeResourcePreferences);

    boolean present_userStoragePreferences = true && (isSetUserStoragePreferences());
    list.add(present_userStoragePreferences);
    if (present_userStoragePreferences)
      list.add(userStoragePreferences);

    boolean present_identityServerTenant = true && (isSetIdentityServerTenant());
    list.add(present_identityServerTenant);
    if (present_identityServerTenant)
      list.add(identityServerTenant);

    boolean present_identityServerPwdCredToken = true && (isSetIdentityServerPwdCredToken());
    list.add(present_identityServerPwdCredToken);
    if (present_identityServerPwdCredToken)
      list.add(identityServerPwdCredToken);

    boolean present_isNull = true && (isSetIsNull());
    list.add(present_isNull);
    if (present_isNull)
      list.add(isNull);

    return list.hashCode();
  }

  @Override
  public int compareTo(UserResourceProfile other) {
    if (!getClass().equals(other.getClass())) {
      return getClass().getName().compareTo(other.getClass().getName());
    }

    int lastComparison = 0;

    lastComparison = Boolean.valueOf(isSetUserId()).compareTo(other.isSetUserId());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetUserId()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.userId, other.userId);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetGatewayID()).compareTo(other.isSetGatewayID());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetGatewayID()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.gatewayID, other.gatewayID);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetCredentialStoreToken()).compareTo(other.isSetCredentialStoreToken());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetCredentialStoreToken()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.credentialStoreToken, other.credentialStoreToken);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetUserComputeResourcePreferences()).compareTo(other.isSetUserComputeResourcePreferences());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetUserComputeResourcePreferences()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.userComputeResourcePreferences, other.userComputeResourcePreferences);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetUserStoragePreferences()).compareTo(other.isSetUserStoragePreferences());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetUserStoragePreferences()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.userStoragePreferences, other.userStoragePreferences);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetIdentityServerTenant()).compareTo(other.isSetIdentityServerTenant());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetIdentityServerTenant()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.identityServerTenant, other.identityServerTenant);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetIdentityServerPwdCredToken()).compareTo(other.isSetIdentityServerPwdCredToken());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetIdentityServerPwdCredToken()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.identityServerPwdCredToken, other.identityServerPwdCredToken);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetIsNull()).compareTo(other.isSetIsNull());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetIsNull()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.isNull, other.isNull);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    return 0;
  }

  public _Fields fieldForId(int fieldId) {
    return _Fields.findByThriftId(fieldId);
  }

  public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
    schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
  }

  public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
    schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder("UserResourceProfile(");
    boolean first = true;

    sb.append("userId:");
    if (this.userId == null) {
      sb.append("null");
    } else {
      sb.append(this.userId);
    }
    first = false;
    if (!first) sb.append(", ");
    sb.append("gatewayID:");
    if (this.gatewayID == null) {
      sb.append("null");
    } else {
      sb.append(this.gatewayID);
    }
    first = false;
    if (isSetCredentialStoreToken()) {
      if (!first) sb.append(", ");
      sb.append("credentialStoreToken:");
      if (this.credentialStoreToken == null) {
        sb.append("null");
      } else {
        sb.append(this.credentialStoreToken);
      }
      first = false;
    }
    if (isSetUserComputeResourcePreferences()) {
      if (!first) sb.append(", ");
      sb.append("userComputeResourcePreferences:");
      if (this.userComputeResourcePreferences == null) {
        sb.append("null");
      } else {
        sb.append(this.userComputeResourcePreferences);
      }
      first = false;
    }
    if (isSetUserStoragePreferences()) {
      if (!first) sb.append(", ");
      sb.append("userStoragePreferences:");
      if (this.userStoragePreferences == null) {
        sb.append("null");
      } else {
        sb.append(this.userStoragePreferences);
      }
      first = false;
    }
    if (isSetIdentityServerTenant()) {
      if (!first) sb.append(", ");
      sb.append("identityServerTenant:");
      if (this.identityServerTenant == null) {
        sb.append("null");
      } else {
        sb.append(this.identityServerTenant);
      }
      first = false;
    }
    if (isSetIdentityServerPwdCredToken()) {
      if (!first) sb.append(", ");
      sb.append("identityServerPwdCredToken:");
      if (this.identityServerPwdCredToken == null) {
        sb.append("null");
      } else {
        sb.append(this.identityServerPwdCredToken);
      }
      first = false;
    }
    if (isSetIsNull()) {
      if (!first) sb.append(", ");
      sb.append("isNull:");
      sb.append(this.isNull);
      first = false;
    }
    sb.append(")");
    return sb.toString();
  }

  public void validate() throws org.apache.thrift.TException {
    // check for required fields
    if (!isSetUserId()) {
      throw new org.apache.thrift.protocol.TProtocolException("Required field 'userId' is unset! Struct:" + toString());
    }

    if (!isSetGatewayID()) {
      throw new org.apache.thrift.protocol.TProtocolException("Required field 'gatewayID' is unset! Struct:" + toString());
    }

    // check for sub-struct validity
  }

  private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
    try {
      write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
    } catch (org.apache.thrift.TException te) {
      throw new java.io.IOException(te);
    }
  }

  private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
    try {
      // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
      __isset_bitfield = 0;
      read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
    } catch (org.apache.thrift.TException te) {
      throw new java.io.IOException(te);
    }
  }

  private static class UserResourceProfileStandardSchemeFactory implements SchemeFactory {
    public UserResourceProfileStandardScheme getScheme() {
      return new UserResourceProfileStandardScheme();
    }
  }

  private static class UserResourceProfileStandardScheme extends StandardScheme<UserResourceProfile> {

    public void read(org.apache.thrift.protocol.TProtocol iprot, UserResourceProfile struct) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField schemeField;
      iprot.readStructBegin();
      while (true)
      {
        schemeField = iprot.readFieldBegin();
        if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
          break;
        }
        switch (schemeField.id) {
          case 1: // USER_ID
            if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
              struct.userId = iprot.readString();
              struct.setUserIdIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 2: // GATEWAY_ID
            if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
              struct.gatewayID = iprot.readString();
              struct.setGatewayIDIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 3: // CREDENTIAL_STORE_TOKEN
            if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
              struct.credentialStoreToken = iprot.readString();
              struct.setCredentialStoreTokenIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 4: // USER_COMPUTE_RESOURCE_PREFERENCES
            if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
              {
                org.apache.thrift.protocol.TList _list0 = iprot.readListBegin();
                struct.userComputeResourcePreferences = new ArrayList<UserComputeResourcePreference>(_list0.size);
                UserComputeResourcePreference _elem1;
                for (int _i2 = 0; _i2 < _list0.size; ++_i2)
                {
                  _elem1 = new UserComputeResourcePreference();
                  _elem1.read(iprot);
                  struct.userComputeResourcePreferences.add(_elem1);
                }
                iprot.readListEnd();
              }
              struct.setUserComputeResourcePreferencesIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 5: // USER_STORAGE_PREFERENCES
            if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
              {
                org.apache.thrift.protocol.TList _list3 = iprot.readListBegin();
                struct.userStoragePreferences = new ArrayList<UserStoragePreference>(_list3.size);
                UserStoragePreference _elem4;
                for (int _i5 = 0; _i5 < _list3.size; ++_i5)
                {
                  _elem4 = new UserStoragePreference();
                  _elem4.read(iprot);
                  struct.userStoragePreferences.add(_elem4);
                }
                iprot.readListEnd();
              }
              struct.setUserStoragePreferencesIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 6: // IDENTITY_SERVER_TENANT
            if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
              struct.identityServerTenant = iprot.readString();
              struct.setIdentityServerTenantIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 7: // IDENTITY_SERVER_PWD_CRED_TOKEN
            if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
              struct.identityServerPwdCredToken = iprot.readString();
              struct.setIdentityServerPwdCredTokenIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 8: // IS_NULL
            if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
              struct.isNull = iprot.readBool();
              struct.setIsNullIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
      struct.validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot, UserResourceProfile struct) throws org.apache.thrift.TException {
      struct.validate();

      oprot.writeStructBegin(STRUCT_DESC);
      if (struct.userId != null) {
        oprot.writeFieldBegin(USER_ID_FIELD_DESC);
        oprot.writeString(struct.userId);
        oprot.writeFieldEnd();
      }
      if (struct.gatewayID != null) {
        oprot.writeFieldBegin(GATEWAY_ID_FIELD_DESC);
        oprot.writeString(struct.gatewayID);
        oprot.writeFieldEnd();
      }
      if (struct.credentialStoreToken != null) {
        if (struct.isSetCredentialStoreToken()) {
          oprot.writeFieldBegin(CREDENTIAL_STORE_TOKEN_FIELD_DESC);
          oprot.writeString(struct.credentialStoreToken);
          oprot.writeFieldEnd();
        }
      }
      if (struct.userComputeResourcePreferences != null) {
        if (struct.isSetUserComputeResourcePreferences()) {
          oprot.writeFieldBegin(USER_COMPUTE_RESOURCE_PREFERENCES_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.userComputeResourcePreferences.size()));
            for (UserComputeResourcePreference _iter6 : struct.userComputeResourcePreferences)
            {
              _iter6.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
      }
      if (struct.userStoragePreferences != null) {
        if (struct.isSetUserStoragePreferences()) {
          oprot.writeFieldBegin(USER_STORAGE_PREFERENCES_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.userStoragePreferences.size()));
            for (UserStoragePreference _iter7 : struct.userStoragePreferences)
            {
              _iter7.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
      }
      if (struct.identityServerTenant != null) {
        if (struct.isSetIdentityServerTenant()) {
          oprot.writeFieldBegin(IDENTITY_SERVER_TENANT_FIELD_DESC);
          oprot.writeString(struct.identityServerTenant);
          oprot.writeFieldEnd();
        }
      }
      if (struct.identityServerPwdCredToken != null) {
        if (struct.isSetIdentityServerPwdCredToken()) {
          oprot.writeFieldBegin(IDENTITY_SERVER_PWD_CRED_TOKEN_FIELD_DESC);
          oprot.writeString(struct.identityServerPwdCredToken);
          oprot.writeFieldEnd();
        }
      }
      if (struct.isSetIsNull()) {
        oprot.writeFieldBegin(IS_NULL_FIELD_DESC);
        oprot.writeBool(struct.isNull);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

  }

  private static class UserResourceProfileTupleSchemeFactory implements SchemeFactory {
    public UserResourceProfileTupleScheme getScheme() {
      return new UserResourceProfileTupleScheme();
    }
  }

  private static class UserResourceProfileTupleScheme extends TupleScheme<UserResourceProfile> {

    @Override
    public void write(org.apache.thrift.protocol.TProtocol prot, UserResourceProfile struct) throws org.apache.thrift.TException {
      TTupleProtocol oprot = (TTupleProtocol) prot;
      oprot.writeString(struct.userId);
      oprot.writeString(struct.gatewayID);
      BitSet optionals = new BitSet();
      if (struct.isSetCredentialStoreToken()) {
        optionals.set(0);
      }
      if (struct.isSetUserComputeResourcePreferences()) {
        optionals.set(1);
      }
      if (struct.isSetUserStoragePreferences()) {
        optionals.set(2);
      }
      if (struct.isSetIdentityServerTenant()) {
        optionals.set(3);
      }
      if (struct.isSetIdentityServerPwdCredToken()) {
        optionals.set(4);
      }
      if (struct.isSetIsNull()) {
        optionals.set(5);
      }
      oprot.writeBitSet(optionals, 6);
      if (struct.isSetCredentialStoreToken()) {
        oprot.writeString(struct.credentialStoreToken);
      }
      if (struct.isSetUserComputeResourcePreferences()) {
        {
          oprot.writeI32(struct.userComputeResourcePreferences.size());
          for (UserComputeResourcePreference _iter8 : struct.userComputeResourcePreferences)
          {
            _iter8.write(oprot);
          }
        }
      }
      if (struct.isSetUserStoragePreferences()) {
        {
          oprot.writeI32(struct.userStoragePreferences.size());
          for (UserStoragePreference _iter9 : struct.userStoragePreferences)
          {
            _iter9.write(oprot);
          }
        }
      }
      if (struct.isSetIdentityServerTenant()) {
        oprot.writeString(struct.identityServerTenant);
      }
      if (struct.isSetIdentityServerPwdCredToken()) {
        oprot.writeString(struct.identityServerPwdCredToken);
      }
      if (struct.isSetIsNull()) {
        oprot.writeBool(struct.isNull);
      }
    }

    @Override
    public void read(org.apache.thrift.protocol.TProtocol prot, UserResourceProfile struct) throws org.apache.thrift.TException {
      TTupleProtocol iprot = (TTupleProtocol) prot;
      struct.userId = iprot.readString();
      struct.setUserIdIsSet(true);
      struct.gatewayID = iprot.readString();
      struct.setGatewayIDIsSet(true);
      BitSet incoming = iprot.readBitSet(6);
      if (incoming.get(0)) {
        struct.credentialStoreToken = iprot.readString();
        struct.setCredentialStoreTokenIsSet(true);
      }
      if (incoming.get(1)) {
        {
          org.apache.thrift.protocol.TList _list10 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
          struct.userComputeResourcePreferences = new ArrayList<UserComputeResourcePreference>(_list10.size);
          UserComputeResourcePreference _elem11;
          for (int _i12 = 0; _i12 < _list10.size; ++_i12)
          {
            _elem11 = new UserComputeResourcePreference();
            _elem11.read(iprot);
            struct.userComputeResourcePreferences.add(_elem11);
          }
        }
        struct.setUserComputeResourcePreferencesIsSet(true);
      }
      if (incoming.get(2)) {
        {
          org.apache.thrift.protocol.TList _list13 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
          struct.userStoragePreferences = new ArrayList<UserStoragePreference>(_list13.size);
          UserStoragePreference _elem14;
          for (int _i15 = 0; _i15 < _list13.size; ++_i15)
          {
            _elem14 = new UserStoragePreference();
            _elem14.read(iprot);
            struct.userStoragePreferences.add(_elem14);
          }
        }
        struct.setUserStoragePreferencesIsSet(true);
      }
      if (incoming.get(3)) {
        struct.identityServerTenant = iprot.readString();
        struct.setIdentityServerTenantIsSet(true);
      }
      if (incoming.get(4)) {
        struct.identityServerPwdCredToken = iprot.readString();
        struct.setIdentityServerPwdCredTokenIsSet(true);
      }
      if (incoming.get(5)) {
        struct.isNull = iprot.readBool();
        struct.setIsNullIsSet(true);
      }
    }
  }

}

