/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.experiment.catalog.resources;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.model.status.ProcessState;
import org.apache.airavata.registry.core.experiment.catalog.ExpCatResourceUtils;
import org.apache.airavata.registry.core.experiment.catalog.ExperimentCatResource;
import org.apache.airavata.registry.core.experiment.catalog.ResourceType;
import org.apache.airavata.registry.core.experiment.catalog.model.Job;
import org.apache.airavata.registry.core.experiment.catalog.model.Process;
import org.apache.airavata.registry.core.experiment.catalog.model.ProcessError;
import org.apache.airavata.registry.core.experiment.catalog.model.ProcessInput;
import org.apache.airavata.registry.core.experiment.catalog.model.ProcessOutput;
import org.apache.airavata.registry.core.experiment.catalog.model.ProcessResourceSchedule;
import org.apache.airavata.registry.core.experiment.catalog.model.ProcessStatus;
import org.apache.airavata.registry.core.experiment.catalog.model.Task;
import org.apache.airavata.registry.core.experiment.catalog.resources.AbstractExpCatResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.JobResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.ProcessErrorResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.ProcessInputResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.ProcessOutputResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.ProcessResourceScheduleResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.ProcessStatusResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.TaskResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.Utils;
import org.apache.airavata.registry.core.experiment.catalog.utils.QueryGenerator;
import org.apache.airavata.registry.cpi.RegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessResource
extends AbstractExpCatResource {
    private static final Logger logger = LoggerFactory.getLogger(ProcessResource.class);
    private String processId;
    private String experimentId;
    private Timestamp creationTime;
    private Timestamp lastUpdateTime;
    private String processDetail;
    private String applicationInterfaceId;
    private String taskDag;
    private String applicationDeploymentId;
    private String computeResourceId;
    private String gatewayExecutionId;
    private boolean enableEmailNotification;
    private String emailAddresses;
    private String storageResourceId;
    private String userDn;
    private String userName;
    private boolean generateCert;
    private String experimentDataDir;
    private boolean useUserCRPref;

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public String getExperimentId() {
        return this.experimentId;
    }

    public void setExperimentId(String experimentId) {
        this.experimentId = experimentId;
    }

    public Timestamp getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Timestamp creationTime) {
        this.creationTime = creationTime;
    }

    public Timestamp getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(Timestamp lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public String getProcessDetail() {
        return this.processDetail;
    }

    public void setProcessDetail(String processDetail) {
        this.processDetail = processDetail;
    }

    public String getApplicationInterfaceId() {
        return this.applicationInterfaceId;
    }

    public void setApplicationInterfaceId(String applicationInterfaceId) {
        this.applicationInterfaceId = applicationInterfaceId;
    }

    public String getTaskDag() {
        return this.taskDag;
    }

    public void setTaskDag(String taskDag) {
        this.taskDag = taskDag;
    }

    public String getApplicationDeploymentId() {
        return this.applicationDeploymentId;
    }

    public void setApplicationDeploymentId(String applicationDeploymentId) {
        this.applicationDeploymentId = applicationDeploymentId;
    }

    public String getComputeResourceId() {
        return this.computeResourceId;
    }

    public void setComputeResourceId(String computeResourceId) {
        this.computeResourceId = computeResourceId;
    }

    public String getGatewayExecutionId() {
        return this.gatewayExecutionId;
    }

    public void setGatewayExecutionId(String gatewayExecutionId) {
        this.gatewayExecutionId = gatewayExecutionId;
    }

    public boolean getEnableEmailNotification() {
        return this.enableEmailNotification;
    }

    public void setEnableEmailNotification(boolean enableEmailNotification) {
        this.enableEmailNotification = enableEmailNotification;
    }

    public String getEmailAddresses() {
        return this.emailAddresses;
    }

    public void setEmailAddresses(String emailAddresses) {
        this.emailAddresses = emailAddresses;
    }

    public String getStorageResourceId() {
        return this.storageResourceId;
    }

    public void setStorageResourceId(String storageResourceId) {
        this.storageResourceId = storageResourceId;
    }

    public String getUserDn() {
        return this.userDn;
    }

    public void setUserDn(String userDn) {
        this.userDn = userDn;
    }

    public boolean isGenerateCert() {
        return this.generateCert;
    }

    public void setGenerateCert(boolean generateCert) {
        this.generateCert = generateCert;
    }

    public String getExperimentDataDir() {
        return this.experimentDataDir;
    }

    public void setExperimentDataDir(String experimentDataDir) {
        this.experimentDataDir = experimentDataDir;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public boolean isUseUserCRPref() {
        return this.useUserCRPref;
    }

    public void setUseUserCRPref(boolean useUserCRPref) {
        this.useUserCRPref = useUserCRPref;
    }

    @Override
    public ExperimentCatResource create(ResourceType type) throws RegistryException {
        switch (type) {
            case PROCESS_ERROR: {
                ProcessErrorResource errorResource = new ProcessErrorResource();
                errorResource.setProcessId(this.processId);
                return errorResource;
            }
            case PROCESS_STATUS: {
                ProcessStatusResource statusResource = new ProcessStatusResource();
                statusResource.setProcessId(this.processId);
                return statusResource;
            }
            case PROCESS_INPUT: {
                ProcessInputResource processInputResource = new ProcessInputResource();
                processInputResource.setProcessId(this.processId);
                return processInputResource;
            }
            case PROCESS_OUTPUT: {
                ProcessOutputResource processOutputResource = new ProcessOutputResource();
                processOutputResource.setProcessId(this.processId);
                return processOutputResource;
            }
            case PROCESS_RESOURCE_SCHEDULE: {
                ProcessResourceScheduleResource processResourceScheduleResource = new ProcessResourceScheduleResource();
                processResourceScheduleResource.setProcessId(this.processId);
                return processResourceScheduleResource;
            }
            case TASK: {
                TaskResource taskResource = new TaskResource();
                taskResource.setParentProcessId(this.processId);
                return taskResource;
            }
            case JOB: {
                JobResource jobResource = new JobResource();
                jobResource.setProcessId(this.processId);
                return jobResource;
            }
        }
        logger.error("Unsupported resource type for process resource.", (Throwable)new IllegalArgumentException());
        throw new IllegalArgumentException("Unsupported resource type for process resource.");
    }

    @Override
    public void remove(ResourceType type, Object name) throws RegistryException {
        EntityManager em = null;
        try {
            em = ExpCatResourceUtils.getEntityManager();
            em.getTransaction().begin();
            switch (type) {
                case PROCESS_ERROR: {
                    QueryGenerator generator = new QueryGenerator("ProcessError", new Object[0][]);
                    generator.setParameter("errorId", name);
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                case PROCESS_STATUS: {
                    QueryGenerator generator = new QueryGenerator("ProcessStatus", new Object[0][]);
                    generator.setParameter("statusId", name);
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                case PROCESS_INPUT: {
                    QueryGenerator generator = new QueryGenerator("ProcessInput", new Object[0][]);
                    generator.setParameter("inputName", name);
                    generator.setParameter("processId", this.processId);
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                case PROCESS_OUTPUT: {
                    QueryGenerator generator = new QueryGenerator("ProcessOutput", new Object[0][]);
                    generator.setParameter("outputName", name);
                    generator.setParameter("processId", this.processId);
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                case PROCESS_RESOURCE_SCHEDULE: {
                    QueryGenerator generator = new QueryGenerator("ProcessResourceSchedule", new Object[0][]);
                    generator.setParameter("processId", this.processId);
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                case TASK: {
                    QueryGenerator generator = new QueryGenerator("Task", new Object[0][]);
                    generator.setParameter("taskId", name);
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                case JOB: {
                    QueryGenerator generator = new QueryGenerator("Job", new Object[0][]);
                    generator.setParameter("jobId", name);
                    generator.setParameter("processId", this.processId);
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                default: {
                    logger.error("Unsupported resource type for process detail resource.", (Throwable)new IllegalArgumentException());
                }
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public ExperimentCatResource get(ResourceType type, Object name) throws RegistryException {
        EntityManager em = null;
        try {
            em = ExpCatResourceUtils.getEntityManager();
            em.getTransaction().begin();
            switch (type) {
                case PROCESS_STATUS: {
                    QueryGenerator generator = new QueryGenerator("ProcessStatus", new Object[0][]);
                    generator.setParameter("statusId", name);
                    Query q = generator.selectQuery(em);
                    ProcessStatus status = (ProcessStatus)q.getSingleResult();
                    ProcessStatusResource statusResource = (ProcessStatusResource)Utils.getResource(ResourceType.PROCESS_STATUS, status);
                    em.getTransaction().commit();
                    if (em.isOpen()) {
                        if (em.getTransaction().isActive()) {
                            em.getTransaction().rollback();
                        }
                        em.close();
                    }
                    ProcessStatusResource processStatusResource = statusResource;
                    return processStatusResource;
                }
                case PROCESS_ERROR: {
                    QueryGenerator generator = new QueryGenerator("ProcessError", new Object[0][]);
                    generator.setParameter("errorId", name);
                    Query q = generator.selectQuery(em);
                    ProcessError processError = (ProcessError)q.getSingleResult();
                    ProcessErrorResource processErrorResource = (ProcessErrorResource)Utils.getResource(ResourceType.PROCESS_ERROR, processError);
                    em.getTransaction().commit();
                    if (em.isOpen()) {
                        if (em.getTransaction().isActive()) {
                            em.getTransaction().rollback();
                        }
                        em.close();
                    }
                    ProcessErrorResource processErrorResource2 = processErrorResource;
                    return processErrorResource2;
                }
                case PROCESS_INPUT: {
                    QueryGenerator generator = new QueryGenerator("ProcessInput", new Object[0][]);
                    generator.setParameter("inputName", name);
                    generator.setParameter("processId", this.processId);
                    Query q = generator.selectQuery(em);
                    ProcessInput processInput = (ProcessInput)q.getSingleResult();
                    ProcessInputResource processInputResource = (ProcessInputResource)Utils.getResource(ResourceType.PROCESS_INPUT, processInput);
                    em.getTransaction().commit();
                    if (em.isOpen()) {
                        if (em.getTransaction().isActive()) {
                            em.getTransaction().rollback();
                        }
                        em.close();
                    }
                    ProcessInputResource processInputResource2 = processInputResource;
                    return processInputResource2;
                }
                case PROCESS_OUTPUT: {
                    QueryGenerator generator = new QueryGenerator("ProcessOutput", new Object[0][]);
                    generator.setParameter("outputName", name);
                    generator.setParameter("processId", this.processId);
                    Query q = generator.selectQuery(em);
                    ProcessOutput processOutput = (ProcessOutput)q.getSingleResult();
                    ProcessOutputResource outputResource = (ProcessOutputResource)Utils.getResource(ResourceType.PROCESS_OUTPUT, processOutput);
                    em.getTransaction().commit();
                    if (em.isOpen()) {
                        if (em.getTransaction().isActive()) {
                            em.getTransaction().rollback();
                        }
                        em.close();
                    }
                    ProcessOutputResource processOutputResource = outputResource;
                    return processOutputResource;
                }
                case PROCESS_RESOURCE_SCHEDULE: {
                    QueryGenerator generator = new QueryGenerator("ProcessResourceSchedule", new Object[0][]);
                    generator.setParameter("processId", name);
                    Query q = generator.selectQuery(em);
                    ProcessResourceSchedule processResourceSchedule = (ProcessResourceSchedule)q.getSingleResult();
                    ProcessResourceScheduleResource processResourceScheduleResource = (ProcessResourceScheduleResource)Utils.getResource(ResourceType.PROCESS_RESOURCE_SCHEDULE, processResourceSchedule);
                    em.getTransaction().commit();
                    if (em.isOpen()) {
                        if (em.getTransaction().isActive()) {
                            em.getTransaction().rollback();
                        }
                        em.close();
                    }
                    ProcessResourceScheduleResource processResourceScheduleResource2 = processResourceScheduleResource;
                    return processResourceScheduleResource2;
                }
                case TASK: {
                    QueryGenerator generator = new QueryGenerator("Task", new Object[0][]);
                    generator.setParameter("taskId", name);
                    Query q = generator.selectQuery(em);
                    Task task = (Task)q.getSingleResult();
                    TaskResource taskResource = (TaskResource)Utils.getResource(ResourceType.TASK, task);
                    em.getTransaction().commit();
                    if (em.isOpen()) {
                        if (em.getTransaction().isActive()) {
                            em.getTransaction().rollback();
                        }
                        em.close();
                    }
                    TaskResource taskResource2 = taskResource;
                    return taskResource2;
                }
                case JOB: {
                    QueryGenerator generator = new QueryGenerator("Job", new Object[0][]);
                    generator.setParameter("jobId", name);
                    generator.setParameter("processId", this.processId);
                    Query q = generator.selectQuery(em);
                    Job job = (Job)q.getSingleResult();
                    JobResource jobResource = (JobResource)Utils.getResource(ResourceType.JOB, job);
                    em.getTransaction().commit();
                    if (em.isOpen()) {
                        if (em.getTransaction().isActive()) {
                            em.getTransaction().rollback();
                        }
                        em.close();
                    }
                    JobResource jobResource2 = jobResource;
                    return jobResource2;
                }
            }
            try {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported resource type for process resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported resource type for process resource.");
            }
            catch (Exception e) {
                throw new RegistryException((Throwable)e);
            }
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public List<ExperimentCatResource> get(ResourceType type) throws RegistryException {
        ArrayList<ExperimentCatResource> resourceList = new ArrayList<ExperimentCatResource>();
        EntityManager em = null;
        try {
            em = ExpCatResourceUtils.getEntityManager();
            em.getTransaction().begin();
            switch (type) {
                case PROCESS_INPUT: {
                    QueryGenerator generator = new QueryGenerator("ProcessInput", new Object[0][]);
                    generator.setParameter("processId", this.processId);
                    Query q = generator.selectQuery(em);
                    List results = q.getResultList();
                    if (results.size() == 0) break;
                    for (Object result : results) {
                        ProcessInput processInput = (ProcessInput)result;
                        ProcessInputResource processInputResource = (ProcessInputResource)Utils.getResource(ResourceType.PROCESS_INPUT, processInput);
                        resourceList.add(processInputResource);
                    }
                    break;
                }
                case PROCESS_OUTPUT: {
                    QueryGenerator generator = new QueryGenerator("ProcessOutput", new Object[0][]);
                    generator.setParameter("processId", this.processId);
                    Query q = generator.selectQuery(em);
                    List results = q.getResultList();
                    if (results.size() == 0) break;
                    for (Object result : results) {
                        ProcessOutput processOutput = (ProcessOutput)result;
                        ProcessOutputResource processOutputResource = (ProcessOutputResource)Utils.getResource(ResourceType.PROCESS_OUTPUT, processOutput);
                        resourceList.add(processOutputResource);
                    }
                    break;
                }
                case TASK: {
                    QueryGenerator generator = new QueryGenerator("Task", new Object[0][]);
                    generator.setParameter("parentProcessId", this.processId);
                    Query q = generator.selectQuery(em);
                    List results = q.getResultList();
                    if (results.size() == 0) break;
                    for (Object result : results) {
                        Task task = (Task)result;
                        TaskResource taskResource = (TaskResource)Utils.getResource(ResourceType.TASK, task);
                        resourceList.add(taskResource);
                    }
                    break;
                }
                case PROCESS_ERROR: {
                    QueryGenerator generator = new QueryGenerator("ProcessError", new Object[0][]);
                    generator.setParameter("processId", this.processId);
                    Query q = generator.selectQuery(em);
                    List results = q.getResultList();
                    if (results.size() == 0) break;
                    for (Object result : results) {
                        ProcessError processError = (ProcessError)result;
                        ProcessErrorResource processErrorResource = (ProcessErrorResource)Utils.getResource(ResourceType.PROCESS_ERROR, processError);
                        resourceList.add(processErrorResource);
                    }
                    break;
                }
                case PROCESS_STATUS: {
                    QueryGenerator generator = new QueryGenerator("ProcessStatus", new Object[0][]);
                    generator.setParameter("processId", this.processId);
                    Query q = generator.selectQuery(em);
                    List results = q.getResultList();
                    if (results.size() == 0) break;
                    for (Object result : results) {
                        ProcessStatus processStatus = (ProcessStatus)result;
                        ProcessStatusResource processStatusResource = (ProcessStatusResource)Utils.getResource(ResourceType.PROCESS_STATUS, processStatus);
                        resourceList.add(processStatusResource);
                    }
                    break;
                }
                case JOB: {
                    QueryGenerator generator = new QueryGenerator("Job", new Object[0][]);
                    generator.setParameter("processId", this.processId);
                    Query q = generator.selectQuery(em);
                    List results = q.getResultList();
                    if (results.size() == 0) break;
                    for (Object result : results) {
                        Job job = (Job)result;
                        JobResource jobResource = (JobResource)Utils.getResource(ResourceType.JOB, job);
                        resourceList.add(jobResource);
                    }
                    break;
                }
                default: {
                    logger.error("Unsupported resource type for task resource.", (Throwable)new UnsupportedOperationException());
                    throw new UnsupportedOperationException();
                }
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return resourceList;
    }

    @Override
    public void save() throws RegistryException {
        EntityManager em = null;
        try {
            em = ExpCatResourceUtils.getEntityManager();
            Process existingProcess = (Process)em.find(Process.class, (Object)this.processId);
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            em = ExpCatResourceUtils.getEntityManager();
            em.getTransaction().begin();
            Process process = existingProcess == null ? new Process() : existingProcess;
            process.setProcessId(this.processId);
            process.setExperimentId(this.experimentId);
            process.setCreationTime(this.creationTime);
            process.setLastUpdateTime(this.lastUpdateTime);
            process.setProcessDetail(this.processDetail);
            process.setTaskDag(this.taskDag);
            process.setComputeResourceId(this.computeResourceId);
            process.setApplicationInterfaceId(this.applicationInterfaceId);
            process.setApplicationDeploymentId(this.applicationDeploymentId);
            process.setGatewayExecutionId(this.gatewayExecutionId);
            process.setEnableEmailNotification(this.enableEmailNotification);
            process.setEmailAddresses(this.emailAddresses);
            process.setStorageId(this.storageResourceId);
            process.setUserDn(this.userDn);
            process.setGenerateCert(this.generateCert);
            process.setExperimentDataDir(this.experimentDataDir);
            process.setUserName(this.userName);
            process.setUseUserCRPref(this.useUserCRPref);
            if (existingProcess == null) {
                em.persist((Object)process);
            } else {
                em.merge((Object)process);
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public List<ProcessInputResource> getProcessInputs() throws RegistryException {
        ArrayList<ProcessInputResource> processInputResources = new ArrayList<ProcessInputResource>();
        List<ExperimentCatResource> resources = this.get(ResourceType.PROCESS_INPUT);
        for (ExperimentCatResource resource : resources) {
            ProcessInputResource inputResource = (ProcessInputResource)resource;
            processInputResources.add(inputResource);
        }
        return processInputResources;
    }

    public List<ProcessOutputResource> getProcessOutputs() throws RegistryException {
        ArrayList<ProcessOutputResource> outputResources = new ArrayList<ProcessOutputResource>();
        List<ExperimentCatResource> resources = this.get(ResourceType.PROCESS_OUTPUT);
        for (ExperimentCatResource resource : resources) {
            ProcessOutputResource outputResource = (ProcessOutputResource)resource;
            outputResources.add(outputResource);
        }
        return outputResources;
    }

    public List<ProcessStatusResource> getProcessStatuses() throws RegistryException {
        ArrayList<ProcessStatusResource> processStatusResources = new ArrayList<ProcessStatusResource>();
        List<ExperimentCatResource> resources = this.get(ResourceType.PROCESS_STATUS);
        for (ExperimentCatResource resource : resources) {
            ProcessStatusResource statusResource = (ProcessStatusResource)resource;
            processStatusResources.add(statusResource);
        }
        return processStatusResources;
    }

    public ProcessStatusResource getProcessStatus() throws RegistryException {
        List<ProcessStatusResource> processStatusResources = this.getProcessStatuses();
        if (processStatusResources.size() == 0) {
            return null;
        }
        ProcessStatusResource max = processStatusResources.get(0);
        for (int i = 1; i < processStatusResources.size(); ++i) {
            Timestamp timeOfStateChange = processStatusResources.get(i).getTimeOfStateChange();
            if (timeOfStateChange == null || !(timeOfStateChange.after(max.getTimeOfStateChange()) || timeOfStateChange.equals(max.getTimeOfStateChange()) && processStatusResources.get(i).getState().equals(ProcessState.COMPLETED.toString()) || timeOfStateChange.equals(max.getTimeOfStateChange()) && processStatusResources.get(i).getState().equals(ProcessState.FAILED.toString())) && (!timeOfStateChange.equals(max.getTimeOfStateChange()) || !processStatusResources.get(i).getState().equals(ProcessState.CANCELED.toString()))) continue;
            max = processStatusResources.get(i);
        }
        return max;
    }

    public List<ProcessErrorResource> getProcessErrors() throws RegistryException {
        ArrayList<ProcessErrorResource> processErrorResources = new ArrayList<ProcessErrorResource>();
        List<ExperimentCatResource> resources = this.get(ResourceType.PROCESS_ERROR);
        for (ExperimentCatResource resource : resources) {
            ProcessErrorResource errorResource = (ProcessErrorResource)resource;
            processErrorResources.add(errorResource);
        }
        return processErrorResources;
    }

    public ProcessErrorResource getProcessError() throws RegistryException {
        List<ProcessErrorResource> processErrorResources = this.getProcessErrors();
        if (processErrorResources.size() == 0) {
            return null;
        }
        ProcessErrorResource max = processErrorResources.get(0);
        for (int i = 1; i < processErrorResources.size(); ++i) {
            if (!processErrorResources.get(i).getCreationTime().after(max.getCreationTime())) continue;
            max = processErrorResources.get(i);
        }
        return max;
    }

    public ProcessResourceScheduleResource getProcessResourceSchedule() throws RegistryException {
        ExperimentCatResource resource = this.get(ResourceType.PROCESS_RESOURCE_SCHEDULE, this.processId);
        return (ProcessResourceScheduleResource)resource;
    }

    public List<TaskResource> getTaskList() throws RegistryException {
        ArrayList<TaskResource> taskResources = new ArrayList<TaskResource>();
        List<ExperimentCatResource> resources = this.get(ResourceType.TASK);
        for (ExperimentCatResource resource : resources) {
            TaskResource taskResource = (TaskResource)resource;
            taskResources.add(taskResource);
        }
        return taskResources;
    }

    public TaskResource getTask(String taskId) throws RegistryException {
        ExperimentCatResource resource = this.get(ResourceType.TASK, taskId);
        return (TaskResource)resource;
    }

    public JobResource getJob(String jobId) throws RegistryException {
        return (JobResource)this.get(ResourceType.JOB, jobId);
    }

    public List<JobResource> getJobList() throws RegistryException {
        ArrayList<JobResource> jobResources = new ArrayList<JobResource>();
        List<ExperimentCatResource> resources = this.get(ResourceType.JOB);
        for (ExperimentCatResource resource : resources) {
            JobResource jobResource = (JobResource)resource;
            jobResources.add(jobResource);
        }
        return jobResources;
    }
}

