/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TimerTask;
import org.apache.commons.collections.BidiMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.internal.CarbonCoreDataHolder;
import org.wso2.carbon.utils.FileManipulator;

public class HouseKeepingTask
extends TimerTask {
    private static Log log = LogFactory.getLog(HouseKeepingTask.class);
    private String workDir;
    private BidiMap fileResourceMap;
    private int fileTimeoutMillis;

    public HouseKeepingTask(String workDir, BidiMap fileResourceMap) {
        this.workDir = workDir;
        this.fileResourceMap = fileResourceMap;
        this.fileTimeoutMillis = Integer.parseInt(CarbonCoreDataHolder.getInstance().getServerConfigurationService().getFirstProperty("HouseKeeping.MaxTempFileLifetime")) * 60 * 1000;
    }

    @Override
    public void run() {
        log.debug((Object)"Starting house-keeping task...");
        try {
            File workDir = new File(this.workDir);
            if (workDir.exists()) {
                ArrayList<String> deletedFiles = new ArrayList<String>();
                this.clean(workDir, deletedFiles);
                log.debug((Object)"Clearing filemap cache...");
                if (this.fileResourceMap != null) {
                    Iterator iterator = deletedFiles.iterator();
                    while (iterator.hasNext()) {
                        this.fileResourceMap.removeValue(iterator.next());
                    }
                }
            }
            log.debug((Object)"House-keeping complete.");
        }
        catch (Throwable e) {
            log.error((Object)"Could not run HousekeepingTask", e);
        }
    }

    private void clean(File file, List<String> deletedFiles) {
        if (file == null) {
            return;
        }
        File[] children = file.listFiles();
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                this.clean(children[i], deletedFiles);
            }
            if (file.listFiles() == null || file.listFiles().length == 0) {
                String absPath = file.getAbsolutePath();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Deleting directory " + absPath + "..."));
                }
                deletedFiles.add(absPath);
                FileManipulator.deleteDir((File)file);
            }
        } else if (System.currentTimeMillis() - file.lastModified() >= (long)this.fileTimeoutMillis) {
            String absPath = file.getAbsolutePath();
            if (file.isDirectory()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Deleting directory " + absPath + "..."));
                }
                deletedFiles.add(absPath);
                FileManipulator.deleteDir((File)file);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Deleting file " + absPath + "..."));
                }
                deletedFiles.add(absPath);
                if (!file.delete()) {
                    log.warn((Object)("Could not delete file " + file.getAbsolutePath()));
                }
            }
        }
    }

    public void setWorkDir(String workDir) {
        this.workDir = workDir;
    }

    public void setFileResourceMap(BidiMap fileResourceMap) {
        this.fileResourceMap = fileResourceMap;
    }
}

