/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.xml.dom4j.converter;

import java.io.Reader;
import org.compass.core.CompassException;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.converter.ConversionException;
import org.compass.core.converter.xsem.SupportsXmlContentWrapper;
import org.compass.core.xml.AliasedXmlObject;
import org.compass.core.xml.dom4j.Dom4jAliasedXmlObject;
import org.compass.core.xml.dom4j.converter.AbstractXmlWriterXmlContentConverter;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.XPP3Reader;

public class XPP3ReaderXmlContentConverter
extends AbstractXmlWriterXmlContentConverter
implements SupportsXmlContentWrapper,
CompassConfigurable {
    private XPP3Reader xppReader;

    public void configure(CompassSettings settings) throws CompassException {
        this.xppReader = this.doCreateXPP3Reader(settings);
    }

    protected XPP3Reader doCreateXPP3Reader(CompassSettings settings) {
        return new XPP3Reader();
    }

    public boolean supports(String wrapper) {
        return !"singleton".equals(wrapper);
    }

    public AliasedXmlObject fromXml(String alias, Reader xml) throws ConversionException {
        Document doc;
        try {
            doc = this.xppReader.read(xml);
        }
        catch (Exception e) {
            throw new ConversionException("Failed to parse alias[" + alias + "] xml[" + xml + "]", e);
        }
        return new Dom4jAliasedXmlObject(alias, (Node)doc.getRootElement());
    }
}

