/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.credential.store.store.impl.db;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.airavata.common.utils.DBUtil;
import org.apache.airavata.common.utils.KeyStorePasswordCallback;
import org.apache.airavata.common.utils.SecurityUtil;
import org.apache.airavata.credential.store.credential.Credential;
import org.apache.airavata.credential.store.credential.CredentialOwnerType;
import org.apache.airavata.credential.store.store.CredentialStoreException;
import org.apache.airavata.credential.store.store.impl.db.ParentDAO;

public class CredentialsDAO
extends ParentDAO {
    private String keyStorePath = null;
    private String secretKeyAlias = null;
    private KeyStorePasswordCallback keyStorePasswordCallback = null;

    public CredentialsDAO() {
    }

    public CredentialsDAO(String keyStore, String alias, KeyStorePasswordCallback passwordCallback) {
        this.keyStorePath = keyStore;
        this.secretKeyAlias = alias;
        this.keyStorePasswordCallback = passwordCallback;
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    public void setKeyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
    }

    public String getSecretKeyAlias() {
        return this.secretKeyAlias;
    }

    public void setSecretKeyAlias(String secretKeyAlias) {
        this.secretKeyAlias = secretKeyAlias;
    }

    public KeyStorePasswordCallback getKeyStorePasswordCallback() {
        return this.keyStorePasswordCallback;
    }

    public void setKeyStorePasswordCallback(KeyStorePasswordCallback keyStorePasswordCallback) {
        this.keyStorePasswordCallback = keyStorePasswordCallback;
    }

    public void addCredentials(String gatewayId, Credential credential, Connection connection) throws CredentialStoreException {
        String sql = "INSERT INTO CREDENTIALS (GATEWAY_ID, TOKEN_ID, CREDENTIAL, PORTAL_USER_ID, TIME_PERSISTED, DESCRIPTION, CREDENTIAL_OWNER_TYPE) VALUES (?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(sql);
            preparedStatement.setString(1, gatewayId);
            preparedStatement.setString(2, credential.getToken());
            ByteArrayInputStream isCert = new ByteArrayInputStream(this.convertObjectToByteArray(credential));
            preparedStatement.setBinaryStream(3, isCert);
            preparedStatement.setString(4, credential.getPortalUserName());
            Date date = new Date();
            Timestamp timestamp = new Timestamp(date.getTime());
            preparedStatement.setTimestamp(5, timestamp);
            preparedStatement.setString(6, credential.getDescription());
            preparedStatement.setString(7, credential.getCredentialOwnerType().toString());
            preparedStatement.executeUpdate();
        }
        catch (SQLException e) {
            StringBuilder stringBuilder = new StringBuilder("Error persisting credentials.");
            stringBuilder.append(" gateway - ").append(gatewayId);
            stringBuilder.append(" token id - ").append(credential.getToken());
            log.error(stringBuilder.toString(), (Throwable)e);
            throw new CredentialStoreException(stringBuilder.toString(), e);
        }
        finally {
            DBUtil.cleanup((PreparedStatement)preparedStatement);
        }
    }

    public void deleteCredentials(String gatewayName, String tokenId, Connection connection) throws CredentialStoreException {
        String sql = "DELETE FROM CREDENTIALS WHERE GATEWAY_ID=? AND TOKEN_ID=?";
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(sql);
            preparedStatement.setString(1, gatewayName);
            preparedStatement.setString(2, tokenId);
            preparedStatement.executeUpdate();
            connection.commit();
        }
        catch (SQLException e) {
            StringBuilder stringBuilder = new StringBuilder("Error deleting credentials for .");
            stringBuilder.append("gateway - ").append(gatewayName);
            stringBuilder.append("token id - ").append(tokenId);
            log.error(stringBuilder.toString(), (Throwable)e);
            throw new CredentialStoreException(stringBuilder.toString(), e);
        }
        finally {
            DBUtil.cleanup((PreparedStatement)preparedStatement);
        }
    }

    public void updateCredentials(String gatewayId, Credential credential, Connection connection) throws CredentialStoreException {
        String sql = "UPDATE CREDENTIALS set CREDENTIAL = ?, PORTAL_USER_ID = ?, TIME_PERSISTED = ?, DESCRIPTION = ?, CREDENTIAL_OWNER_TYPE = ? where GATEWAY_ID = ? and TOKEN_ID = ?";
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(sql);
            ByteArrayInputStream isCert = new ByteArrayInputStream(this.convertObjectToByteArray(credential));
            preparedStatement.setBinaryStream(1, isCert);
            preparedStatement.setString(2, credential.getPortalUserName());
            preparedStatement.setTimestamp(3, new Timestamp(new Date().getTime()));
            preparedStatement.setString(4, credential.getDescription());
            preparedStatement.setString(5, credential.getCredentialOwnerType().toString());
            preparedStatement.setString(6, gatewayId);
            preparedStatement.setString(7, credential.getToken());
            preparedStatement.executeUpdate();
        }
        catch (SQLException e) {
            StringBuilder stringBuilder = new StringBuilder("Error updating credentials.");
            stringBuilder.append(" gateway - ").append(gatewayId);
            stringBuilder.append(" token id - ").append(credential.getToken());
            log.error(stringBuilder.toString(), (Throwable)e);
            throw new CredentialStoreException(stringBuilder.toString(), e);
        }
        finally {
            DBUtil.cleanup((PreparedStatement)preparedStatement);
        }
    }

    public Credential getCredential(String gatewayName, String tokenId, Connection connection) throws CredentialStoreException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block4: {
            Credential credential;
            String sql = "SELECT * FROM CREDENTIALS WHERE GATEWAY_ID=? AND TOKEN_ID=?";
            preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = connection.prepareStatement(sql);
                preparedStatement.setString(1, gatewayName);
                preparedStatement.setString(2, tokenId);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block4;
                Blob blobCredentials = resultSet.getBlob("CREDENTIAL");
                byte[] certificate = blobCredentials.getBytes(1L, (int)blobCredentials.length());
                Credential certificateCredential = (Credential)this.convertByteArrayToObject(certificate);
                certificateCredential.setPortalUserName(resultSet.getString("PORTAL_USER_ID"));
                certificateCredential.setCertificateRequestedTime(resultSet.getTimestamp("TIME_PERSISTED"));
                certificateCredential.setDescription(resultSet.getString("DESCRIPTION"));
                certificateCredential.setCredentialOwnerType(CredentialOwnerType.valueOf(resultSet.getString("CREDENTIAL_OWNER_TYPE")));
                credential = certificateCredential;
            }
            catch (SQLException e) {
                try {
                    StringBuilder stringBuilder = new StringBuilder("Error retrieving credentials for user.");
                    stringBuilder.append("gateway - ").append(gatewayName);
                    stringBuilder.append("token id - ").append(tokenId);
                    log.debug(stringBuilder.toString(), (Throwable)e);
                    throw new CredentialStoreException(stringBuilder.toString(), e);
                }
                catch (Throwable throwable) {
                    DBUtil.cleanup((PreparedStatement)preparedStatement, resultSet);
                    throw throwable;
                }
            }
            DBUtil.cleanup((PreparedStatement)preparedStatement, (ResultSet)resultSet);
            return credential;
        }
        DBUtil.cleanup((PreparedStatement)preparedStatement, (ResultSet)resultSet);
        return null;
    }

    public String getGatewayID(String tokenId, Connection connection) throws CredentialStoreException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block4: {
            String string;
            String sql = "SELECT GATEWAY_ID FROM CREDENTIALS WHERE TOKEN_ID=?";
            preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = connection.prepareStatement(sql);
                preparedStatement.setString(1, tokenId);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block4;
                string = resultSet.getString("GATEWAY_ID");
            }
            catch (SQLException e) {
                try {
                    StringBuilder stringBuilder = new StringBuilder("Error retrieving credentials for user.");
                    stringBuilder.append("token id - ").append(tokenId);
                    log.debug(stringBuilder.toString(), (Throwable)e);
                    throw new CredentialStoreException(stringBuilder.toString(), e);
                }
                catch (Throwable throwable) {
                    DBUtil.cleanup((PreparedStatement)preparedStatement, resultSet);
                    throw throwable;
                }
            }
            DBUtil.cleanup((PreparedStatement)preparedStatement, (ResultSet)resultSet);
            return string;
        }
        DBUtil.cleanup((PreparedStatement)preparedStatement, (ResultSet)resultSet);
        return null;
    }

    public List<Credential> getCredentials(String gatewayName, Connection connection) throws CredentialStoreException {
        ArrayList<Credential> credentialList = new ArrayList<Credential>();
        String sql = "SELECT * FROM CREDENTIALS WHERE GATEWAY_ID=?";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(sql);
            preparedStatement.setString(1, gatewayName);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Blob blobCredentials = resultSet.getBlob("CREDENTIAL");
                byte[] certificate = blobCredentials.getBytes(1L, (int)blobCredentials.length());
                Credential certificateCredential = (Credential)this.convertByteArrayToObject(certificate);
                certificateCredential.setToken(resultSet.getString("TOKEN_ID"));
                certificateCredential.setPortalUserName(resultSet.getString("PORTAL_USER_ID"));
                certificateCredential.setCertificateRequestedTime(resultSet.getTimestamp("TIME_PERSISTED"));
                certificateCredential.setDescription(resultSet.getString("DESCRIPTION"));
                certificateCredential.setCredentialOwnerType(CredentialOwnerType.valueOf(resultSet.getString("CREDENTIAL_OWNER_TYPE")));
                credentialList.add(certificateCredential);
            }
        }
        catch (SQLException e) {
            try {
                StringBuilder stringBuilder = new StringBuilder("Error retrieving credential list for ");
                stringBuilder.append("gateway - ").append(gatewayName);
                log.debug(stringBuilder.toString(), (Throwable)e);
                throw new CredentialStoreException(stringBuilder.toString(), e);
            }
            catch (Throwable throwable) {
                DBUtil.cleanup((PreparedStatement)preparedStatement, resultSet);
                throw throwable;
            }
        }
        DBUtil.cleanup((PreparedStatement)preparedStatement, (ResultSet)resultSet);
        return credentialList;
    }

    public List<Credential> getCredentials(Connection connection) throws CredentialStoreException {
        ArrayList<Credential> credentialList = new ArrayList<Credential>();
        String sql = "SELECT * FROM CREDENTIALS";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(sql);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Blob blobCredentials = resultSet.getBlob("CREDENTIAL");
                byte[] certificate = blobCredentials.getBytes(1L, (int)blobCredentials.length());
                Credential certificateCredential = (Credential)this.convertByteArrayToObject(certificate);
                certificateCredential.setToken(resultSet.getString("TOKEN_ID"));
                certificateCredential.setPortalUserName(resultSet.getString("PORTAL_USER_ID"));
                certificateCredential.setCertificateRequestedTime(resultSet.getTimestamp("TIME_PERSISTED"));
                certificateCredential.setDescription(resultSet.getString("DESCRIPTION"));
                certificateCredential.setCredentialOwnerType(CredentialOwnerType.valueOf(resultSet.getString("CREDENTIAL_OWNER_TYPE")));
                credentialList.add(certificateCredential);
            }
        }
        catch (SQLException e) {
            try {
                StringBuilder stringBuilder = new StringBuilder("Error retrieving all credentials");
                log.debug(stringBuilder.toString(), (Throwable)e);
                throw new CredentialStoreException(stringBuilder.toString(), e);
            }
            catch (Throwable throwable) {
                DBUtil.cleanup((PreparedStatement)preparedStatement, resultSet);
                throw throwable;
            }
        }
        DBUtil.cleanup((PreparedStatement)preparedStatement, (ResultSet)resultSet);
        return credentialList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object convertByteArrayToObject(byte[] data) throws CredentialStoreException {
        ObjectInputStream objectInputStream = null;
        Object o = null;
        try {
            try {
                if (this.encrypt()) {
                    data = SecurityUtil.decrypt((String)this.keyStorePath, (String)this.secretKeyAlias, (KeyStorePasswordCallback)this.keyStorePasswordCallback, (byte[])data);
                }
                objectInputStream = new ObjectInputStream(new ByteArrayInputStream(data));
                o = objectInputStream.readObject();
            }
            catch (IOException e) {
                throw new CredentialStoreException("Error de-serializing object.", e);
            }
            catch (ClassNotFoundException e) {
                throw new CredentialStoreException("Error de-serializing object.", e);
            }
            catch (GeneralSecurityException e) {
                throw new CredentialStoreException("Error decrypting data.", e);
            }
        }
        finally {
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (IOException e) {
                    log.error("Error occurred while closing the stream", (Throwable)e);
                }
            }
        }
        return o;
    }

    public byte[] convertObjectToByteArray(Serializable o) throws CredentialStoreException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(o);
            objectOutputStream.flush();
        }
        catch (IOException e) {
            throw new CredentialStoreException("Error serializing object.", e);
        }
        finally {
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (IOException e) {
                    log.error("Error occurred while closing object output stream", (Throwable)e);
                }
            }
        }
        if (this.encrypt()) {
            byte[] array = byteArrayOutputStream.toByteArray();
            try {
                return SecurityUtil.encrypt((String)this.keyStorePath, (String)this.secretKeyAlias, (KeyStorePasswordCallback)this.keyStorePasswordCallback, (byte[])array);
            }
            catch (GeneralSecurityException e) {
                throw new CredentialStoreException("Error encrypting data", e);
            }
            catch (IOException e) {
                throw new CredentialStoreException("Error encrypting data. IO exception.", e);
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    private boolean encrypt() {
        return this.keyStorePath != null;
    }
}

