/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.xmlbeans;

import de.fzj.unicore.wsrflite.WSRFConstants;
import eu.emi.security.authn.x509.impl.X500NameUtils;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.security.auth.x500.X500Principal;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.ReferenceParametersType;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.oasisOpen.docs.wsrf.rp2.GetResourcePropertyDocumentResponseDocument;
import org.w3.x2003.x05.soapEnvelope.Header;
import org.w3.x2005.x08.addressing.EndpointReferenceType;
import org.w3.x2005.x08.addressing.MetadataType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSUtilities {
    protected WSUtilities() {
    }

    public static String newUniqueID() {
        return UUID.randomUUID().toString();
    }

    public static QName toQName(SchemaType type) {
        try {
            if (!type.isDocumentType()) {
                return null;
            }
            return type.getDocumentElementName();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static XmlObject[] extractResourceProperty(GetResourcePropertyDocumentResponseDocument res, QName q) {
        return res.selectChildren(q);
    }

    public static void append(XmlObject what, XmlObject toWhere) {
        XmlCursor sourceCurs = what.newCursor();
        sourceCurs.toNextToken();
        XmlCursor targetCurs = toWhere.newCursor();
        targetCurs.toEndDoc();
        targetCurs.toPrevToken();
        sourceCurs.copyXml(targetCurs);
        sourceCurs.dispose();
        targetCurs.dispose();
    }

    public static void append(XmlObject[] what, XmlObject toWhere) {
        XmlCursor targetCurs = toWhere.newCursor();
        targetCurs.toEndDoc();
        targetCurs.toPrevToken();
        for (XmlObject source : what) {
            XmlCursor sourceCurs = source.newCursor();
            sourceCurs.toNextToken();
            sourceCurs.copyXml(targetCurs);
            sourceCurs.dispose();
        }
        targetCurs.dispose();
    }

    public static void insertAny(XmlObject what, XmlObject toWhere) {
        XmlCursor sourceCurs = what.newCursor();
        sourceCurs.toNextToken();
        XmlCursor targetCurs = toWhere.newCursor();
        targetCurs.toNextToken();
        sourceCurs.copyXml(targetCurs);
        sourceCurs.dispose();
        targetCurs.dispose();
    }

    public static XmlObject[] extractAny(XmlObject source, QName q) {
        return source.selectChildren(q);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XmlObject[] extractAllMatchingElements(XmlObject source, QName q) {
        ArrayList<XmlObject> results = new ArrayList<XmlObject>();
        XmlCursor cursor = source.newCursor();
        try {
            while (WSUtilities.goToNextElement(cursor, q)) {
                XmlObject o = XmlObject.Factory.parse((Reader)cursor.newReader());
                results.add(o);
            }
        }
        catch (Exception ioe) {
        }
        finally {
            cursor.dispose();
        }
        return results.toArray(new XmlObject[results.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XmlObject[] extractAllChildren(XmlObject xBean) {
        ArrayList<XmlObject> results = new ArrayList<XmlObject>();
        XmlCursor cursor = xBean.newCursor();
        if (cursor.getName() == null) {
            cursor.toFirstChild();
        }
        try {
            boolean hasNext = cursor.toFirstChild();
            while (hasNext) {
                block7: {
                    XmlObject next;
                    try {
                        next = XmlObject.Factory.parse((XMLStreamReader)cursor.newXMLStreamReader());
                    }
                    catch (XmlException e) {
                        break block7;
                    }
                    results.add(next);
                }
                hasNext = cursor.toNextSibling();
            }
        }
        finally {
            cursor.dispose();
        }
        return results.toArray(new XmlObject[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XmlObject[] extractAnyElements(XmlObject source, QName q) {
        ArrayList<XmlObject> results = new ArrayList<XmlObject>();
        XmlCursor cursor = null;
        try {
            if (source != null) {
                cursor = source.newCursor();
                boolean hasMore = WSUtilities.skipToElement(cursor, q);
                while (hasMore) {
                    XmlObject next = XmlObject.Factory.parse((XMLStreamReader)cursor.newXMLStreamReader());
                    QName name = cursor.getName();
                    if (q.getNamespaceURI().equals(name.getNamespaceURI()) && q.getLocalPart().equals(name.getLocalPart())) {
                        results.add(next);
                    }
                    hasMore = cursor.toNextSibling(q);
                }
            }
        }
        catch (XmlException xe) {
        }
        finally {
            if (cursor != null) {
                cursor.dispose();
            }
        }
        return results.toArray(new XmlObject[results.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> extractAnyElements(XmlObject source, Class<T> asClass) {
        ArrayList<XmlObject> results = new ArrayList<XmlObject>();
        QName q = XmlBeans.typeForClass(asClass).getDocumentElementName();
        XmlCursor cursor = null;
        try {
            if (source != null) {
                cursor = source.newCursor();
                WSUtilities.skipToElement(cursor, q);
                boolean hasMore = true;
                while (hasMore) {
                    XmlObject next = XmlObject.Factory.parse((XMLStreamReader)cursor.newXMLStreamReader());
                    QName name = cursor.getName();
                    if (q.getNamespaceURI().equals(name.getNamespaceURI()) && q.getLocalPart().equals(name.getLocalPart())) {
                        results.add(next);
                    }
                    hasMore = cursor.toNextSibling(q);
                }
            }
        }
        catch (XmlException xe) {
        }
        finally {
            if (cursor != null) {
                cursor.dispose();
            }
        }
        return results;
    }

    public static QName findAnyElementQName(XmlObject o) {
        NodeList nodes = o.getDomNode().getChildNodes();
        if (nodes.getLength() > 0) {
            Node n = nodes.item(0);
            return new QName(n.getNamespaceURI(), n.getLocalName());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String extractElementTextAsString(XmlObject source) {
        XmlCursor c = null;
        try {
            c = source.newCursor();
            while (c.hasNextToken()) {
                if (!c.toNextToken().equals(XmlCursor.TokenType.TEXT)) continue;
                String string = c.getChars();
                return string;
            }
            String string = "";
            return string;
        }
        finally {
            try {
                c.dispose();
            }
            catch (Exception e) {}
        }
    }

    public static boolean skipToElement(XmlCursor cursor, QName name) {
        if (name.equals(cursor.getName())) {
            return true;
        }
        boolean hasMoreChildren = true;
        int i = 0;
        while (hasMoreChildren) {
            if (!(hasMoreChildren = cursor.toChild(i++))) continue;
            boolean foundInChild = WSUtilities.skipToElement(cursor, name);
            if (foundInChild) {
                return true;
            }
            cursor.toParent();
        }
        return false;
    }

    public static boolean goToNextElement(XmlCursor cursor, QName name) {
        while (cursor.hasNextToken()) {
            XmlCursor.TokenType tt = cursor.toNextToken();
            if (!tt.isStart() || !name.equals(cursor.getName())) continue;
            return true;
        }
        return false;
    }

    public static void addHeaders(Header header, XmlObject[] headers) {
        for (XmlObject o : headers) {
            WSUtilities.insertAny(o, header);
        }
    }

    public static String extractResourceID(EndpointReferenceType epr) {
        try {
            return epr.getAddress().getStringValue().split("=")[1];
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String extractResourceID(String id) {
        try {
            return id.split("=")[1];
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String extractServiceName(EndpointReferenceType epr) {
        try {
            return WSUtilities.extractServiceName(epr.getAddress().getStringValue());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String extractServiceName(String url) {
        try {
            URI u = new URI(url);
            String[] path = u.getPath().split("/");
            return path[path.length - 1];
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean validateIntegerRange(String value, int minValue, int maxValue) {
        try {
            if (value == null) {
                return false;
            }
            Integer i = Integer.parseInt(value);
            if (i < minValue || i > maxValue) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static void addUGSRefparamToEpr(EndpointReferenceType epr, String id) {
        WSUtilities.addReferenceParameter(epr, WSRFConstants.U6_RESOURCE_ID, id);
    }

    public static void addReferenceParameter(EndpointReferenceType epr, QName qname, String id) {
        org.w3.x2005.x08.addressing.ReferenceParametersType rp = null;
        rp = epr.getReferenceParameters();
        if (rp == null) {
            rp = epr.addNewReferenceParameters();
        }
        XmlCursor n = rp.newCursor();
        n.toFirstContentToken();
        n.beginElement(qname);
        n.insertChars(id);
        n.toNextToken();
        n.dispose();
    }

    public static void addUGSRefparamToEpr(EndpointReferenceType epr) {
        WSUtilities.addUGSRefparamToEpr(epr, WSUtilities.extractResourceID(epr));
    }

    public static QName extractInterfaceName(EndpointReferenceType epr) {
        try {
            XmlCursor n = epr.newCursor();
            WSUtilities.skipToElement(n, WSRFConstants.INTERFACE_NAME);
            String localPart = n.getTextValue().substring(n.getTextValue().indexOf(":") + 1);
            String prefix = n.getTextValue().substring(0, n.getTextValue().indexOf(":"));
            String namespace = n.namespaceForPrefix(prefix);
            n.dispose();
            return new QName(namespace, localPart);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static X500Principal extractServerX500Principal(EndpointReferenceType epr) {
        String name = WSUtilities.extractServerIDFromEPR(epr);
        try {
            return name != null ? X500NameUtils.getX500Principal((String)name) : null;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("The server identity is set, but was not recognized as a DN: " + e);
        }
    }

    public static String extractServerIDFromEPR(EndpointReferenceType epr) {
        try {
            if (epr == null || epr.getMetadata() == null) {
                return null;
            }
            MetadataType meta = epr.getMetadata();
            XmlObject[] o = WSUtilities.extractAnyElements((XmlObject)meta, WSRFConstants.SERVER_NAME);
            if (o.length == 0) {
                return null;
            }
            XmlCursor c = WSUtilities.extractAnyElements((XmlObject)meta, WSRFConstants.SERVER_NAME)[0].newCursor();
            while (c.toNextToken() != XmlCursor.TokenType.TEXT) {
            }
            String res = c.getChars();
            c.dispose();
            return res;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String extractFriendlyNameFromEPR(EndpointReferenceType epr) {
        try {
            if (epr == null || epr.getMetadata() == null) {
                return null;
            }
            MetadataType meta = epr.getMetadata();
            XmlObject[] o = WSUtilities.extractAnyElements((XmlObject)meta, WSRFConstants.FRIENDLY_NAME);
            if (o.length == 0) {
                return null;
            }
            XmlCursor c = WSUtilities.extractAnyElements((XmlObject)meta, WSRFConstants.FRIENDLY_NAME)[0].newCursor();
            while (c.toNextToken() != XmlCursor.TokenType.TEXT) {
            }
            String res = c.getChars();
            c.dispose();
            return res;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFriendlyNameFromEPR(EndpointReferenceType epr) {
        try {
            if (epr == null || epr.getMetadata() == null) {
                return;
            }
            MetadataType meta = epr.getMetadata();
            XmlCursor cursor = meta.newCursor();
            try {
                if (WSUtilities.goToNextElement(cursor, WSRFConstants.FRIENDLY_NAME)) {
                    cursor.removeXml();
                }
            }
            finally {
                cursor.dispose();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static EndpointReferenceType makeServiceEPR(String serviceURL, String resourceID, QName portType) {
        EndpointReferenceType epr = WSUtilities.makeServiceEPR(serviceURL, resourceID);
        WSUtilities.addUGSRefparamToEpr(epr, resourceID);
        WSUtilities.addPortType(epr, portType);
        return epr;
    }

    public static EndpointReferenceType makeServiceEPR(String serviceURL, QName portType) {
        EndpointReferenceType epr = WSUtilities.makeServiceEPR(serviceURL);
        WSUtilities.addPortType(epr, portType);
        return epr;
    }

    public static EndpointReferenceType makeServiceEPR(String serviceURL, String resourceID) {
        EndpointReferenceType epr = EndpointReferenceType.Factory.newInstance();
        epr.addNewAddress().setStringValue(WSUtilities.makeServiceAddress(serviceURL, resourceID));
        return epr;
    }

    public static EndpointReferenceType makeServiceEPR(String serviceURL) {
        EndpointReferenceType epr = EndpointReferenceType.Factory.newInstance();
        epr.addNewAddress().setStringValue(serviceURL);
        return epr;
    }

    public static String makeServiceAddress(String serviceURL, String resourceID) {
        return serviceURL + "?res=" + resourceID;
    }

    public static void addPortType(EndpointReferenceType epr, QName portType) {
        MetadataType meta = epr.getMetadata();
        if (meta == null) {
            meta = epr.addNewMetadata();
        }
        XmlCursor n = meta.newCursor();
        n.toFirstContentToken();
        n.beginElement(WSRFConstants.INTERFACE_NAME);
        n.insertNamespace("x", portType.getNamespaceURI());
        n.insertChars("x:" + portType.getLocalPart());
        n.dispose();
    }

    public static void addServerIdentity(EndpointReferenceType epr, String dn) {
        MetadataType meta = epr.getMetadata();
        if (meta == null) {
            meta = epr.addNewMetadata();
        }
        XmlCursor n = meta.newCursor();
        n.toFirstContentToken();
        n.beginElement(WSRFConstants.SERVER_NAME);
        n.insertChars(dn);
        n.dispose();
    }

    public static void addFriendlyName(EndpointReferenceType epr, String friendlyName) {
        MetadataType meta = epr.getMetadata();
        if (meta == null) {
            meta = epr.addNewMetadata();
        }
        XmlCursor n = meta.newCursor();
        n.toFirstContentToken();
        n.beginElement(WSRFConstants.FRIENDLY_NAME);
        n.insertChars(friendlyName);
        n.dispose();
    }

    public static org.apache.cxf.ws.addressing.EndpointReferenceType toCXF(EndpointReferenceType epr) {
        XmlObject[] refs;
        org.apache.cxf.ws.addressing.EndpointReferenceType e = new org.apache.cxf.ws.addressing.EndpointReferenceType();
        AttributedURIType uri = new AttributedURIType();
        uri.setValue(epr.getAddress().getStringValue());
        e.setAddress(uri);
        if (epr.getReferenceParameters() != null && (refs = WSUtilities.extractAllChildren(epr.getReferenceParameters())) != null && refs.length > 0) {
            ReferenceParametersType refParams = new ReferenceParametersType();
            int i = 0;
            for (XmlObject r : refs) {
                try {
                    XmlCursor c = epr.getReferenceParameters().newCursor();
                    c.toChild(i);
                    ++i;
                    QName name = c.getName();
                    c.dispose();
                    String content = WSUtilities.extractElementTextAsString(r);
                    refParams.getAny().add(new JAXBElement(name, String.class, (Object)content));
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            e.setReferenceParameters(refParams);
        }
        return e;
    }

    public static XmlObject createXmlDoc(QName qName, String content, ClassLoader cl) {
        SchemaType st = null;
        if (cl != null) {
            st = XmlBeans.typeLoaderForClassLoader((ClassLoader)cl).findDocumentType(qName);
        }
        XmlObject pDoc = XmlObject.Factory.newInstance();
        if (st != null) {
            pDoc.changeType(st);
        }
        XmlCursor c = pDoc.newCursor();
        c.toFirstContentToken();
        c.insertElementWithText(qName, content);
        c.dispose();
        return pDoc;
    }
}

