/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.wsutil;

import eu.unicore.security.SecurityTokens;
import eu.unicore.security.wsutil.SecuritySession;
import eu.unicore.util.Log;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class SecuritySessionStore {
    private static final Logger log = Log.getLogger("unicore.security", SecuritySessionStore.class);
    private static final int DEF_MAX_SESSIONS_PER_USER = 5;
    private static final long CLEANUP_INTERVAL = 60000L;
    private final Map<String, SecuritySession> sessions = new HashMap<String, SecuritySession>();
    private final Map<String, AtomicInteger> sessionsPerUser = new HashMap<String, AtomicInteger>();
    private long lastCleanup = 0L;
    private final int maxPerUser;

    public SecuritySessionStore() {
        this(5);
    }

    public SecuritySessionStore(int maxPerUser) {
        this.maxPerUser = maxPerUser;
    }

    public synchronized void storeSession(SecuritySession session, SecurityTokens tokens) {
        this.sessions.put(session.getSessionID(), session);
        String userKey = this.getUserKey(tokens);
        session.setUserKey(userKey);
        AtomicInteger i = this.getOrCreateSessionCounter(userKey);
        int sessions = i.incrementAndGet();
        if (log.isDebugEnabled()) {
            log.debug("Created new security session <" + session.getSessionID() + " for <" + userKey + "> will expire in " + (double)session.getLifetime() / 1000.0 + "s");
        }
        if (this.lastCleanup + 60000L < System.currentTimeMillis()) {
            this.expelExpiredSessions();
        }
        if (this.maxPerUser > 0 && sessions > this.maxPerUser) {
            this.expelLRUSession(userKey);
        }
    }

    public synchronized SecuritySession getSession(String sessionID) {
        return this.sessions.get(sessionID);
    }

    private String getUserKey(SecurityTokens tokens) {
        return tokens.getEffectiveUserName() + "@" + tokens.getClientIP();
    }

    private synchronized AtomicInteger getOrCreateSessionCounter(String userKey) {
        AtomicInteger i = this.sessionsPerUser.get(userKey);
        if (i == null) {
            i = new AtomicInteger(0);
            this.sessionsPerUser.put(userKey, i);
        }
        return i;
    }

    private void decrementUserSessionCounter(String userKey) {
        AtomicInteger i = this.getOrCreateSessionCounter(userKey);
        int sessions = i.decrementAndGet();
        if (log.isDebugEnabled()) {
            log.debug("Sessions for " + userKey + " : " + sessions);
        }
    }

    private void expelExpiredSessions() {
        Iterator<Map.Entry<String, SecuritySession>> iterator = this.sessions.entrySet().iterator();
        while (iterator.hasNext()) {
            SecuritySession session = iterator.next().getValue();
            if (!session.isExpired()) continue;
            iterator.remove();
            this.decrementUserSessionCounter(session.getUserKey());
        }
        this.lastCleanup = System.currentTimeMillis();
    }

    private void expelLRUSession(String key) {
        SecuritySession lru = null;
        for (SecuritySession session : this.sessions.values()) {
            if (lru != null && lru.getLastAccessed() <= session.getLastAccessed()) continue;
            lru = session;
        }
        if (lru != null) {
            if (log.isDebugEnabled()) {
                log.debug("Removing LRU session for " + key);
            }
            if (null != this.sessions.remove(lru.getSessionID())) {
                this.decrementUserSessionCounter(key);
            }
        }
    }
}

