/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.wsutil;

import eu.unicore.security.wsutil.SecuritySession;
import eu.unicore.security.wsutil.SecuritySessionUtils;
import java.util.List;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.headers.Header;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;

public class SessionIDServerOutHandler
extends AbstractSoapInterceptor {
    private static final ThreadLocal<SecuritySession> threadSession = new ThreadLocal();

    public SessionIDServerOutHandler() {
        super("pre-protocol");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void handleMessage(SoapMessage message) {
        try {
            if (!MessageUtils.isOutbound((Message)message)) {
                return;
            }
            SecuritySession session = threadSession.get();
            if (session == null) {
                return;
            }
            String sessionID = session.getSessionID();
            if (sessionID == null) {
                return;
            }
            long lifetime = session.getLifetime();
            Header header = SecuritySessionUtils.buildHeader(sessionID, lifetime);
            List h = message.getHeaders();
            h.add(header);
        }
        finally {
            SessionIDServerOutHandler.clear();
        }
    }

    public static void setSession(SecuritySession session) {
        threadSession.set(session);
    }

    public static void clear() {
        threadSession.remove();
    }
}

