/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509;

import eu.emi.security.authn.x509.ValidationErrorCode;
import java.io.IOException;
import java.util.Properties;

public enum ValidationErrorCategory {
    GENERAL_INPUT,
    INCONSISTENT_PROXY_CHAIN,
    INVALID_PROXY_CERT,
    NAMESPACE,
    X509_BASIC,
    X509_CHAIN,
    POLICY,
    NAME_CONSTRAINT,
    CRL,
    OCSP,
    OTHER;

    private static Properties p;

    public static ValidationErrorCategory getErrorCategory(ValidationErrorCode code) {
        String category;
        if (p == null) {
            p = new Properties();
            try {
                p.load(ValidationErrorCategory.class.getResourceAsStream("/eu/emi/security/authn/x509/valiadationErrors.properties"));
            }
            catch (IOException e) {
                throw new RuntimeException("Resource with error codes can not be loaded as a class loader resource, probably library packaging error.", e);
            }
        }
        if ((category = p.getProperty(code.name() + ".category")) == null) {
            return OTHER;
        }
        try {
            return ValidationErrorCategory.valueOf(category);
        }
        catch (IllegalArgumentException e) {
            return OTHER;
        }
    }
}

