/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class CockroachDialectQueryHints {
    private final Pattern TABLE_QUERY_PATTERN = Pattern.compile("(?i)^\\s*(select\\b.+?\\bfrom\\b)(.+?)(\\bwhere\\b.+?)$");
    private final Pattern JOIN_HINT_PATTERN = Pattern.compile("(?i)(MERGE|HASH|LOOKUP|INVERTED)\\s+JOIN");
    private final Pattern JOIN_PATTERN = Pattern.compile("(?i)\\b(cross|natural\\s+(.*)\\b|(full|left|right)(\\s+outer)?)?\\s+join");
    private final String query;
    private final List<String> hints;

    public CockroachDialectQueryHints(String query, List<String> hintList) {
        this.query = query;
        this.hints = hintList;
    }

    public String getQueryHintString() {
        ArrayList<IndexHint> indexHints = new ArrayList<IndexHint>();
        JoinHint joinHint = null;
        for (String h : this.hints) {
            IndexHint indexHint = this.parseIndexHints(h);
            if (indexHint != null) {
                indexHints.add(indexHint);
                continue;
            }
            joinHint = this.parseJoinHints(h);
        }
        String result = this.addIndexHints(this.query, indexHints);
        return joinHint == null ? result : this.addJoinHint(this.query, joinHint);
    }

    private IndexHint parseIndexHints(String hint) {
        String[] parts = hint.split("@");
        if (parts.length == 2) {
            return new IndexHint(parts[0], hint);
        }
        return null;
    }

    private JoinHint parseJoinHints(String hint) {
        Matcher matcher = this.JOIN_HINT_PATTERN.matcher(hint);
        if (matcher.find()) {
            return new JoinHint(matcher.group(1));
        }
        return null;
    }

    String addIndexHints(String query, List<IndexHint> hints) {
        Matcher statementMatcher = this.TABLE_QUERY_PATTERN.matcher(query);
        if (statementMatcher.matches() && statementMatcher.groupCount() > 2) {
            String prefix = statementMatcher.group(1);
            String fromList = statementMatcher.group(2);
            String suffix = statementMatcher.group(3);
            fromList = this.addIndexHintsToFromList(fromList, hints);
            return prefix + fromList + suffix;
        }
        return query;
    }

    String addJoinHint(String query, JoinHint hint) {
        Matcher m = this.JOIN_PATTERN.matcher(query);
        StringBuilder buffer = new StringBuilder();
        int start = 0;
        while (m.find()) {
            buffer.append(query.substring(start, m.start()));
            if (m.group(1) == null) {
                buffer.append(" inner");
            } else {
                buffer.append(m.group(1));
            }
            buffer.append(" ").append(hint.joinType).append(" join");
            start = m.end();
        }
        buffer.append(query.substring(start));
        return buffer.toString();
    }

    String addIndexHintsToFromList(String fromList, List<IndexHint> hints) {
        String result = fromList;
        for (IndexHint hint : hints) {
            result = result.replaceAll("(?i)\\b" + hint.table + "\\b", hint.text);
        }
        return result;
    }

    static class JoinHint {
        final String joinType;

        JoinHint(String type) {
            this.joinType = type.toLowerCase(Locale.ROOT);
        }
    }

    static class IndexHint {
        final String table;
        final String text;

        IndexHint(String table, String text) {
            this.table = table;
            this.text = text;
        }
    }
}

