/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.util.Collections;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.LockOptions;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.internal.NoCallbackExecutionContext;
import org.hibernate.loader.ast.spi.SingleUniqueKeyEntityLoader;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SingularAttributeMapping;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.BaseExecutionContext;
import org.hibernate.sql.exec.internal.CallbackImpl;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.Callback;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParametersList;
import org.hibernate.sql.results.spi.ListResultsConsumer;

public class SingleUniqueKeyEntityLoaderStandard<T>
implements SingleUniqueKeyEntityLoader<T> {
    private final EntityMappingType entityDescriptor;
    private final ModelPart uniqueKeyAttribute;

    public SingleUniqueKeyEntityLoaderStandard(EntityMappingType entityDescriptor, SingularAttributeMapping uniqueKeyAttribute) {
        this.entityDescriptor = entityDescriptor;
        this.uniqueKeyAttribute = uniqueKeyAttribute instanceof ToOneAttributeMapping ? ((ToOneAttributeMapping)uniqueKeyAttribute).getForeignKeyDescriptor() : uniqueKeyAttribute;
    }

    @Override
    public EntityMappingType getLoadable() {
        return this.entityDescriptor;
    }

    @Override
    public T load(Object ukValue, LockOptions lockOptions, Boolean readOnly, SharedSessionContractImplementor session) {
        SessionFactoryImplementor sessionFactory = session.getFactory();
        JdbcParametersList.Builder builder = JdbcParametersList.newBuilder();
        SelectStatement sqlAst = LoaderSelectBuilder.createSelectByUniqueKey(this.entityDescriptor, Collections.emptyList(), this.uniqueKeyAttribute, null, new LoadQueryInfluencers(sessionFactory), LockOptions.NONE, builder::add, sessionFactory);
        JdbcServices jdbcServices = sessionFactory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
        JdbcParametersList jdbcParameters = builder.build();
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(jdbcParameters.size());
        int offset = jdbcParameterBindings.registerParametersForEachJdbcValue(ukValue, this.uniqueKeyAttribute, jdbcParameters, session);
        assert (offset == jdbcParameters.size());
        JdbcOperationQuerySelect jdbcSelect = sqlAstTranslatorFactory.buildSelectTranslator(sessionFactory, sqlAst).translate(jdbcParameterBindings, QueryOptions.NONE);
        List<Object> list = sessionFactory.getJdbcServices().getJdbcSelectExecutor().list(jdbcSelect, jdbcParameterBindings, new SingleUKEntityLoaderExecutionContext(session, readOnly), row -> row[0], ListResultsConsumer.UniqueSemantic.FILTER);
        switch (list.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (T)list.get(0);
            }
        }
        throw new HibernateException("More than one row with the given identifier was found: " + ukValue + ", for class: " + this.entityDescriptor.getEntityName());
    }

    @Override
    public Object resolveId(Object ukValue, SharedSessionContractImplementor session) {
        SessionFactoryImplementor sessionFactory = session.getFactory();
        JdbcParametersList.Builder jdbcParametersBuilder = JdbcParametersList.newBuilder();
        SelectStatement sqlAst = LoaderSelectBuilder.createSelectByUniqueKey(this.entityDescriptor, Collections.singletonList(this.entityDescriptor.getIdentifierMapping()), this.uniqueKeyAttribute, null, new LoadQueryInfluencers(sessionFactory), LockOptions.NONE, jdbcParametersBuilder::add, sessionFactory);
        JdbcServices jdbcServices = sessionFactory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
        JdbcParametersList jdbcParameters = jdbcParametersBuilder.build();
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(jdbcParameters.size());
        int offset = jdbcParameterBindings.registerParametersForEachJdbcValue(ukValue, this.uniqueKeyAttribute, jdbcParameters, session);
        assert (offset == jdbcParameters.size());
        JdbcOperationQuerySelect jdbcSelect = sqlAstTranslatorFactory.buildSelectTranslator(sessionFactory, sqlAst).translate(jdbcParameterBindings, QueryOptions.NONE);
        List<Object> list = sessionFactory.getJdbcServices().getJdbcSelectExecutor().list(jdbcSelect, jdbcParameterBindings, new NoCallbackExecutionContext(session), row -> row[0], ListResultsConsumer.UniqueSemantic.FILTER);
        assert (list.size() == 1);
        return list.get(0);
    }

    private static class SingleUKEntityLoaderExecutionContext
    extends BaseExecutionContext {
        private final Callback callback;
        private final QueryOptions queryOptions;

        public SingleUKEntityLoaderExecutionContext(SharedSessionContractImplementor session, Boolean readOnly) {
            super(session);
            this.queryOptions = readOnly == null ? QueryOptions.NONE : (readOnly != false ? QueryOptions.READ_ONLY : QueryOptions.READ_WRITE);
            this.callback = new CallbackImpl();
        }

        @Override
        public QueryOptions getQueryOptions() {
            return this.queryOptions;
        }

        @Override
        public Callback getCallback() {
            return this.callback;
        }
    }
}

