/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal;

import java.util.Objects;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.SqlExpressionAccess;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.results.internal.ResolvedSqlSelection;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;
import org.hibernate.type.BasicType;
import org.hibernate.type.JavaObjectType;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.java.JavaType;

public class SqlSelectionImpl
implements SqlSelection,
SqlExpressionAccess {
    private final int jdbcPosition;
    private final int valuesArrayPosition;
    private final Expression sqlExpression;
    private final JavaType<?> jdbcJavaType;
    private final boolean virtual;
    private transient ValueExtractor valueExtractor;

    public SqlSelectionImpl(Expression sqlExpression) {
        this(0, -1, null, sqlExpression, false);
    }

    public SqlSelectionImpl(int valuesArrayPosition, Expression sqlExpression) {
        this(valuesArrayPosition + 1, valuesArrayPosition, null, sqlExpression, false);
    }

    public SqlSelectionImpl(int jdbcPosition, int valuesArrayPosition, Expression sqlExpression, boolean virtual) {
        this(jdbcPosition, valuesArrayPosition, null, sqlExpression, virtual);
    }

    public SqlSelectionImpl(int jdbcPosition, int valuesArrayPosition, JavaType<?> jdbcJavaType, Expression sqlExpression, boolean virtual) {
        this(jdbcPosition, valuesArrayPosition, sqlExpression, jdbcJavaType, virtual, null);
    }

    protected SqlSelectionImpl(int jdbcPosition, int valuesArrayPosition, Expression sqlExpression, JavaType<?> jdbcJavaType, boolean virtual, ValueExtractor valueExtractor) {
        this.jdbcPosition = jdbcPosition;
        this.valuesArrayPosition = valuesArrayPosition;
        this.sqlExpression = sqlExpression;
        this.jdbcJavaType = jdbcJavaType;
        this.virtual = virtual;
        this.valueExtractor = valueExtractor;
    }

    private static ValueExtractor determineValueExtractor(Expression sqlExpression, JavaType<?> jdbcJavaType) {
        JdbcMapping jdbcMapping = sqlExpression.getExpressionType().getSingleJdbcMapping();
        if (jdbcJavaType == null || jdbcMapping.getMappedJavaType() == jdbcJavaType) {
            return jdbcMapping.getJdbcValueExtractor();
        }
        return jdbcMapping.getJdbcType().getExtractor(jdbcJavaType);
    }

    @Override
    public Expression getExpression() {
        return this.sqlExpression;
    }

    @Override
    public ValueExtractor getJdbcValueExtractor() {
        ValueExtractor extractor = this.valueExtractor;
        if (extractor == null) {
            this.valueExtractor = extractor = SqlSelectionImpl.determineValueExtractor(this.sqlExpression, this.jdbcJavaType);
        }
        return extractor;
    }

    @Override
    public int getJdbcResultSetIndex() {
        return this.jdbcPosition;
    }

    @Override
    public int getValuesArrayPosition() {
        return this.valuesArrayPosition;
    }

    @Override
    public JdbcMappingContainer getExpressionType() {
        return this.getExpression().getExpressionType();
    }

    @Override
    public boolean isVirtual() {
        return this.virtual;
    }

    @Override
    public Expression getSqlExpression() {
        return this.sqlExpression;
    }

    @Override
    public void accept(SqlAstWalker interpreter) {
        this.sqlExpression.accept(interpreter);
    }

    @Override
    public SqlSelection resolve(JdbcValuesMetadata jdbcResultsMetadata, SessionFactoryImplementor sessionFactory) {
        if (this.sqlExpression.getExpressionType() instanceof JavaObjectType) {
            BasicType<Object> resolvedType = jdbcResultsMetadata.resolveType(this.jdbcPosition, null, sessionFactory);
            return new ResolvedSqlSelection(this.jdbcPosition, this.valuesArrayPosition, this.sqlExpression, resolvedType);
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlSelection that = (SqlSelection)o;
        return this.jdbcPosition == that.getJdbcResultSetIndex() && this.valuesArrayPosition == that.getValuesArrayPosition() && Objects.equals(this.sqlExpression, that.getExpression()) && this.virtual == that.isVirtual();
    }

    public int hashCode() {
        return Objects.hash(this.jdbcPosition, this.valuesArrayPosition, this.sqlExpression, this.virtual);
    }
}

