/*
 * Decompiled with CFR 0.152.
 */
package org.apache.custos.core.identity.authzcache;

import org.apache.custos.core.identity.authzcache.AuthzCache;
import org.apache.custos.core.identity.authzcache.AuthzCacheEntry;
import org.apache.custos.core.identity.authzcache.AuthzCacheIndex;
import org.apache.custos.core.identity.authzcache.AuthzCacheManager;
import org.apache.custos.core.identity.authzcache.AuthzCachedStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultAuthzCacheManager
implements AuthzCacheManager {
    @Autowired
    private AuthzCache cache;

    @Override
    public AuthzCachedStatus getAuthzCachedStatus(AuthzCacheIndex authzCacheIndex) {
        if (this.isAuthzDecisionCached(authzCacheIndex)) {
            long currentTime;
            long timePassed;
            AuthzCacheEntry cacheEntry = this.getAuthzCacheEntry(authzCacheIndex);
            long expiryTime = cacheEntry.getExpiryTime();
            if (expiryTime > (timePassed = ((currentTime = System.currentTimeMillis()) - cacheEntry.getEntryTimestamp()) / 1000L)) {
                if (cacheEntry.getDecision()) {
                    return AuthzCachedStatus.AUTHORIZED;
                }
                return AuthzCachedStatus.NOT_AUTHORIZED;
            }
            this.removeAuthzCacheEntry(authzCacheIndex);
            return AuthzCachedStatus.NOT_CACHED;
        }
        return AuthzCachedStatus.NOT_CACHED;
    }

    @Override
    public void addToAuthzCache(AuthzCacheIndex authzCacheIndex, AuthzCacheEntry authzCacheEntry) {
        this.cache.put(authzCacheIndex, authzCacheEntry);
    }

    @Override
    public boolean isAuthzDecisionCached(AuthzCacheIndex authzCacheIndex) {
        return this.cache.containsKey(authzCacheIndex);
    }

    @Override
    public AuthzCacheEntry getAuthzCacheEntry(AuthzCacheIndex authzCacheIndex) {
        return (AuthzCacheEntry)this.cache.get(authzCacheIndex);
    }

    @Override
    public void removeAuthzCacheEntry(AuthzCacheIndex authzCacheIndex) {
        this.cache.remove(authzCacheIndex);
    }

    @Override
    public void clearCache() {
        this.cache.clear();
    }
}

