/*
 * Decompiled with CFR 0.152.
 */
package org.apache.custos.core.repo.tenant;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.custos.core.model.tenant.Tenant;
import org.apache.custos.core.repo.tenant.SearchTenantRepository;
import org.apache.custos.core.tenant.profile.api.TenantStatus;
import org.springframework.stereotype.Repository;

@Repository
public class SearchTenantRepositoryImpl
implements SearchTenantRepository {
    @PersistenceContext
    EntityManager entityManager;

    @Override
    public List<Tenant> searchTenants(String requestEmail, String status, long parentId, int limit, int offset, String type) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        String query = this.createSQLQuery(requestEmail, status, type, parentId, limit, offset, valueMap);
        Query q = this.entityManager.createNativeQuery(query, Tenant.class);
        for (String key : valueMap.keySet()) {
            q.setParameter(key, valueMap.get(key));
        }
        return q.getResultList();
    }

    private String createSQLQuery(String requestEmail, String status, String type, long parentId, int limit, int offset, Map<String, Object> valueMap) {
        Object query = "SELECT * FROM tenant E WHERE ";
        if (requestEmail != null && !requestEmail.isEmpty()) {
            query = (String)query + "E.requester_email = :requester_email AND ";
            valueMap.put("requester_email", requestEmail);
        }
        if (status != null && !status.isEmpty()) {
            query = (String)query + "E.status LIKE :status AND ";
            valueMap.put("status", status);
        } else {
            String defaultStatus = "'" + TenantStatus.REQUESTED.name() + "','" + TenantStatus.ACTIVE.name() + "','" + TenantStatus.DENIED.name() + "'";
            query = (String)query + "E.status IN (" + defaultStatus + ") AND ";
        }
        if (parentId > 0L) {
            query = (String)query + "E.parent_id = :parent_id AND ";
            valueMap.put("parent_id", parentId);
        }
        if (type != null && type.equals("ADMIN")) {
            query = (String)query + "E.parent_id = :parent_id AND ";
            valueMap.put("parent_id", 0);
        }
        query = ((String)query).substring(0, ((String)query).length() - 5);
        query = (String)query + " ORDER BY E.created_at DESC";
        if (limit > 0) {
            query = (String)query + " LIMIT :limit OFFSET :offset";
            valueMap.put("limit", limit);
            valueMap.put("offset", offset);
        }
        return query;
    }
}

