<!--
    Licensed to the Apache Software Foundation (ASF) under one
    or more contributor license agreements.  See the NOTICE file
    distributed with this work for additional information
    regarding copyright ownership.  The ASF licenses this file
    to you under the Apache License, Version 2.0 (the
    "License"); you may not use this file except in compliance
    with the License.  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing,
    software distributed under the License is distributed on an
    "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, either express or implied.  See the License for the
    specific language governing permissions and limitations
    under the License.
-->

# Apache Custos Jupyterhub Authenticator
The Apache Custos Jupyterhub Authenticator provides CILogon based federated authentication for Jupyterhub. In addtion it provides access to Custos IAM solutions such as
 - Fine-Grained Authorization

 - Secret Management

- Service Accounts ..etc.

Additional Information : https://airavata.apache.org/custos/


### Folder Structure

 - custosauthenticator
      
    Includes oidc plugin to connect with custos oauth services 
    
 ### Configuration
 Add following configuration to Jupyter  Hub in helm chart configuration (values.yaml). You need to request an tenant from 
 Custos Portal to start
 
 - dev:  https://dev.portal.usecustos.org/
 - production: https://portal.usecustos.org/
 
 #### Hub configuration
 ```
 hub:
  config:
    CustosOAuthenticator:
      client_id: CHANGE_ME
      client_secret: CHANGE_ME
      oauth_callback_url: https://<jupyter_host>/hub/oauth_callback
      custos_host: custos.scigap.org      
    JupyterHub:     
      authenticator_class: custosauthenticator.custos.CustosOAuthenticator 
 ```
    
    
    
              
 
              


 
  