/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.container;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutorServiceWrapper
extends AbstractExecutorService
implements Runnable {
    private final ExecutorService delegate;
    private final ConcurrentLinkedQueue<Runnable> queue = new ConcurrentLinkedQueue();
    private final AtomicBoolean triggered = new AtomicBoolean();
    private final AtomicBoolean shutdown = new AtomicBoolean();
    private Thread runningThread;

    public ExecutorServiceWrapper(ExecutorService delegate) {
        this.delegate = delegate;
    }

    @Override
    public void shutdown() {
        this.shutdown.set(true);
    }

    @Override
    public List<Runnable> shutdownNow() {
        ArrayList<Runnable> pending = new ArrayList<Runnable>();
        if (this.shutdown.compareAndSet(false, true)) {
            Runnable runnable;
            while ((runnable = this.queue.poll()) != null) {
                pending.add(runnable);
            }
        }
        return pending;
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown.get();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated() || this.isShutdown() && this.queue.isEmpty() && !this.triggered.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long millis = unit.toMillis(timeout);
        if (millis > 0L) {
            long max = System.currentTimeMillis() + millis;
            AtomicBoolean atomicBoolean = this.triggered;
            synchronized (atomicBoolean) {
                while (System.currentTimeMillis() < max) {
                    if (this.isTerminated()) {
                        return true;
                    }
                    this.triggered.wait(millis);
                }
            }
        }
        return this.isTerminated();
    }

    @Override
    public void execute(Runnable command) {
        if (this.isShutdown()) {
            throw new RejectedExecutionException("Executor has been shut down");
        }
        this.queue.add(command);
        this.triggerExecution();
    }

    protected void triggerExecution() {
        if (this.triggered.compareAndSet(false, true)) {
            this.delegate.execute(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        AtomicBoolean atomicBoolean;
        try {
            atomicBoolean = this.triggered;
            synchronized (atomicBoolean) {
                this.runningThread = Thread.currentThread();
            }
            while (true) {
                Runnable runnable;
                if ((runnable = this.queue.poll()) == null) {
                    return;
                }
                try {
                    runnable.run();
                }
                catch (Throwable e) {
                    Thread thread = Thread.currentThread();
                    thread.getUncaughtExceptionHandler().uncaughtException(thread, e);
                }
            }
        }
        finally {
            atomicBoolean = this.triggered;
            synchronized (atomicBoolean) {
                this.runningThread = null;
                this.triggered.set(false);
                this.triggered.notifyAll();
            }
            if (!this.isShutdown() && !this.queue.isEmpty()) {
                this.triggerExecution();
            }
        }
    }
}

