/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.typecomputer.impl;

import org.apache.asterix.om.typecomputer.base.AbstractResultTypeComputer;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;

public class NumericRoundTypeComputer
extends AbstractResultTypeComputer {
    public static final NumericRoundTypeComputer INSTANCE = new NumericRoundTypeComputer(false);
    public static final NumericRoundTypeComputer INSTANCE_ROUND_HF_TRUNC = new NumericRoundTypeComputer(true);
    private final boolean returnSameIntType;

    private NumericRoundTypeComputer(boolean returnSameIntType) {
        this.returnSameIntType = returnSameIntType;
    }

    @Override
    protected IAType getResultType(ILogicalExpression expr, IAType ... strippedInputTypes) throws AlgebricksException {
        IAType returnType;
        ATypeTag firstArgType = strippedInputTypes[0].getTypeTag();
        ATypeTag secondArgType = strippedInputTypes.length > 1 ? strippedInputTypes[1].getTypeTag() : null;
        switch (firstArgType) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                returnType = this.returnSameIntType ? strippedInputTypes[0] : BuiltinType.AINT64;
                break;
            }
            case FLOAT: 
            case DOUBLE: 
            case ANY: {
                returnType = strippedInputTypes[0];
                break;
            }
            default: {
                return BuiltinType.ANULL;
            }
        }
        if (secondArgType == null) {
            return returnType;
        }
        switch (secondArgType) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case ANY: {
                return returnType;
            }
            case FLOAT: 
            case DOUBLE: {
                return AUnionType.createNullableType(returnType);
            }
        }
        return BuiltinType.ANULL;
    }
}

