/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.metadata;

import java.io.Serializable;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.MetadataException;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;

public interface IMetadataLock {
    public void lock(Mode var1) throws InterruptedException;

    public void unlock(Mode var1);

    public LockKey getKey();

    default public void upgrade(Mode from, Mode to) throws AlgebricksException {
        throw new MetadataException(ErrorCode.ILLEGAL_LOCK_UPGRADE_OPERATION, new Serializable[]{from, to});
    }

    default public void downgrade(Mode from, Mode to) throws AlgebricksException {
        throw new MetadataException(ErrorCode.ILLEGAL_LOCK_DOWNGRADE_OPERATION, new Serializable[]{from, to});
    }

    public static interface LockKey {
        public boolean equals(Object var1);

        public int hashCode();
    }

    public static enum Mode {
        READ,
        MODIFY,
        INDEX_BUILD,
        EXCLUSIVE_MODIFY,
        UPGRADED_WRITE,
        WRITE;


        public boolean contains(Mode mode) {
            if (mode == this) {
                return true;
            }
            if (this == WRITE || this == UPGRADED_WRITE) {
                return true;
            }
            if (this == EXCLUSIVE_MODIFY && (mode == MODIFY || mode == INDEX_BUILD)) {
                return true;
            }
            return mode == READ;
        }
    }
}

