/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.http.policy;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpPipelineNextSyncPolicy;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.tracing.SpanKind;
import com.azure.core.util.tracing.StartSpanOptions;
import com.azure.core.util.tracing.Tracer;
import reactor.core.publisher.Mono;

public class InstrumentationPolicy
implements HttpPipelinePolicy {
    private static final String HTTP_USER_AGENT = "http.user_agent";
    private static final String HTTP_METHOD = "http.method";
    private static final String HTTP_URL = "http.url";
    private static final String HTTP_STATUS_CODE = "http.status_code";
    private static final String SERVICE_REQUEST_ID_ATTRIBUTE = "serviceRequestId";
    private static final String CLIENT_REQUEST_ID_ATTRIBUTE = "requestId";
    private static final String REACTOR_HTTP_TRACE_CONTEXT_KEY = "instrumentation-context-key";
    private static final HttpHeaderName SERVICE_REQUEST_ID_HEADER = HttpHeaderName.fromString("x-ms-request-id");
    private static final String LEGACY_OTEL_POLICY_NAME = "io.opentelemetry.javaagent.instrumentation.azurecore.v1_19.shaded.com.azure.core.tracing.opentelemetry.OpenTelemetryHttpPolicy";
    private static final ClientLogger LOGGER = new ClientLogger(InstrumentationPolicy.class);
    private Tracer tracer;
    private static boolean foundLegacyOTelPolicy;

    public void initialize(Tracer tracer) {
        this.tracer = tracer;
    }

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        if (!this.isTracingEnabled(context)) {
            return next.process();
        }
        return Mono.defer(() -> {
            Context span = this.startSpan(context);
            return next.process().doOnSuccess(response -> this.endSpan((HttpResponse)response, span)).doOnCancel(() -> this.tracer.end("cancel", null, span)).doOnError(exception -> this.tracer.end(null, (Throwable)exception, span));
        });
    }

    @Override
    public HttpResponse processSync(HttpPipelineCallContext context, HttpPipelineNextSyncPolicy next) {
        HttpResponse httpResponse;
        block10: {
            if (!this.isTracingEnabled(context)) {
                return next.processSync();
            }
            Context span = this.startSpan(context);
            AutoCloseable scope = this.tracer.makeSpanCurrent(span);
            try {
                HttpResponse response = next.processSync();
                this.endSpan(response, span);
                httpResponse = response;
                if (scope == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException ex) {
                    this.tracer.end(null, (Throwable)ex, span);
                    throw ex;
                }
                catch (Exception ex) {
                    this.tracer.end(null, (Throwable)ex, span);
                    throw LOGGER.logExceptionAsWarning(new RuntimeException(ex));
                }
            }
            scope.close();
        }
        return httpResponse;
    }

    private Context startSpan(HttpPipelineCallContext azContext) {
        HttpRequest request = azContext.getHttpRequest();
        String methodName = request.getHttpMethod().toString();
        StartSpanOptions spanOptions = new StartSpanOptions(SpanKind.CLIENT).setAttribute(HTTP_METHOD, methodName).setAttribute(HTTP_URL, request.getUrl().toString());
        Context span = this.tracer.start("HTTP " + methodName, spanOptions, azContext.getContext());
        this.addPostSamplingAttributes(span, request);
        this.tracer.injectContext((k, v) -> request.getHeaders().set((String)k, (String)v), span);
        return span;
    }

    private void addPostSamplingAttributes(Context span, HttpRequest request) {
        String requestId;
        String userAgent = request.getHeaders().getValue(HttpHeaderName.USER_AGENT);
        if (!CoreUtils.isNullOrEmpty(userAgent)) {
            this.tracer.setAttribute(HTTP_USER_AGENT, userAgent, span);
        }
        if (!CoreUtils.isNullOrEmpty(requestId = request.getHeaders().getValue(HttpHeaderName.X_MS_CLIENT_REQUEST_ID))) {
            this.tracer.setAttribute(CLIENT_REQUEST_ID_ATTRIBUTE, requestId, span);
        }
    }

    private void endSpan(HttpResponse response, Context span) {
        if (response != null) {
            int statusCode = response.getStatusCode();
            this.tracer.setAttribute(HTTP_STATUS_CODE, statusCode, span);
            String requestId = response.getHeaderValue(SERVICE_REQUEST_ID_HEADER);
            if (requestId != null) {
                this.tracer.setAttribute(SERVICE_REQUEST_ID_ATTRIBUTE, requestId, span);
            }
            this.tracer.end(statusCode >= 400 ? "error" : null, null, span);
        }
        this.tracer.end("", null, span);
    }

    private boolean isTracingEnabled(HttpPipelineCallContext context) {
        return this.tracer != null && this.tracer.isEnabled() && !foundLegacyOTelPolicy && (Boolean)context.getData("disable-tracing").orElse(false) == false;
    }

    static {
        try {
            Class.forName(LEGACY_OTEL_POLICY_NAME, true, HttpPipelinePolicy.class.getClassLoader());
            foundLegacyOTelPolicy = true;
        }
        catch (ClassNotFoundException e) {
            foundLegacyOTelPolicy = false;
        }
    }
}

