/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.compression;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.asterix.common.config.StorageProperties;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.storage.ICompressionManager;
import org.apache.hyracks.api.compression.ICompressorDecompressorFactory;
import org.apache.hyracks.api.io.IJsonSerializable;
import org.apache.hyracks.storage.common.compression.NoOpCompressorDecompressorFactory;
import org.apache.hyracks.storage.common.compression.SnappyCompressorDecompressorFactory;

public class CompressionManager
implements ICompressionManager {
    private static final Map<String, Class<? extends ICompressorDecompressorFactory>> REGISTERED_SCHEMES = CompressionManager.getRegisteredSchemes();
    public static final String NONE = "none";
    private final String defaultScheme;

    private static Map<String, Class<? extends ICompressorDecompressorFactory>> getRegisteredSchemes() {
        HashMap<String, Class<? extends ICompressorDecompressorFactory>> registeredSchemes = new HashMap<String, Class<? extends ICompressorDecompressorFactory>>();
        registeredSchemes.put(NONE, NoOpCompressorDecompressorFactory.class);
        registeredSchemes.put("snappy", SnappyCompressorDecompressorFactory.class);
        return registeredSchemes;
    }

    public CompressionManager(StorageProperties storageProperties) {
        this.validateCompressionConfiguration(storageProperties);
        this.defaultScheme = storageProperties.getCompressionScheme();
    }

    public ICompressorDecompressorFactory getFactory(String schemeName) throws CompilationException {
        String scheme = this.getDdlOrDefaultCompressionScheme(schemeName);
        Class<? extends ICompressorDecompressorFactory> clazz = REGISTERED_SCHEMES.get(scheme);
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException("Failed to instantiate compressor/decompressor: " + scheme, e);
        }
    }

    public String getDdlOrDefaultCompressionScheme(String ddlScheme) throws CompilationException {
        if (ddlScheme != null && !CompressionManager.isRegisteredScheme(ddlScheme)) {
            throw new CompilationException(ErrorCode.UNKNOWN_COMPRESSION_SCHEME, new Serializable[]{ddlScheme, this.formatSupportedValues()});
        }
        return ddlScheme != null ? ddlScheme : this.defaultScheme;
    }

    public static void registerCompressorDecompressorsFactoryClasses(Map<String, Class<? extends IJsonSerializable>> registeredClasses) {
        for (Class<? extends ICompressorDecompressorFactory> clazz : REGISTERED_SCHEMES.values()) {
            registeredClasses.put(clazz.getSimpleName(), clazz);
        }
    }

    public static boolean isRegisteredScheme(String schemeName) {
        return schemeName != null && REGISTERED_SCHEMES.containsKey(schemeName.toLowerCase());
    }

    private void validateCompressionConfiguration(StorageProperties storageProperties) {
        if (!CompressionManager.isRegisteredScheme(storageProperties.getCompressionScheme())) {
            String option = StorageProperties.Option.STORAGE_COMPRESSION_BLOCK.ini();
            String value = storageProperties.getCompressionScheme();
            throw new IllegalStateException("Invalid compression configuration (" + option + " = " + value + "). Valid values are: " + this.formatSupportedValues());
        }
    }

    private String formatSupportedValues() {
        StringBuilder schemes = new StringBuilder();
        Iterator<String> iterator = REGISTERED_SCHEMES.keySet().iterator();
        schemes.append('[');
        schemes.append(iterator.next());
        while (iterator.hasNext()) {
            schemes.append(',');
            schemes.append(iterator.next());
        }
        schemes.append(']');
        return schemes.toString();
    }
}

