/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SleepDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LogManager.getLogger();
    public static final IFunctionDescriptorFactory FACTORY = SleepDescriptor::new;

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IEvaluatorContext ctx) throws HyracksDataException {
                return new IScalarEvaluator(){
                    private IPointable argTime = new VoidPointable();
                    private final IScalarEvaluator evalValue;
                    private final IScalarEvaluator evalTime;
                    {
                        this.evalValue = args[0].createScalarEvaluator(ctx);
                        this.evalTime = args[1].createScalarEvaluator(ctx);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        this.evalTime.evaluate(tuple, this.argTime);
                        byte[] bytes = this.argTime.getByteArray();
                        int offset = this.argTime.getStartOffset();
                        long time = ATypeHierarchy.getLongValue((String)SleepDescriptor.this.getIdentifier().getName(), (int)1, (byte[])bytes, (int)offset);
                        try {
                            if (LOGGER.isInfoEnabled()) {
                                LOGGER.log(Level.INFO, ctx.getTaskContext().getTaskAttemptId() + " sleeping for " + time + " ms");
                            }
                            Thread.sleep(time);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                        finally {
                            if (LOGGER.isInfoEnabled()) {
                                LOGGER.log(Level.INFO, ctx.getTaskContext().getTaskAttemptId() + " done sleeping for " + time + " ms");
                            }
                        }
                        this.evalValue.evaluate(tuple, result);
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.SLEEP;
    }
}

