/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.records;

import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.asterix.builders.RecordBuilder;
import org.apache.asterix.formats.nontagged.BinaryComparatorFactoryProvider;
import org.apache.asterix.om.pointables.ARecordVisitablePointable;
import org.apache.asterix.om.pointables.base.DefaultOpenFieldType;
import org.apache.asterix.om.pointables.base.IVisitablePointable;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.runtime.evaluators.functions.CastTypeEvaluator;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

class RecordReplaceEvaluator
implements IScalarEvaluator {
    private final IPointable inputRecordPointable = new VoidPointable();
    private final IPointable oldValuePointable = new VoidPointable();
    private final IPointable newValuePointable = new VoidPointable();
    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private final DataOutput resultOutput = this.resultStorage.getDataOutput();
    private final RecordBuilder outRecordBuilder = new RecordBuilder();
    private final IScalarEvaluator eval0;
    private final IScalarEvaluator eval1;
    private final IScalarEvaluator eval2;
    private final ARecordVisitablePointable openRecordPointable;
    private final CastTypeEvaluator inputRecordCaster;
    private final CastTypeEvaluator newValueRecordCaster;
    private final IBinaryComparator comp;

    RecordReplaceEvaluator(IScalarEvaluator eval0, IScalarEvaluator eval1, IScalarEvaluator eval2, IAType[] argTypes) {
        this.eval0 = eval0;
        this.eval1 = eval1;
        this.eval2 = eval2;
        this.openRecordPointable = new ARecordVisitablePointable(DefaultOpenFieldType.NESTED_OPEN_RECORD_TYPE);
        this.inputRecordCaster = new CastTypeEvaluator((IAType)BuiltinType.ANY, argTypes[0], eval0);
        this.newValueRecordCaster = new CastTypeEvaluator((IAType)BuiltinType.ANY, argTypes[2], eval2);
        this.comp = BinaryComparatorFactoryProvider.INSTANCE.getBinaryComparatorFactory((Object)BuiltinType.ANY, (Object)argTypes[1], true).createBinaryComparator();
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        this.resultStorage.reset();
        this.eval0.evaluate(tuple, this.inputRecordPointable);
        this.eval1.evaluate(tuple, this.oldValuePointable);
        this.eval2.evaluate(tuple, this.newValuePointable);
        if (this.containsMissing(this.inputRecordPointable, this.oldValuePointable, this.newValuePointable)) {
            this.writeTypeTag(ATypeTag.SERIALIZED_MISSING_TYPE_TAG);
            result.set((IValueReference)this.resultStorage);
            return;
        }
        ATypeTag inputObjectType = PointableHelper.getTypeTag((IValueReference)this.inputRecordPointable);
        ATypeTag oldValueType = PointableHelper.getTypeTag((IValueReference)this.oldValuePointable);
        if (inputObjectType != ATypeTag.OBJECT || oldValueType == ATypeTag.NULL) {
            this.writeTypeTag(ATypeTag.SERIALIZED_NULL_TYPE_TAG);
            result.set((IValueReference)this.resultStorage);
            return;
        }
        this.inputRecordCaster.evaluate(tuple, this.inputRecordPointable);
        ATypeTag newValueType = PointableHelper.getTypeTag((IValueReference)this.newValuePointable);
        if (newValueType.isDerivedType()) {
            this.newValueRecordCaster.evaluate(tuple, this.newValuePointable);
        }
        this.resultStorage.reset();
        this.buildOutputRecord();
        result.set((IValueReference)this.resultStorage);
    }

    private void buildOutputRecord() throws HyracksDataException {
        this.openRecordPointable.set((IValueReference)this.inputRecordPointable);
        this.outRecordBuilder.reset(DefaultOpenFieldType.NESTED_OPEN_RECORD_TYPE);
        this.outRecordBuilder.init();
        List fieldNames = this.openRecordPointable.getFieldNames();
        List fieldValues = this.openRecordPointable.getFieldValues();
        int fieldCount = fieldNames.size();
        for (int i = 0; i < fieldCount; ++i) {
            IVisitablePointable fieldName = (IVisitablePointable)fieldNames.get(i);
            IVisitablePointable fieldValue = (IVisitablePointable)fieldValues.get(i);
            if (this.isEqual((IPointable)fieldValue, this.oldValuePointable)) {
                this.outRecordBuilder.addField((IValueReference)fieldName, (IValueReference)this.newValuePointable);
                continue;
            }
            this.outRecordBuilder.addField((IValueReference)fieldName, (IValueReference)fieldValue);
        }
        this.outRecordBuilder.write(this.resultOutput, true);
    }

    private boolean containsMissing(IPointable ... pointables) {
        for (int i = 0; i < pointables.length; ++i) {
            if (PointableHelper.getTypeTag((IValueReference)pointables[i]) != ATypeTag.MISSING) continue;
            return true;
        }
        return false;
    }

    private void writeTypeTag(byte typeTag) throws HyracksDataException {
        try {
            this.resultOutput.writeByte(typeTag);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    private boolean isEqual(IPointable value1, IPointable value2) throws HyracksDataException {
        return this.comp.compare(value1.getByteArray(), value1.getStartOffset(), value1.getLength(), value2.getByteArray(), value2.getStartOffset(), value2.getLength()) == 0;
    }
}

