/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.stream;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.asterix.external.dataflow.AbstractFeedDataFlowController;
import org.apache.asterix.external.input.stream.AbstractMultipleInputStream;
import org.apache.asterix.external.util.FeedLogManager;
import org.apache.asterix.external.util.FileSystemWatcher;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IError;
import org.apache.hyracks.api.util.ExceptionUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LocalFSInputStream
extends AbstractMultipleInputStream {
    private static final Logger LOGGER = LogManager.getLogger();
    private final FileSystemWatcher watcher;
    private File currentFile;
    private String lastFileName = "";

    public LocalFSInputStream(FileSystemWatcher watcher) {
        this.watcher = watcher;
    }

    @Override
    public void setController(AbstractFeedDataFlowController controller) {
        super.setController(controller);
    }

    @Override
    public void setFeedLogManager(FeedLogManager logManager) throws HyracksDataException {
        super.setFeedLogManager(logManager);
        this.watcher.setFeedLogManager(logManager);
    }

    @Override
    public void close() throws IOException {
        IOException ioe = null;
        if (this.in != null) {
            try {
                this.closeFile();
            }
            catch (Exception e) {
                ioe = new IOException(e);
            }
        }
        try {
            this.watcher.close();
        }
        catch (Exception e) {
            if (ioe == null) {
                throw e;
            }
            ioe.addSuppressed(e);
            throw ioe;
        }
    }

    private void closeFile() throws IOException {
        if (this.in != null) {
            if (this.logManager != null) {
                this.logManager.endPartition(this.currentFile.getAbsolutePath());
            }
            try {
                this.in.close();
            }
            finally {
                this.in = null;
                this.currentFile = null;
            }
        }
    }

    @Override
    protected boolean advance() throws IOException {
        String tmpLastFileName = "";
        if (this.currentFile != null) {
            tmpLastFileName = this.currentFile.getPath();
        }
        this.closeFile();
        this.currentFile = this.watcher.poll();
        if (this.currentFile == null) {
            if (this.controller != null) {
                this.controller.flush();
            }
            this.currentFile = this.watcher.take();
        }
        if (this.currentFile != null) {
            this.in = new FileInputStream(this.currentFile);
            this.lastFileName = tmpLastFileName;
            if (this.notificationHandler != null) {
                this.notificationHandler.notifyNewSource();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean stop() throws Exception {
        this.closeFile();
        this.watcher.close();
        return true;
    }

    @Override
    public boolean handleException(Throwable th) {
        if (this.in == null) {
            return false;
        }
        Throwable root = ExceptionUtils.getRootCause((Throwable)th);
        if (root instanceof HyracksDataException) {
            HyracksDataException r = (HyracksDataException)root;
            boolean advance = false;
            if (r.matchesAny((IError)org.apache.asterix.common.exceptions.ErrorCode.RECORD_READER_MALFORMED_INPUT_STREAM, new IError[]{ErrorCode.PARSING_ERROR})) {
                this.logCorruptedInput();
                advance = true;
            } else if (r.matches((IError)org.apache.asterix.common.exceptions.ErrorCode.INPUT_RECORD_READER_CHAR_ARRAY_RECORD_TOO_LARGE)) {
                advance = true;
            }
            if (advance) {
                try {
                    this.advance();
                    return true;
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARN, "An exception was thrown while trying to skip a file", (Throwable)e);
                }
            }
        }
        LOGGER.log(Level.WARN, "Failed to recover from failure", th);
        return false;
    }

    @Override
    public String getStreamName() {
        return this.currentFile == null ? "" : this.currentFile.getPath();
    }

    @Override
    public String getPreviousStreamName() {
        return this.lastFileName;
    }

    private void logCorruptedInput() {
        if (this.currentFile != null) {
            try {
                this.logManager.logRecord(this.currentFile.getAbsolutePath(), "Corrupted input file");
            }
            catch (IOException e) {
                LOGGER.log(Level.WARN, "Filed to write to feed log file", (Throwable)e);
            }
            LOGGER.log(Level.WARN, "Corrupted input file: " + this.currentFile.getAbsolutePath());
        }
    }
}

