/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.clause;

import java.util.Objects;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.AbstractClause;
import org.apache.asterix.lang.common.base.Clause;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;

public class LimitClause
extends AbstractClause {
    private Expression limitExpr;
    private Expression offset;

    public LimitClause(Expression limitExpr, Expression offset) {
        if (limitExpr == null && offset == null) {
            throw new IllegalArgumentException();
        }
        this.limitExpr = limitExpr;
        this.offset = offset;
    }

    public Expression getLimitExpr() {
        return this.limitExpr;
    }

    public void setLimitExpr(Expression limitexpr) {
        this.limitExpr = limitexpr;
    }

    public boolean hasLimitExpr() {
        return this.limitExpr != null;
    }

    public Expression getOffset() {
        return this.offset;
    }

    public void setOffset(Expression offset) {
        this.offset = offset;
    }

    public boolean hasOffset() {
        return this.offset != null;
    }

    @Override
    public Clause.ClauseType getClauseType() {
        return Clause.ClauseType.LIMIT_CLAUSE;
    }

    @Override
    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return visitor.visit(this, arg);
    }

    public int hashCode() {
        return Objects.hash(this.limitExpr, this.offset);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LimitClause)) {
            return false;
        }
        LimitClause target = (LimitClause)object;
        return Objects.equals(this.limitExpr, target.getLimitExpr()) && Objects.equals(this.offset, target.getOffset());
    }
}

