/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.logical;

import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractAssignOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.LocalOrderProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.VariablePropagationPolicy;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.algebra.typing.PropagatingTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;

public class AssignOperator
extends AbstractAssignOperator {
    private LocalOrderProperty explicitOrderingProperty;

    public AssignOperator(List<LogicalVariable> vars, List<Mutable<ILogicalExpression>> exprs) {
        super(vars, exprs);
    }

    public AssignOperator(LogicalVariable var, Mutable<ILogicalExpression> expr) {
        this.variables.add(var);
        this.expressions.add(expr);
    }

    @Override
    public LogicalOperatorTag getOperatorTag() {
        return LogicalOperatorTag.ASSIGN;
    }

    @Override
    public <R, T> R accept(ILogicalOperatorVisitor<R, T> visitor, T arg) throws AlgebricksException {
        return visitor.visitAssignOperator(this, arg);
    }

    @Override
    public VariablePropagationPolicy getVariablePropagationPolicy() {
        return this.createVariablePropagationPolicy(true);
    }

    @Override
    public boolean isMap() {
        return true;
    }

    @Override
    public IVariableTypeEnvironment computeOutputTypeEnvironment(ITypingContext ctx) throws AlgebricksException {
        PropagatingTypeEnvironment env = this.createPropagatingAllInputsTypeEnvironment(ctx);
        int n = this.variables.size();
        for (int i = 0; i < n; ++i) {
            env.setVarType((LogicalVariable)this.variables.get(i), ctx.getExpressionTypeComputer().getType((ILogicalExpression)((Mutable)this.expressions.get(i)).getValue(), ctx.getMetadataProvider(), env));
        }
        return env;
    }

    @Override
    public boolean requiresVariableReferenceExpressions() {
        return false;
    }

    public LocalOrderProperty getExplicitOrderingProperty() {
        return this.explicitOrderingProperty;
    }

    public void setExplicitOrderingProperty(LocalOrderProperty explicitOrderingProperty) {
        this.explicitOrderingProperty = explicitOrderingProperty;
    }
}

