/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.physical;

import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.IHyracksJobBuilder;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.base.PhysicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ProjectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.AbstractPropagatePropertiesForUsedVariablesPOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.IPhysicalPropertiesVector;
import org.apache.hyracks.algebricks.core.algebra.properties.PhysicalRequirements;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenHelper;
import org.apache.hyracks.algebricks.runtime.base.IPushRuntimeFactory;
import org.apache.hyracks.algebricks.runtime.operators.std.StreamProjectRuntimeFactory;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;

public class StreamProjectPOperator
extends AbstractPropagatePropertiesForUsedVariablesPOperator {
    private boolean flushFramesRapidly;

    @Override
    public PhysicalOperatorTag getOperatorTag() {
        return PhysicalOperatorTag.STREAM_PROJECT;
    }

    @Override
    public boolean isMicroOperator() {
        return true;
    }

    @Override
    public PhysicalRequirements getRequiredPropertiesForChildren(ILogicalOperator op, IPhysicalPropertiesVector reqdByParent, IOptimizationContext context) {
        return this.emptyUnaryRequirements();
    }

    @Override
    public void contributeRuntimeOperator(IHyracksJobBuilder builder, JobGenContext context, ILogicalOperator op, IOperatorSchema propagatedSchema, IOperatorSchema[] inputSchemas, IOperatorSchema outerPlanSchema) throws AlgebricksException {
        ProjectOperator project = (ProjectOperator)op;
        int[] projectionList = new int[project.getVariables().size()];
        int i = 0;
        for (LogicalVariable v : project.getVariables()) {
            int pos = inputSchemas[0].findVariable(v);
            if (pos < 0) {
                throw new AlgebricksException("Could not find variable " + v + ".");
            }
            projectionList[i++] = pos;
        }
        StreamProjectRuntimeFactory runtime = new StreamProjectRuntimeFactory(projectionList, this.flushFramesRapidly);
        runtime.setSourceLocation(project.getSourceLocation());
        RecordDescriptor recDesc = JobGenHelper.mkRecordDescriptor(context.getTypeEnvironment(op), propagatedSchema, context);
        builder.contributeMicroOperator(project, (IPushRuntimeFactory)runtime, recDesc);
        ILogicalOperator src = (ILogicalOperator)project.getInputs().get(0).getValue();
        builder.contributeGraphEdge(src, 0, project, 0);
    }

    @Override
    public void computeDeliveredProperties(ILogicalOperator op, IOptimizationContext context) {
        ProjectOperator p = (ProjectOperator)op;
        this.computeDeliveredPropertiesForUsedVariables(p, p.getVariables());
    }

    public void setRapidFrameFlush(boolean flushFramesRapidly) {
        this.flushFramesRapidly = flushFramesRapidly;
    }

    @Override
    public boolean expensiveThanMaterialization() {
        return true;
    }
}

