/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import java.util.Objects;
import org.apache.hyracks.api.io.FileReference;

public class IndexComponentFileReference
implements Comparable<IndexComponentFileReference> {
    private FileReference fileRef;
    private String fullPath;
    private String fileName;
    private long sequenceStart;
    private long sequenceEnd;

    private IndexComponentFileReference() {
    }

    public static IndexComponentFileReference of(String file) {
        IndexComponentFileReference ref = new IndexComponentFileReference();
        ref.fileName = file;
        String[] splits = file.split("_");
        ref.sequenceStart = Long.parseLong(splits[0]);
        ref.sequenceEnd = Long.parseLong(splits[1]);
        return ref;
    }

    public static IndexComponentFileReference of(FileReference fileRef) {
        IndexComponentFileReference ref = IndexComponentFileReference.of(fileRef.getFile().getName());
        ref.fileRef = fileRef;
        ref.fullPath = fileRef.getFile().getAbsolutePath();
        return ref;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexComponentFileReference that = (IndexComponentFileReference)o;
        return Objects.equals(this.fileName, that.fileName);
    }

    public int hashCode() {
        return Objects.hash(this.fileName);
    }

    @Override
    public int compareTo(IndexComponentFileReference o) {
        int startCmp = Long.compare(this.sequenceStart, o.sequenceStart);
        if (startCmp != 0) {
            return startCmp;
        }
        return Long.compare(o.sequenceEnd, this.sequenceEnd);
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getSequenceStart() {
        return this.sequenceStart;
    }

    public long getSequenceEnd() {
        return this.sequenceEnd;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public FileReference getFileRef() {
        return this.fileRef;
    }

    public String getSequence() {
        return this.sequenceStart + "_" + this.sequenceEnd;
    }

    public boolean isMoreRecentThan(IndexComponentFileReference other) {
        return this.sequenceStart > other.getSequenceEnd();
    }

    public boolean isWithin(IndexComponentFileReference other) {
        return this.sequenceStart >= other.getSequenceStart() && this.sequenceEnd <= other.getSequenceEnd();
    }

    public String toString() {
        return "{\"type\" : \"" + (this.isFlush() ? "flush" : "merge") + "\", \"start\" : \"" + this.sequenceStart + "\", \"end\" : \"" + this.sequenceEnd + "\"}";
    }

    private boolean isFlush() {
        return this.sequenceStart == this.sequenceEnd;
    }

    public static String getFlushSequence(long componentSequence) {
        return componentSequence + "_" + componentSequence;
    }

    public static String getMergeSequence(String firstComponentName, String lastComponentName) {
        long mergeSequenceStart = IndexComponentFileReference.of(firstComponentName).getSequenceStart();
        long mergeSequenceEnd = IndexComponentFileReference.of(lastComponentName).getSequenceEnd();
        return mergeSequenceStart + "_" + mergeSequenceEnd;
    }
}

