/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.lsm.common.api.IIoOperationFailedCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationScheduler;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMIOOperationTask;

public class IoOperationExecutor
extends ThreadPoolExecutor {
    private final ILSMIOOperationScheduler scheduler;
    private final IIoOperationFailedCallback callback;
    private final Map<String, ILSMIOOperation> runningFlushOperations;
    private final Map<String, Throwable> failedGroups;

    public IoOperationExecutor(ThreadFactory threadFactory, ILSMIOOperationScheduler scheduler, IIoOperationFailedCallback callback, Map<String, ILSMIOOperation> runningFlushOperations, Map<String, Throwable> failedGroups) {
        super(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory);
        this.scheduler = scheduler;
        this.callback = callback;
        this.runningFlushOperations = runningFlushOperations;
        this.failedGroups = failedGroups;
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return new LSMIOOperationTask<T>(callable);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        LSMIOOperationTask task = (LSMIOOperationTask)r;
        ILSMIOOperation executedOp = task.getOperation();
        try {
            this.doAfterExecute(executedOp, t);
        }
        catch (Throwable th) {
            this.callback.schedulerFailed(this.scheduler, th);
            this.shutdown();
        }
    }

    private void doAfterExecute(ILSMIOOperation executedOp, Throwable t) throws HyracksDataException {
        boolean failed;
        boolean bl = failed = t != null || executedOp.getStatus() == ILSMIOOperation.LSMIOOperationStatus.FAILURE;
        if (failed) {
            this.fail(executedOp, t != null ? t : executedOp.getFailure());
        }
        if (!failed || executedOp.getIOOpertionType() != ILSMIOOperation.LSMIOOperationType.FLUSH) {
            executedOp.complete();
        }
        this.scheduler.completeOperation(executedOp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fail(ILSMIOOperation executedOp, Throwable t) throws HyracksDataException {
        this.callback.operationFailed(executedOp, t);
        if (executedOp.getIOOpertionType() == ILSMIOOperation.LSMIOOperationType.FLUSH) {
            executedOp.complete();
            IoOperationExecutor ioOperationExecutor = this;
            synchronized (ioOperationExecutor) {
                String id = executedOp.getIndexIdentifier();
                this.failedGroups.put(id, t);
                this.runningFlushOperations.remove(id);
            }
        }
    }
}

