/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.common.IIndexBulkLoader;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.buffercache.IPageWriteCallback;
import org.apache.hyracks.storage.common.buffercache.IRateLimiter;

public class LSMIndexPageWriteCallback
implements IPageWriteCallback {
    private final IRateLimiter rateLimiter;
    private final int pagesPerForce;
    private IIndexBulkLoader bulkLoader;
    private long totalWrittenPages;
    private int totalForces;

    public LSMIndexPageWriteCallback(IRateLimiter rateLimiter, int pagesPerForce) {
        this.rateLimiter = rateLimiter;
        this.pagesPerForce = pagesPerForce;
    }

    public void initialize(IIndexBulkLoader bulkLoader) {
        this.bulkLoader = bulkLoader;
    }

    public void beforeWrite(ICachedPage page) throws HyracksDataException {
        this.rateLimiter.request(page.getPageSize() * page.getFrameSizeMultiplier());
    }

    public void afterWrite(ICachedPage page) throws HyracksDataException {
        ++this.totalWrittenPages;
        if (this.pagesPerForce > 0 && this.totalWrittenPages % (long)this.pagesPerForce == 0L) {
            this.bulkLoader.force();
            ++this.totalForces;
        }
    }

    public int getTotalForces() {
        return this.totalForces;
    }
}

