/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class RemoveRedundantGroupByDecorVarsRule
implements IAlgebraicRewriteRule {
    private Set<LogicalVariable> usedVars = new HashSet<LogicalVariable>();

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.DISTRIBUTE_RESULT && op.getOperatorTag() != LogicalOperatorTag.SINK) {
            return false;
        }
        if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op)) {
            return false;
        }
        this.usedVars.clear();
        boolean planTransformed = this.checkAndApplyTheRule(opRef, context);
        return planTransformed;
    }

    protected boolean checkAndApplyTheRule(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        HashSet usedVarsFromThisOp = new HashSet();
        HashSet<LogicalVariable> collectedUsedVarsBeforeThisOpFromRoot = new HashSet<LogicalVariable>();
        boolean redundantVarsRemoved = false;
        boolean uselessVarsRemoved = false;
        if (op.getOperatorTag() == LogicalOperatorTag.GROUP) {
            GroupByOperator groupByOp = (GroupByOperator)op;
            HashSet<LogicalVariable> decorVars = new HashSet<LogicalVariable>();
            Iterator iter = groupByOp.getDecorList().iterator();
            while (iter.hasNext()) {
                Pair decor = (Pair)iter.next();
                if (decor.first != null || ((ILogicalExpression)((Mutable)decor.second).getValue()).getExpressionTag() != LogicalExpressionTag.VARIABLE) continue;
                VariableReferenceExpression varRefExpr = (VariableReferenceExpression)((Mutable)decor.second).getValue();
                LogicalVariable var = varRefExpr.getVariableReference();
                if (decorVars.contains(var)) {
                    iter.remove();
                    redundantVarsRemoved = true;
                    continue;
                }
                decorVars.add(var);
            }
            ArrayList<Pair> newDecorList = new ArrayList<Pair>();
            for (Pair p : groupByOp.getDecorList()) {
                LogicalVariable decorVar = GroupByOperator.getDecorVariable((Pair)p);
                if (!this.usedVars.contains(decorVar)) {
                    uselessVarsRemoved = true;
                    continue;
                }
                newDecorList.add(p);
            }
            if (uselessVarsRemoved) {
                groupByOp.getDecorList().clear();
                groupByOp.getDecorList().addAll(newDecorList);
            }
            if (redundantVarsRemoved || uselessVarsRemoved) {
                context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)groupByOp);
                context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op);
                return redundantVarsRemoved || uselessVarsRemoved;
            }
        }
        VariableUtilities.getUsedVariables((ILogicalOperator)op, usedVarsFromThisOp);
        collectedUsedVarsBeforeThisOpFromRoot.addAll(this.usedVars);
        this.usedVars.addAll(usedVarsFromThisOp);
        for (int i = 0; i < op.getInputs().size(); ++i) {
            boolean groupByChanged = this.checkAndApplyTheRule((Mutable<ILogicalOperator>)((Mutable)op.getInputs().get(i)), context);
            if (!groupByChanged) continue;
            return true;
        }
        this.usedVars.clear();
        this.usedVars.addAll(collectedUsedVarsBeforeThisOpFromRoot);
        return false;
    }
}

