/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.runtime.evaluators;

import java.util.Objects;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.IWarningCollector;

public class EvaluatorContext
implements IEvaluatorContext {
    private final IServiceContext serviceContext;
    private final IHyracksTaskContext taskContext;
    private final IWarningCollector warningCollector;

    public EvaluatorContext(IHyracksTaskContext taskContext) {
        this.taskContext = Objects.requireNonNull(taskContext);
        this.serviceContext = (IServiceContext)Objects.requireNonNull(taskContext.getJobletContext().getServiceContext());
        this.warningCollector = Objects.requireNonNull(taskContext.getWarningCollector());
    }

    public EvaluatorContext(IServiceContext serviceContext, IWarningCollector warningCollector) {
        this.taskContext = null;
        this.serviceContext = Objects.requireNonNull(serviceContext);
        this.warningCollector = Objects.requireNonNull(warningCollector);
    }

    public EvaluatorContext(IHyracksTaskContext taskContext, IWarningCollector warningCollector) {
        this.taskContext = Objects.requireNonNull(taskContext);
        this.serviceContext = (IServiceContext)Objects.requireNonNull(taskContext.getJobletContext().getServiceContext());
        this.warningCollector = Objects.requireNonNull(warningCollector);
    }

    @Override
    public IServiceContext getServiceContext() {
        return this.serviceContext;
    }

    @Override
    public IHyracksTaskContext getTaskContext() {
        return this.taskContext;
    }

    @Override
    public IWarningCollector getWarningCollector() {
        return this.warningCollector;
    }
}

