/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.service.transaction;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.api.IDatasetLifecycleManager;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.context.IndexInfo;
import org.apache.asterix.common.context.PrimaryIndexOperationTracker;
import org.apache.asterix.common.dataflow.LSMIndexUtil;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.storage.IIndexCheckpointManager;
import org.apache.asterix.common.storage.IIndexCheckpointManagerProvider;
import org.apache.asterix.common.storage.IndexCheckpoint;
import org.apache.asterix.common.storage.ResourceReference;
import org.apache.asterix.common.transactions.LogRecord;
import org.apache.asterix.common.transactions.TxnId;
import org.apache.asterix.transaction.management.service.transaction.AtomicTransactionContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentId;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTracker;
import org.apache.hyracks.storage.am.lsm.common.impls.FlushOperation;
import org.apache.hyracks.util.ExitUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AtomicNoWALTransactionContext
extends AtomicTransactionContext {
    private static final Logger LOGGER = LogManager.getLogger();
    private final INcApplicationContext appCtx;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public AtomicNoWALTransactionContext(TxnId txnId, INcApplicationContext appCtx) {
        super(txnId);
        this.appCtx = appCtx;
    }

    @Override
    public void cleanup() {
        super.cleanup();
        int txnState = this.getTxnState();
        switch (txnState) {
            case 2: {
                this.deleteUncommittedRecords();
                break;
            }
            case 1: {
                this.ensureDurable();
                break;
            }
            default: {
                throw new IllegalStateException("invalid state in txn clean up: " + this.getTxnState());
            }
        }
    }

    private void deleteUncommittedRecords() {
        for (ILSMOperationTracker opTrackerRef : this.modifiedIndexes) {
            PrimaryIndexOperationTracker primaryIndexOpTracker = (PrimaryIndexOperationTracker)opTrackerRef;
            try {
                primaryIndexOpTracker.abort();
            }
            catch (HyracksDataException e) {
                throw new ACIDException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureDurable() {
        ArrayList flushes = new ArrayList();
        ArrayList<Integer> datasetIds = new ArrayList<Integer>();
        HashMap<String, ILSMComponentId> resourceMap = new HashMap<String, ILSMComponentId>();
        LogRecord dummyLogRecord = new LogRecord();
        try {
            for (ILSMOperationTracker opTrackerRef : this.modifiedIndexes) {
                PrimaryIndexOperationTracker primaryIndexOpTracker = (PrimaryIndexOperationTracker)opTrackerRef;
                primaryIndexOpTracker.triggerScheduleFlush(dummyLogRecord);
                flushes.addAll(primaryIndexOpTracker.getScheduledFlushes());
                datasetIds.add(primaryIndexOpTracker.getDatasetInfo().getDatasetID());
                for (Map.Entry entry : primaryIndexOpTracker.getLastFlushOperation().entrySet()) {
                    resourceMap.put((String)entry.getKey(), ((FlushOperation)entry.getValue()).getFlushingComponent().getId());
                }
            }
            LSMIndexUtil.waitFor(flushes);
            this.persistLogFile(datasetIds, resourceMap);
        }
        catch (Exception e) {
            this.deleteUncommittedRecords();
            throw new ACIDException((Throwable)e);
        }
        try {
            this.commit();
        }
        catch (HyracksDataException e) {
            try {
                this.rollback(resourceMap);
            }
            catch (Exception ex) {
                LOGGER.error("Error while rolling back atomic statement for {}, halting JVM", (Object)this.txnId);
                ExitUtil.halt((int)24);
            }
        }
        finally {
            this.deleteLogFile();
        }
        this.enableMerge();
    }

    private void persistLogFile(List<Integer> datasetIds, Map<String, ILSMComponentId> resourceMap) throws HyracksDataException, JsonProcessingException {
        IIOManager ioManager = this.appCtx.getPersistenceIoManager();
        FileReference fref = ioManager.resolve(Paths.get("mtd-txn-logs", "partition_-1", String.format("%s.log", this.txnId)).toString());
        ioManager.overwrite(fref, OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this.toJson(datasetIds, resourceMap)).getBytes());
    }

    private ObjectNode toJson(List<Integer> datasetIds, Map<String, ILSMComponentId> resourceMap) {
        ObjectNode jsonNode = OBJECT_MAPPER.createObjectNode();
        jsonNode.put("txnId", this.txnId.getId());
        jsonNode.putPOJO("datasetIds", datasetIds);
        jsonNode.put("nodeId", this.appCtx.getServiceContext().getNodeId());
        jsonNode.putPOJO("resourceMap", resourceMap);
        return jsonNode;
    }

    public void deleteLogFile() {
        IIOManager ioManager = this.appCtx.getPersistenceIoManager();
        try {
            FileReference fref = ioManager.resolve(Paths.get("mtd-txn-logs", "partition_-1", String.format("%s.log", this.txnId)).toString());
            ioManager.delete(fref);
        }
        catch (HyracksDataException e) {
            throw new ACIDException((Throwable)e);
        }
    }

    private void commit() throws HyracksDataException {
        for (ILSMOperationTracker opTrackerRef : this.modifiedIndexes) {
            PrimaryIndexOperationTracker primaryIndexOpTracker = (PrimaryIndexOperationTracker)opTrackerRef;
            primaryIndexOpTracker.commit();
        }
    }

    private void enableMerge() {
        for (ILSMOperationTracker opTrackerRef : this.modifiedIndexes) {
            PrimaryIndexOperationTracker primaryIndexOpTracker = (PrimaryIndexOperationTracker)opTrackerRef;
            for (IndexInfo indexInfo : primaryIndexOpTracker.getDatasetInfo().getIndexes().values()) {
                if (!indexInfo.getIndex().isPrimaryIndex()) continue;
                try {
                    indexInfo.getIndex().getMergePolicy().diskComponentAdded(indexInfo.getIndex(), false);
                }
                catch (HyracksDataException e) {
                    throw new ACIDException((Throwable)e);
                }
            }
        }
    }

    public void rollback(Map<String, ILSMComponentId> resourceMap) {
        this.deleteUncommittedRecords();
        IDatasetLifecycleManager datasetLifecycleManager = this.appCtx.getDatasetLifecycleManager();
        IIndexCheckpointManagerProvider indexCheckpointManagerProvider = datasetLifecycleManager.getIndexCheckpointManagerProvider();
        resourceMap.forEach((k, v) -> {
            try {
                IndexCheckpoint checkpoint;
                IIndexCheckpointManager checkpointManager = indexCheckpointManagerProvider.get(ResourceReference.ofIndex((String)k));
                if (checkpointManager.getCheckpointCount() > 0 && (checkpoint = checkpointManager.getLatest()).getLastComponentId() == v.getMaxId()) {
                    LOGGER.info("Removing checkpoint for resource {} for component id {}", k, (Object)checkpoint.getLastComponentId());
                    checkpointManager.deleteLatest(v.getMaxId(), 1);
                }
            }
            catch (HyracksDataException e) {
                throw new ACIDException((Throwable)e);
            }
        });
    }

    @Override
    public boolean hasWAL() {
        return false;
    }
}

