/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.io;

import java.util.ArrayList;
import java.util.List;
import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.io.TlsContext;
import software.amazon.awssdk.crt.utils.StringUtils;

public class TlsConnectionOptions
extends CrtResource {
    private List<String> alpnList = new ArrayList<String>();
    private String serverName = null;
    private int timeoutMs = 0;
    private TlsContext tlsContext;

    public TlsConnectionOptions(TlsContext tlsContext) {
        this.tlsContext = tlsContext;
    }

    @Override
    public long getNativeHandle() {
        if (super.getNativeHandle() == 0L) {
            this.acquireNativeHandle(TlsConnectionOptions.tlsConnectionOptionsNew(this.alpnList.size() > 0 ? StringUtils.join(";", this.alpnList) : null, this.serverName, this.timeoutMs, this.tlsContext.getNativeHandle()));
        }
        return super.getNativeHandle();
    }

    public TlsConnectionOptions withAlpnList(String alpnList) {
        String[] parts;
        for (String part : parts = alpnList.split(";")) {
            this.alpnList.add(part);
        }
        return this;
    }

    public TlsConnectionOptions withServerName(String serverName) {
        this.serverName = serverName;
        return this;
    }

    public TlsConnectionOptions withTimeoutMs(int timeoutMs) {
        this.timeoutMs = timeoutMs;
        return this;
    }

    @Override
    protected boolean canReleaseReferencesImmediately() {
        return true;
    }

    @Override
    protected void releaseNativeHandle() {
        if (!this.isNull()) {
            TlsConnectionOptions.tlsConnectionOptionsDestroy(this.getNativeHandle());
        }
    }

    private static native long tlsConnectionOptionsNew(String var0, String var1, int var2, long var3);

    private static native void tlsConnectionOptionsDestroy(long var0);
}

