/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.azure.datalake;

import com.azure.storage.blob.models.BlobErrorCode;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.file.datalake.DataLakeFileClient;
import com.azure.storage.file.datalake.DataLakeFileSystemClient;
import com.azure.storage.file.datalake.DataLakeServiceClient;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.asterix.common.api.IApplicationContext;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.external.input.filter.embedder.IExternalFilterValueEmbedder;
import org.apache.asterix.external.input.record.reader.abstracts.AbstractExternalInputStream;
import org.apache.asterix.external.util.ExternalDataConstants;
import org.apache.asterix.external.util.azure.blob_storage.AzureUtils;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.util.ExceptionUtils;
import org.apache.hyracks.util.LogRedactionUtil;

public class AzureDataLakeInputStream
extends AbstractExternalInputStream {
    private final DataLakeServiceClient client;
    private final String container;

    public AzureDataLakeInputStream(IApplicationContext appCtx, Map<String, String> configuration, List<String> filePaths, IExternalFilterValueEmbedder valueEmbedder) throws HyracksDataException {
        super(configuration, filePaths, valueEmbedder);
        this.client = this.buildAzureClient(appCtx, configuration);
        this.container = configuration.get("container");
    }

    @Override
    protected boolean getInputStream() throws IOException {
        String fileName = (String)this.filePaths.get(this.nextFileIndex);
        try {
            DataLakeFileSystemClient fileSystemClient = this.client.getFileSystemClient(this.container);
            DataLakeFileClient fileClient = fileSystemClient.getFileClient((String)this.filePaths.get(this.nextFileIndex));
            this.in = fileClient.openInputStream().getInputStream();
            String lowerCaseFileName = fileName.toLowerCase();
            if (lowerCaseFileName.endsWith(".gz") || lowerCaseFileName.endsWith(".gzip")) {
                this.in = new GZIPInputStream(this.in, ExternalDataConstants.DEFAULT_BUFFER_SIZE);
            }
        }
        catch (BlobStorageException ex) {
            if (ex.getErrorCode().equals((Object)BlobErrorCode.BLOB_NOT_FOUND)) {
                LOGGER.debug(() -> "Key " + LogRedactionUtil.userData((String)((String)this.filePaths.get(this.nextFileIndex))) + " was not found in container " + this.container);
                return false;
            }
            throw new RuntimeDataException(ErrorCode.EXTERNAL_SOURCE_ERROR, (Throwable)ex, new Serializable[]{ExceptionUtils.getMessageOrToString((Throwable)ex)});
        }
        catch (Exception ex) {
            throw new RuntimeDataException(ErrorCode.EXTERNAL_SOURCE_ERROR, (Throwable)ex, new Serializable[]{ExceptionUtils.getMessageOrToString((Throwable)ex)});
        }
        return true;
    }

    private DataLakeServiceClient buildAzureClient(IApplicationContext appCtx, Map<String, String> configuration) throws HyracksDataException {
        try {
            return AzureUtils.buildAzureDatalakeClient(appCtx, configuration);
        }
        catch (CompilationException ex) {
            throw HyracksDataException.create((Throwable)ex);
        }
    }
}

