/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.hdfs.parquet;

import java.io.Serializable;
import java.util.Map;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.AsterixParquetRuntimeException;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.ParquetConverterContext;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.primitve.PrimitiveConverterProvider;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.IATypeVisitor;
import org.apache.asterix.om.utils.ProjectionFiltrationTypeUtil;
import org.apache.asterix.runtime.projection.FunctionCallInformation;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IError;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.exceptions.Warning;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;

public class AsterixTypeToParquetTypeVisitor
implements IATypeVisitor<Type, Type> {
    public static final MessageType EMPTY_PARQUET_MESSAGE = Types.buildMessage().named("EMPTY");
    private final ParquetConverterContext context;
    private Map<String, FunctionCallInformation> funcInfo;

    public AsterixTypeToParquetTypeVisitor(ParquetConverterContext context) {
        this.context = context;
    }

    public MessageType clipType(ARecordType rootType, MessageType fileSchema, Map<String, FunctionCallInformation> funcInfo) {
        if (rootType == ProjectionFiltrationTypeUtil.EMPTY_TYPE) {
            return EMPTY_PARQUET_MESSAGE;
        }
        if (rootType == ProjectionFiltrationTypeUtil.ALL_FIELDS_TYPE) {
            return fileSchema;
        }
        Types.MessageTypeBuilder builder = Types.buildMessage();
        this.funcInfo = funcInfo;
        this.clipObjectChildren((Types.GroupBuilder<?>)builder, rootType, (Type)fileSchema);
        return builder.named(fileSchema.getName());
    }

    public Type visit(ARecordType recordType, Type arg) {
        if (this.isNotCompatibleType(arg, (IAType)recordType)) {
            return PrimitiveConverterProvider.MISSING;
        }
        Types.GroupBuilder builder = Types.buildGroup((Type.Repetition)arg.getRepetition());
        if (this.clipObjectChildren(builder, recordType, arg) == 0) {
            builder.addField((Type)PrimitiveConverterProvider.MISSING);
        }
        return (Type)builder.named(arg.getName());
    }

    public Type visit(AbstractCollectionType collectionType, Type arg) {
        if (this.isNotCompatibleType(arg, (IAType)collectionType)) {
            return PrimitiveConverterProvider.MISSING;
        }
        GroupType arrayType = arg.asGroupType();
        Type childType = arrayType.getType(0);
        if ("array".equals(childType.getName()) || childType.asGroupType().getFieldCount() > 1) {
            return this.handleAvroArray(collectionType, arrayType);
        }
        Types.ListBuilder builder = Types.list((Type.Repetition)arg.getRepetition());
        childType = childType.asGroupType().getType(0);
        Type requestedChildType = (Type)collectionType.getItemType().accept((IATypeVisitor)this, (Object)childType);
        builder.setElementType(requestedChildType);
        return (Type)builder.named(arg.getName());
    }

    private int clipObjectChildren(Types.GroupBuilder<?> builder, ARecordType recordType, Type arg) {
        GroupType groupType = arg.asGroupType();
        String[] fieldNames = recordType.getFieldNames();
        IAType[] fieldTypes = recordType.getFieldTypes();
        int numberOfAddedFields = 0;
        for (int i = 0; i < fieldNames.length; ++i) {
            Type type = AsterixTypeToParquetTypeVisitor.getType(groupType, fieldNames[i]);
            Type childType = (Type)fieldTypes[i].accept((IATypeVisitor)this, (Object)type);
            if (childType == PrimitiveConverterProvider.MISSING) continue;
            builder.addField(childType);
            ++numberOfAddedFields;
        }
        return numberOfAddedFields;
    }

    private Type handleAvroArray(AbstractCollectionType collectionType, GroupType groupType) {
        Types.GroupBuilder builder = (Types.GroupBuilder)Types.buildGroup((Type.Repetition)groupType.getRepetition()).as(groupType.getLogicalTypeAnnotation());
        Type type = groupType.getType(0);
        Type childType = (Type)collectionType.getItemType().accept((IATypeVisitor)this, (Object)type);
        builder.addField(childType);
        return (Type)builder.named(groupType.getName());
    }

    public Type visit(AUnionType unionType, Type arg) {
        if (arg.getLogicalTypeAnnotation() == LogicalTypeAnnotation.listType()) {
            return (Type)unionType.getType(ATypeTag.ARRAY).accept((IATypeVisitor)this, (Object)arg);
        }
        return (Type)unionType.getType(ATypeTag.OBJECT).accept((IATypeVisitor)this, (Object)arg);
    }

    public Type visitFlat(IAType node, Type arg) {
        return arg;
    }

    private boolean isNotCompatibleType(Type type, IAType node) {
        ATypeTag expectedType;
        boolean isNotExpected;
        if (type == PrimitiveConverterProvider.MISSING) {
            return true;
        }
        FunctionCallInformation info = this.funcInfo.get(node.getTypeName());
        ATypeTag actualType = AsterixTypeToParquetTypeVisitor.mapType(type, this.context, info.getSourceLocation());
        boolean bl = isNotExpected = actualType != (expectedType = node.getTypeTag());
        if (isNotExpected) {
            Warning warning = null;
            if (actualType != ATypeTag.SYSTEM_NULL) {
                warning = info.createWarning(expectedType, actualType);
            }
            if (warning != null) {
                this.context.getWarnings().add(warning);
            }
        }
        return isNotExpected;
    }

    public static ATypeTag mapType(Type parquetType, ParquetConverterContext context, SourceLocation sourceLocation) {
        LogicalTypeAnnotation typeAnnotation = parquetType.getLogicalTypeAnnotation();
        if (!parquetType.isPrimitive()) {
            if (typeAnnotation == null) {
                return ATypeTag.OBJECT;
            }
            if (typeAnnotation == LogicalTypeAnnotation.listType() || typeAnnotation == LogicalTypeAnnotation.mapType()) {
                return ATypeTag.ARRAY;
            }
        } else {
            PrimitiveType primitiveType = parquetType.asPrimitiveType();
            switch (primitiveType.getPrimitiveTypeName()) {
                case BOOLEAN: {
                    return ATypeTag.BOOLEAN;
                }
                case FLOAT: 
                case DOUBLE: {
                    return ATypeTag.DOUBLE;
                }
                case INT32: 
                case INT64: {
                    return AsterixTypeToParquetTypeVisitor.handleInt32Int64(primitiveType, context, sourceLocation);
                }
                case INT96: {
                    return ATypeTag.DATETIME;
                }
                case BINARY: 
                case FIXED_LEN_BYTE_ARRAY: {
                    return AsterixTypeToParquetTypeVisitor.handleBinary(primitiveType, context, sourceLocation);
                }
            }
        }
        AsterixTypeToParquetTypeVisitor.warnUnsupportedType(context, sourceLocation, parquetType);
        return ATypeTag.SYSTEM_NULL;
    }

    private static Type getType(GroupType groupType, String fieldName) {
        if (groupType.containsField(fieldName)) {
            return groupType.getType(fieldName);
        }
        return PrimitiveConverterProvider.MISSING;
    }

    private static ATypeTag handleInt32Int64(PrimitiveType type, ParquetConverterContext context, SourceLocation sourceLocation) {
        LogicalTypeAnnotation logicalType = type.getLogicalTypeAnnotation();
        ATypeTag inferredTypeTag = ATypeTag.SYSTEM_NULL;
        if (logicalType == null || logicalType instanceof LogicalTypeAnnotation.IntLogicalTypeAnnotation) {
            inferredTypeTag = ATypeTag.BIGINT;
        } else if (logicalType instanceof LogicalTypeAnnotation.DateLogicalTypeAnnotation) {
            inferredTypeTag = ATypeTag.DATE;
        } else if (logicalType instanceof LogicalTypeAnnotation.TimeLogicalTypeAnnotation) {
            inferredTypeTag = ATypeTag.TIME;
        } else if (logicalType instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation && AsterixTypeToParquetTypeVisitor.checkDatetime(type, context, sourceLocation)) {
            LogicalTypeAnnotation.TimestampLogicalTypeAnnotation tsType = (LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)logicalType;
            AsterixTypeToParquetTypeVisitor.warnIfUTCAdjustedAndZoneIdIsNotSet(context, sourceLocation, tsType.isAdjustedToUTC());
            inferredTypeTag = ATypeTag.DATETIME;
        } else if (logicalType instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
            AsterixTypeToParquetTypeVisitor.ensureDecimalToDoubleEnabled(type, context, sourceLocation);
            inferredTypeTag = ATypeTag.DOUBLE;
        }
        return inferredTypeTag;
    }

    private static ATypeTag handleBinary(PrimitiveType type, ParquetConverterContext context, SourceLocation sourceLocation) {
        LogicalTypeAnnotation logicalType = type.getLogicalTypeAnnotation();
        ATypeTag inferredTypeTag = ATypeTag.SYSTEM_NULL;
        if (logicalType == null || logicalType == LogicalTypeAnnotation.bsonType()) {
            inferredTypeTag = ATypeTag.BINARY;
        } else if (logicalType == LogicalTypeAnnotation.stringType() || logicalType == LogicalTypeAnnotation.enumType()) {
            inferredTypeTag = ATypeTag.STRING;
        } else if (logicalType == LogicalTypeAnnotation.jsonType()) {
            inferredTypeTag = context.isParseJsonEnabled() ? ATypeTag.ANY : ATypeTag.STRING;
        } else if (logicalType instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
            AsterixTypeToParquetTypeVisitor.ensureDecimalToDoubleEnabled(type, context, sourceLocation);
            inferredTypeTag = ATypeTag.DOUBLE;
        } else if (logicalType instanceof LogicalTypeAnnotation.UUIDLogicalTypeAnnotation) {
            inferredTypeTag = ATypeTag.UUID;
        }
        return inferredTypeTag;
    }

    private static boolean checkDatetime(PrimitiveType type, ParquetConverterContext context, SourceLocation sourceLocation) {
        if (type.getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT32) {
            AsterixTypeToParquetTypeVisitor.warnUnsupportedType(context, sourceLocation, (Type)type);
            return false;
        }
        return true;
    }

    private static void ensureDecimalToDoubleEnabled(PrimitiveType type, ParquetConverterContext context, SourceLocation sourceLocation) {
        if (!context.isDecimalToDoubleEnabled()) {
            throw new AsterixParquetRuntimeException((HyracksDataException)new RuntimeDataException(ErrorCode.PARQUET_SUPPORTED_TYPE_WITH_OPTION, sourceLocation, new Serializable[]{type.toString(), "decimal-to-double"}));
        }
        LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalLogicalType = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)type.getLogicalTypeAnnotation();
        int precision = decimalLogicalType.getPrecision();
        if (precision > 20) {
            context.getWarnings().add(Warning.of(null, (IError)ErrorCode.PARQUET_DECIMAL_TO_DOUBLE_PRECISION_LOSS, (Serializable[])new Serializable[]{Integer.valueOf(precision), Integer.valueOf(20)}));
        }
    }

    public static void warnUnsupportedType(ParquetConverterContext context, SourceLocation sourceLocation, Type parquetType) {
        context.getWarnings().add(Warning.of((SourceLocation)sourceLocation, (IError)ErrorCode.UNSUPPORTED_PARQUET_TYPE, (Serializable[])new Serializable[]{parquetType.toString()}));
    }

    private static void warnIfUTCAdjustedAndZoneIdIsNotSet(ParquetConverterContext context, SourceLocation sourceLocation, boolean adjustedToUTC) {
        if (adjustedToUTC && context.getTimeZoneId().isEmpty()) {
            Warning warning = Warning.of((SourceLocation)sourceLocation, (IError)ErrorCode.PARQUET_TIME_ZONE_ID_IS_NOT_SET, (Serializable[])new Serializable[]{ATypeTag.DATETIME, "timezone"});
            context.getWarnings().add(warning);
        }
    }
}

