/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.rss;

import com.rometools.fetcher.FeedFetcher;
import com.rometools.fetcher.FetcherException;
import com.rometools.fetcher.FetcherListener;
import com.rometools.fetcher.impl.FeedFetcherCache;
import com.rometools.fetcher.impl.HashMapFeedInfoCache;
import com.rometools.fetcher.impl.HttpURLFeedFetcher;
import com.rometools.rome.feed.synd.SyndEntry;
import com.rometools.rome.feed.synd.SyndFeed;
import com.rometools.rome.io.FeedException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.apache.asterix.external.api.IRawRecord;
import org.apache.asterix.external.api.IRecordReader;
import org.apache.asterix.external.dataflow.AbstractFeedDataFlowController;
import org.apache.asterix.external.input.record.GenericRecord;
import org.apache.asterix.external.input.record.reader.rss.FetcherEventListenerImpl;
import org.apache.asterix.external.util.IFeedLogManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RSSRecordReader
implements IRecordReader<SyndEntry> {
    private static final Logger LOGGER = LogManager.getLogger();
    private boolean modified = false;
    private Queue<SyndEntry> rssFeedBuffer = new LinkedList<SyndEntry>();
    private FeedFetcherCache feedInfoCache;
    private FeedFetcher fetcher;
    private FetcherEventListenerImpl listener;
    private URL feedUrl;
    private GenericRecord<SyndEntry> record = new GenericRecord();
    private boolean done = false;

    public RSSRecordReader(String url) throws MalformedURLException {
        this.feedUrl = new URL(url);
        this.feedInfoCache = HashMapFeedInfoCache.getInstance();
        this.fetcher = new HttpURLFeedFetcher(this.feedInfoCache);
        this.listener = new FetcherEventListenerImpl(this, LOGGER);
        this.fetcher.addFetcherEventListener((FetcherListener)this.listener);
    }

    public boolean isModified() {
        return this.modified;
    }

    @Override
    public void close() throws IOException {
        this.fetcher.removeFetcherEventListener((FetcherListener)this.listener);
    }

    @Override
    public boolean hasNext() throws Exception {
        return !this.done;
    }

    @Override
    public IRawRecord<SyndEntry> next() throws IOException {
        if (this.done) {
            return null;
        }
        try {
            SyndEntry feedEntry = this.getNextRSSFeed();
            if (feedEntry == null) {
                return null;
            }
            this.record.set(feedEntry);
            return this.record;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean stop() {
        this.done = true;
        return true;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    private SyndEntry getNextRSSFeed() throws IOException, FeedException, FetcherException {
        if (this.rssFeedBuffer.isEmpty()) {
            this.fetchFeed();
        }
        if (this.rssFeedBuffer.isEmpty()) {
            return null;
        }
        return this.rssFeedBuffer.remove();
    }

    private void fetchFeed() throws IOException, FeedException, FetcherException {
        SyndFeed feed = this.fetcher.retrieveFeed(this.feedUrl);
        if (this.modified) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(this.feedUrl + " retrieved");
                LOGGER.info(this.feedUrl + " has a title: " + feed.getTitle() + " and contains " + feed.getEntries().size() + " entries.");
            }
            List fetchedFeeds = feed.getEntries();
            this.rssFeedBuffer.addAll(fetchedFeeds);
        }
    }

    @Override
    public void setFeedLogManager(IFeedLogManager feedLogManager) {
    }

    @Override
    public void setController(AbstractFeedDataFlowController controller) {
    }

    @Override
    public boolean handleException(Throwable th) {
        return false;
    }
}

