/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.stream;

import java.io.IOException;
import java.util.Map;
import org.apache.asterix.external.api.AsterixInputStream;
import org.apache.asterix.external.api.IRawRecord;
import org.apache.asterix.external.api.IStreamNotificationHandler;
import org.apache.asterix.external.dataflow.AbstractFeedDataFlowController;
import org.apache.asterix.external.input.record.CharArrayRecord;
import org.apache.asterix.external.input.record.reader.stream.AbstractStreamRecordReader;
import org.apache.asterix.external.input.stream.AsterixInputStreamReader;
import org.apache.asterix.external.util.ExternalDataUtils;
import org.apache.asterix.external.util.IFeedLogManager;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public abstract class StreamRecordReader
extends AbstractStreamRecordReader<char[]>
implements IStreamNotificationHandler {
    protected AsterixInputStreamReader reader;
    protected CharArrayRecord record;
    protected char[] inputBuffer;
    protected int bufferLength = 0;
    protected int bufferPosn = 0;
    protected boolean done = false;
    protected IFeedLogManager feedLogManager;

    protected void configure(AsterixInputStream inputStream, Map<String, String> config) {
        int bufferSize = ExternalDataUtils.getOrDefaultBufferSize(config);
        this.reader = new AsterixInputStreamReader(inputStream, bufferSize);
        this.record = new CharArrayRecord();
        this.inputBuffer = new char[bufferSize];
        this.setSuppliers(config, this.reader::getStreamName, this.reader::getPreviousStreamName);
    }

    @Override
    public IRawRecord<char[]> next() throws IOException {
        return this.record;
    }

    @Override
    public void close() throws IOException {
        try {
            if (!this.done) {
                this.reader.close();
            }
        }
        finally {
            this.done = true;
        }
    }

    @Override
    public boolean stop() {
        try {
            this.reader.stop();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void setFeedLogManager(IFeedLogManager feedLogManager) throws HyracksDataException {
        this.feedLogManager = feedLogManager;
        this.reader.setFeedLogManager(feedLogManager);
    }

    @Override
    public void setController(AbstractFeedDataFlowController controller) {
        this.reader.setController(controller);
    }

    @Override
    public boolean handleException(Throwable th) {
        return this.reader.handleException(th);
    }

    @Override
    public void notifyNewSource() {
        throw new UnsupportedOperationException();
    }

    protected void resetForNewSource() {
        this.record.reset();
    }

    public abstract String getRequiredConfigs();
}

