/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.statement;

import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.metadata.Namespace;
import org.apache.asterix.lang.common.base.AbstractStatement;
import org.apache.asterix.lang.common.base.Statement;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.metadata.feeds.BuiltinFeedPolicies;
import org.apache.hyracks.algebricks.common.utils.Pair;

public class ConnectFeedStatement
extends AbstractStatement {
    private final Namespace namespace;
    private final Identifier datasetName;
    private final String feedName;
    private final String policy;
    private final String whereClauseBody;
    private final int varCounter;
    private final List<FunctionSignature> appliedFunctions;

    public ConnectFeedStatement(Pair<Namespace, Identifier> feedNameCmp, Pair<Namespace, Identifier> datasetNameCmp, List<FunctionSignature> appliedFunctions, String policy, String whereClauseBody, int varCounter) {
        if (feedNameCmp.first != null && datasetNameCmp.first != null && !((Namespace)feedNameCmp.first).equals(datasetNameCmp.first)) {
            throw new IllegalArgumentException("Dataverse for source feed and target dataset do not match");
        }
        this.namespace = feedNameCmp.first != null ? (Namespace)feedNameCmp.first : (Namespace)datasetNameCmp.first;
        this.datasetName = (Identifier)datasetNameCmp.second;
        this.feedName = ((Identifier)feedNameCmp.second).getValue();
        this.policy = policy != null ? policy : BuiltinFeedPolicies.DEFAULT_POLICY.getPolicyName();
        this.whereClauseBody = whereClauseBody;
        this.varCounter = varCounter;
        this.appliedFunctions = appliedFunctions;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public DataverseName getDataverseName() {
        return this.namespace == null ? null : this.namespace.getDataverseName();
    }

    public Identifier getDatasetName() {
        return this.datasetName;
    }

    public int getVarCounter() {
        return this.varCounter;
    }

    public String getWhereClauseBody() {
        return this.whereClauseBody;
    }

    @Override
    public Statement.Kind getKind() {
        return Statement.Kind.CONNECT_FEED;
    }

    public String getPolicy() {
        return this.policy;
    }

    @Override
    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return visitor.visit(this, arg);
    }

    public String getFeedName() {
        return this.feedName;
    }

    public List<FunctionSignature> getAppliedFunctions() {
        return this.appliedFunctions;
    }

    @Override
    public byte getCategory() {
        return 2;
    }
}

