/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.cbo;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.annotations.IndexedNLJoinExpressionAnnotation;
import org.apache.asterix.common.annotations.SecondaryIndexSearchPreferenceAnnotation;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.metadata.declared.DataSource;
import org.apache.asterix.metadata.declared.DataSourceId;
import org.apache.asterix.metadata.declared.DatasetDataSource;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.declared.SampleDataSource;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.om.base.AOrderedList;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.optimizer.cost.Cost;
import org.apache.asterix.optimizer.cost.CostMethods;
import org.apache.asterix.optimizer.cost.ICost;
import org.apache.asterix.optimizer.cost.ICostMethods;
import org.apache.asterix.optimizer.rules.cbo.EnumerateJoinsRule;
import org.apache.asterix.optimizer.rules.cbo.JoinCondition;
import org.apache.asterix.optimizer.rules.cbo.JoinNode;
import org.apache.asterix.optimizer.rules.cbo.JoinOperator;
import org.apache.asterix.optimizer.rules.cbo.PlanNode;
import org.apache.asterix.optimizer.rules.cbo.Stats;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Quadruple;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.BroadcastExpressionAnnotation;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.HashJoinExpressionAnnotation;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionAnnotation;
import org.apache.hyracks.algebricks.core.algebra.expressions.PredicateCardinalityAnnotation;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.UnnestingFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LimitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.prettyprint.IPlanPrettyPrinter;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorManipulationUtil;
import org.apache.hyracks.algebricks.core.rewriter.base.PhysicalOptimizationConfig;
import org.apache.hyracks.api.exceptions.Warning;
import org.apache.hyracks.control.common.config.OptionTypes;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JoinEnum {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String CBO_FULL_ENUM_LEVEL_KEY = "cbofullenumlevel";
    private static final int CBO_FULL_ENUM_LEVEL_DEFAULT = 0;
    public static final String CBO_CP_ENUM_KEY = "cbocpenum";
    private static final boolean CBO_CP_ENUM_DEFAULT = true;
    protected List<JoinCondition> joinConditions;
    protected Map<IExpressionAnnotation, Warning> joinHints;
    protected List<PlanNode> allPlans;
    protected JoinNode[] jnArray;
    protected int jnArraySize;
    protected List<ILogicalOperator> leafInputs;
    protected HashMap<DataSourceScanOperator, ILogicalOperator> dataScanAndGroupByDistinctOps;
    protected ILogicalOperator rootGroupByDistinctOp;
    protected ILogicalOperator rootOrderByOp;
    protected List<ILogicalExpression> singleDatasetPreds;
    protected List<AssignOperator> assignOps;
    List<Quadruple<Integer, Integer, JoinOperator, Integer>> outerJoinsDependencyList;
    HashMap<LogicalVariable, Integer> varLeafInputIds;
    protected List<JoinOperator> allJoinOps;
    protected ILogicalOperator localJoinOp;
    protected IOptimizationContext optCtx;
    protected boolean outerJoin;
    protected List<Triple<Integer, Integer, Boolean>> buildSets;
    protected int allTabsJnNum;
    protected int maxBits;
    protected Stats stats;
    private boolean cboMode;
    private boolean cboTestMode;
    protected int cboFullEnumLevel;
    protected boolean cboCPEnumMode;
    protected int numberOfTerms;
    private AbstractLogicalOperator op;
    protected boolean connectedJoinGraph;
    protected boolean forceJoinOrderMode;
    protected String queryPlanShape;
    protected ICost cost;
    protected ICostMethods costMethods;
    List<LogicalVariable> resultAndJoinVars;

    protected void initEnum(AbstractLogicalOperator op, boolean cboMode, boolean cboTestMode, int numberOfFromTerms, List<ILogicalOperator> leafInputs, List<JoinOperator> allJoinOps, List<AssignOperator> assignOps, List<Quadruple<Integer, Integer, JoinOperator, Integer>> outerJoinsDependencyList, List<Triple<Integer, Integer, Boolean>> buildSets, HashMap<LogicalVariable, Integer> varLeafInputIds, HashMap<DataSourceScanOperator, ILogicalOperator> dataScanAndGroupByDistinctOps, ILogicalOperator grpByDistinctOp, ILogicalOperator orderByOp, List<LogicalVariable> resultAndJoinVars, IOptimizationContext context) throws AsterixException {
        this.singleDatasetPreds = new ArrayList<ILogicalExpression>();
        this.joinConditions = new ArrayList<JoinCondition>();
        this.joinHints = new HashMap<IExpressionAnnotation, Warning>();
        this.allPlans = new ArrayList<PlanNode>();
        this.numberOfTerms = numberOfFromTerms;
        this.cboMode = cboMode;
        this.cboTestMode = cboTestMode;
        this.cboFullEnumLevel = this.getCBOFullEnumLevel(context);
        this.cboCPEnumMode = this.getCBOCPEnumMode(context);
        this.connectedJoinGraph = true;
        this.optCtx = context;
        this.leafInputs = leafInputs;
        this.assignOps = assignOps;
        this.outerJoin = false;
        this.outerJoinsDependencyList = outerJoinsDependencyList;
        this.allJoinOps = allJoinOps;
        this.buildSets = buildSets;
        this.varLeafInputIds = varLeafInputIds;
        this.dataScanAndGroupByDistinctOps = dataScanAndGroupByDistinctOps;
        this.rootGroupByDistinctOp = grpByDistinctOp;
        this.rootOrderByOp = orderByOp;
        this.resultAndJoinVars = resultAndJoinVars;
        this.op = op;
        this.forceJoinOrderMode = JoinEnum.getForceJoinOrderMode(context);
        this.queryPlanShape = JoinEnum.getQueryPlanShape(context);
        this.initCostHandleAndJoinNodes(context);
        this.allTabsJnNum = 1;
        this.maxBits = 1;
    }

    protected void initCostHandleAndJoinNodes(IOptimizationContext context) {
        this.cost = new Cost();
        this.costMethods = new CostMethods(context);
        this.stats = new Stats(this.optCtx, this);
        this.jnArraySize = (int)Math.pow(2.0, this.numberOfTerms);
        this.jnArray = new JoinNode[this.jnArraySize];
        for (int i = 0; i < this.jnArraySize; ++i) {
            this.jnArray[i] = new JoinNode(i, this);
        }
    }

    private int getCBOFullEnumLevel(IOptimizationContext context) throws AsterixException {
        MetadataProvider mdp = (MetadataProvider)context.getMetadataProvider();
        String valueInQuery = (String)mdp.getProperty(CBO_FULL_ENUM_LEVEL_KEY);
        try {
            return valueInQuery == null ? 0 : (Integer)OptionTypes.POSITIVE_INTEGER.parse(valueInQuery);
        }
        catch (IllegalArgumentException e) {
            throw AsterixException.create((ErrorCode)ErrorCode.COMPILATION_BAD_QUERY_PARAMETER_VALUE, (Serializable[])new Serializable[]{CBO_FULL_ENUM_LEVEL_KEY, Integer.valueOf(1), ""});
        }
    }

    private boolean getCBOCPEnumMode(IOptimizationContext context) {
        MetadataProvider mdp = (MetadataProvider)context.getMetadataProvider();
        return mdp.getBooleanProperty(CBO_CP_ENUM_KEY, true);
    }

    protected List<JoinCondition> getJoinConditions() {
        return this.joinConditions;
    }

    public List<PlanNode> getAllPlans() {
        return this.allPlans;
    }

    protected JoinNode[] getJnArray() {
        return this.jnArray;
    }

    protected Cost getCostHandle() {
        return (Cost)this.cost;
    }

    protected CostMethods getCostMethodsHandle() {
        return (CostMethods)this.costMethods;
    }

    protected Stats getStatsHandle() {
        return this.stats;
    }

    protected ILogicalOperator findLeafInput(List<LogicalVariable> logicalVars) throws AlgebricksException {
        HashSet vars = new HashSet();
        for (ILogicalOperator op : this.leafInputs) {
            vars.clear();
            VariableUtilities.getLiveVariables((ILogicalOperator)op, vars);
            if (!vars.containsAll(logicalVars)) continue;
            return op;
        }
        return null;
    }

    protected ILogicalExpression combineAllConditions(List<Integer> newJoinConditions) {
        if (newJoinConditions.size() == 0) {
            return ConstantExpression.TRUE;
        }
        if (newJoinConditions.size() == 1) {
            JoinCondition jc = this.joinConditions.get(newJoinConditions.get(0));
            return jc.joinCondition;
        }
        ScalarFunctionCallExpression andExpr = new ScalarFunctionCallExpression((IFunctionInfo)BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)AlgebricksBuiltinFunctions.AND));
        for (int joinNum : newJoinConditions) {
            JoinCondition jc = this.joinConditions.get(joinNum);
            andExpr.getArguments().add(new MutableObject((Object)jc.joinCondition));
        }
        return andExpr;
    }

    protected ILogicalExpression getNestedLoopJoinExpr(List<Integer> newJoinConditions) {
        if (newJoinConditions.size() != 1) {
            return null;
        }
        JoinCondition jc = this.joinConditions.get(newJoinConditions.get(0));
        return jc.joinCondition;
    }

    protected ILogicalExpression getHashJoinExpr(List<Integer> newJoinConditions) {
        if (newJoinConditions.size() == 0) {
            return ConstantExpression.TRUE;
        }
        if (newJoinConditions.size() == 1) {
            JoinCondition jc = this.joinConditions.get(newJoinConditions.get(0));
            if (jc.comparisonType == JoinCondition.comparisonOp.OP_EQ) {
                return jc.joinCondition;
            }
            return null;
        }
        ScalarFunctionCallExpression andExpr = new ScalarFunctionCallExpression((IFunctionInfo)BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)AlgebricksBuiltinFunctions.AND));
        boolean eqPredFound = false;
        for (int joinNum : newJoinConditions) {
            JoinCondition jc = this.joinConditions.get(joinNum);
            if (jc.comparisonType == JoinCondition.comparisonOp.OP_EQ) {
                eqPredFound = true;
            }
            andExpr.getArguments().add(new MutableObject((Object)jc.joinCondition));
        }
        return eqPredFound ? andExpr : null;
    }

    protected boolean lookForOuterJoins(List<Integer> newJoinConditions) {
        for (int joinNum : newJoinConditions) {
            JoinCondition jc = this.joinConditions.get(joinNum);
            if (!jc.outerJoin) continue;
            return true;
        }
        return false;
    }

    protected HashJoinExpressionAnnotation findHashJoinHint(List<Integer> newJoinConditions) {
        for (int i : newJoinConditions) {
            AbstractFunctionCallExpression AFCexpr;
            HashJoinExpressionAnnotation hjea;
            JoinCondition jc = this.joinConditions.get(i);
            if (jc.comparisonType != JoinCondition.comparisonOp.OP_EQ) {
                return null;
            }
            ILogicalExpression expr = jc.joinCondition;
            if (!expr.getExpressionTag().equals((Object)LogicalExpressionTag.FUNCTION_CALL) || (hjea = (HashJoinExpressionAnnotation)(AFCexpr = (AbstractFunctionCallExpression)expr).getAnnotation(HashJoinExpressionAnnotation.class)) == null) continue;
            return hjea;
        }
        return null;
    }

    protected BroadcastExpressionAnnotation findBroadcastHashJoinHint(List<Integer> newJoinConditions) {
        for (int i : newJoinConditions) {
            AbstractFunctionCallExpression AFCexpr;
            BroadcastExpressionAnnotation bcasthjea;
            JoinCondition jc = this.joinConditions.get(i);
            if (jc.comparisonType != JoinCondition.comparisonOp.OP_EQ) {
                return null;
            }
            ILogicalExpression expr = jc.joinCondition;
            if (!expr.getExpressionTag().equals((Object)LogicalExpressionTag.FUNCTION_CALL) || (bcasthjea = (BroadcastExpressionAnnotation)(AFCexpr = (AbstractFunctionCallExpression)expr).getAnnotation(BroadcastExpressionAnnotation.class)) == null) continue;
            return bcasthjea;
        }
        return null;
    }

    protected IndexedNLJoinExpressionAnnotation findNLJoinHint(List<Integer> newJoinConditions) {
        for (int i : newJoinConditions) {
            AbstractFunctionCallExpression AFCexpr;
            IndexedNLJoinExpressionAnnotation inljea;
            JoinCondition jc = this.joinConditions.get(i);
            ILogicalExpression expr = jc.joinCondition;
            if (!expr.getExpressionTag().equals((Object)LogicalExpressionTag.FUNCTION_CALL) || (inljea = (IndexedNLJoinExpressionAnnotation)(AFCexpr = (AbstractFunctionCallExpression)expr).getAnnotation(IndexedNLJoinExpressionAnnotation.class)) == null) continue;
            return inljea;
        }
        return null;
    }

    public boolean findUseIndexHint(AbstractFunctionCallExpression condition) {
        if (condition.getFunctionIdentifier().equals((Object)AlgebricksBuiltinFunctions.AND)) {
            for (int i = 0; i < condition.getArguments().size(); ++i) {
                AbstractFunctionCallExpression AFCexpr;
                ILogicalExpression expr = (ILogicalExpression)((Mutable)condition.getArguments().get(i)).getValue();
                if (!expr.getExpressionTag().equals((Object)LogicalExpressionTag.FUNCTION_CALL) || !(AFCexpr = (AbstractFunctionCallExpression)expr).hasAnnotation(SecondaryIndexSearchPreferenceAnnotation.class)) continue;
                return true;
            }
        } else if (condition.getExpressionTag().equals((Object)LogicalExpressionTag.FUNCTION_CALL) && condition.hasAnnotation(SecondaryIndexSearchPreferenceAnnotation.class)) {
            return true;
        }
        return false;
    }

    protected int findJoinNodeIndexByName(String name) {
        for (int i = 1; i <= this.numberOfTerms; ++i) {
            if (name.equals(this.jnArray[i].datasetNames.get(0))) {
                return i;
            }
            if (!name.equals(this.jnArray[i].aliases.get(0))) continue;
            return i;
        }
        return JoinNode.NO_JN;
    }

    private void findJoinConditionsAndAssignSels() throws AlgebricksException {
        ArrayList conjs = new ArrayList();
        for (JoinOperator jOp : this.allJoinOps) {
            AbstractBinaryJoinOperator joinOp = jOp.getAbstractJoinOp();
            ILogicalExpression expr = (ILogicalExpression)joinOp.getCondition().getValue();
            conjs.clear();
            if (expr.splitIntoConjuncts(conjs)) {
                conjs.remove(new MutableObject((Object)ConstantExpression.TRUE));
                for (Mutable conj : conjs) {
                    JoinCondition jc = new JoinCondition();
                    jc.outerJoin = jOp.getOuterJoin();
                    if (jc.outerJoin) {
                        this.outerJoin = true;
                    }
                    jc.joinCondition = ((ILogicalExpression)conj.getValue()).cloneExpression();
                    this.joinConditions.add(jc);
                }
                continue;
            }
            if (expr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) continue;
            JoinCondition jc = new JoinCondition();
            jc.outerJoin = jOp.getOuterJoin();
            if (jc.outerJoin) {
                this.outerJoin = true;
            }
            jc.joinCondition = expr.cloneExpression();
            this.joinConditions.add(jc);
        }
        ArrayList usedVars = new ArrayList();
        ArrayList<AssignOperator> erase = new ArrayList<AssignOperator>();
        for (JoinCondition jc : this.joinConditions) {
            usedVars.clear();
            ILogicalExpression expr = jc.joinCondition;
            expr.getUsedVariables(usedVars);
            for (AssignOperator aOp : this.assignOps) {
                for (int i = 0; i < aOp.getVariables().size(); ++i) {
                    if (!usedVars.contains(aOp.getVariables().get(i))) continue;
                    OperatorManipulationUtil.replaceVarWithExpr((AbstractFunctionCallExpression)((AbstractFunctionCallExpression)expr), (LogicalVariable)((LogicalVariable)aOp.getVariables().get(i)), (ILogicalExpression)((ILogicalExpression)((Mutable)aOp.getExpressions().get(i)).getValue()));
                    jc.joinCondition = expr;
                    erase.add(aOp);
                }
            }
            jc.selectivity = this.stats.getSelectivityFromAnnotationMain(jc.joinCondition, true, false);
        }
        for (int i = erase.size() - 1; i >= 0; --i) {
            this.assignOps.remove(erase.get(i));
        }
        for (JoinCondition jc : this.joinConditions) {
            ILogicalExpression joinExpr = jc.joinCondition;
            usedVars.clear();
            joinExpr.getUsedVariables(usedVars);
            jc.rightSideBits = -1;
            jc.leftSideBits = -1;
            jc.comparisonType = ((AbstractFunctionCallExpression)joinExpr).getFunctionIdentifier().equals((Object)AlgebricksBuiltinFunctions.EQ) ? JoinCondition.comparisonOp.OP_EQ : JoinCondition.comparisonOp.OP_OTHER;
            jc.numberOfVars = usedVars.size();
            for (int i = 0; i < jc.numberOfVars; ++i) {
                int bits = 1 << this.varLeafInputIds.get(usedVars.get(i)) - 1;
                if (bits == -1) continue;
                if (i == 0) {
                    jc.leftSideBits = bits;
                } else if (i == 1) {
                    jc.rightSideBits = bits;
                }
                jc.datasetBits |= bits;
            }
        }
    }

    private void markCompositeJoinPredicates() {
        for (int i = 0; i < this.joinConditions.size() - 1; ++i) {
            for (int j = i + 1; j < this.joinConditions.size(); ++j) {
                if (this.joinConditions.get((int)i).datasetBits != this.joinConditions.get((int)j).datasetBits) continue;
                this.joinConditions.get((int)j).partOfComposite = true;
            }
        }
    }

    private boolean verticesMatch(JoinCondition jc1, JoinCondition jc2) {
        return jc1.leftSideBits == jc2.leftSideBits || jc1.leftSideBits == jc2.rightSideBits || jc1.rightSideBits == jc2.leftSideBits || jc1.rightSideBits == jc2.rightSideBits;
    }

    private void markComponents(int startingJoinCondition) {
        List<JoinCondition> joinConditions = this.getJoinConditions();
        JoinCondition jc1 = joinConditions.get(startingJoinCondition);
        for (int i = 0; i < joinConditions.size(); ++i) {
            JoinCondition jc2 = joinConditions.get(i);
            if (i == startingJoinCondition || jc2.componentNumber != 0 || !this.verticesMatch(jc1, jc2)) continue;
            jc2.componentNumber = 1;
            this.markComponents(i);
        }
    }

    private void findIfJoinGraphIsConnected() {
        int numJoinConditions = this.joinConditions.size();
        if (numJoinConditions < this.numberOfTerms - 1) {
            this.connectedJoinGraph = false;
            return;
        }
        if (numJoinConditions > 0) {
            this.joinConditions.get((int)0).componentNumber = 1;
            this.markComponents(0);
            for (int i = 1; i < numJoinConditions; ++i) {
                if (this.joinConditions.get((int)i).componentNumber != 0) continue;
                this.connectedJoinGraph = false;
                return;
            }
        }
    }

    private double findInListCard(ILogicalOperator op) {
        ConstantExpression constantExpr;
        AsterixConstantValue constantValue;
        IAObject v;
        UnnestOperator unnestOp;
        ILogicalExpression unnestExpr;
        UnnestingFunctionCallExpression unnestingFuncExpr;
        if (op.getOperatorTag() == LogicalOperatorTag.ASSIGN) {
            return 1.0;
        }
        if (op.getOperatorTag() == LogicalOperatorTag.UNNEST && (unnestingFuncExpr = (UnnestingFunctionCallExpression)(unnestExpr = (ILogicalExpression)(unnestOp = (UnnestOperator)op).getExpressionRef().getValue())).getFunctionIdentifier().equals((Object)BuiltinFunctions.SCAN_COLLECTION) && ((ILogicalExpression)((Mutable)unnestingFuncExpr.getArguments().get(0)).getValue()).getExpressionTag() == LogicalExpressionTag.CONSTANT && (v = (constantValue = (AsterixConstantValue)(constantExpr = (ConstantExpression)((Mutable)unnestingFuncExpr.getArguments().get(0)).getValue()).getValue()).getObject()).getType().getTypeTag() == ATypeTag.ARRAY) {
            AOrderedList array = (AOrderedList)v;
            return array.size();
        }
        return 10.0;
    }

    private String findAlias(DataSourceScanOperator scanOp) {
        DataSource ds = (DataSource)scanOp.getDataSource();
        List allVars = scanOp.getVariables();
        LogicalVariable dataRecVarInScan = ds.getDataRecordVariable(allVars);
        return dataRecVarInScan.toString().substring(2);
    }

    private boolean isThisCombinationPossible(JoinNode leftJn, JoinNode rightJn) {
        for (Quadruple<Integer, Integer, JoinOperator, Integer> tr : this.outerJoinsDependencyList) {
            if (!((JoinOperator)tr.getThird()).getOuterJoin() || rightJn.datasetBits != (Integer)tr.getSecond() || (leftJn.datasetBits & (Integer)tr.getFirst()) > 0) continue;
            return false;
        }
        if (leftJn.level == 1) {
            for (Quadruple<Integer, Integer, JoinOperator, Integer> tr : this.outerJoinsDependencyList) {
                if (!((JoinOperator)tr.getThird()).getOuterJoin() || leftJn.datasetBits != (Integer)tr.getSecond() || (rightJn.datasetBits & (Integer)tr.getFirst()) > 0) continue;
                return false;
            }
        }
        return true;
    }

    private int findBuildSet(int jbits, int numbTabs) {
        if (this.buildSets.isEmpty()) {
            return -1;
        }
        for (int i = 0; i < this.buildSets.size(); ++i) {
            if (!((Boolean)this.buildSets.get((int)i).third).booleanValue() || ((Integer)this.buildSets.get((int)i).first & jbits) <= 0) continue;
            return i;
        }
        return -1;
    }

    private int addNonBushyJoinNodes(int level, int jnNumber, int[] startJnAtLevel) throws AlgebricksException {
        int startJnSecondLevel = startJnAtLevel[2];
        int startJnPrevLevel = startJnAtLevel[level - 1];
        int startJnNextLevel = startJnAtLevel[level];
        for (int i = startJnPrevLevel; i < startJnNextLevel; ++i) {
            JoinNode jnI = this.jnArray[i];
            jnI.jnArrayIndex = i;
            if (jnI.highestDatasetId == 0) continue;
            int endLevel = this.outerJoin && this.buildSets.size() > 0 ? startJnNextLevel : startJnSecondLevel;
            for (int j = 1; j < endLevel; ++j) {
                int addPlansToThisJn;
                int k;
                if (level == 2 && i > j) continue;
                JoinNode jnJ = this.jnArray[j];
                jnJ.jnArrayIndex = j;
                if ((jnI.datasetBits & jnJ.datasetBits) > 0 || (k = this.findBuildSet(jnJ.datasetBits, jnI.level + jnJ.level)) > -1 && (jnI.datasetBits & (Integer)this.buildSets.get((int)k).first) == 0 || !this.isThisCombinationPossible(jnI, jnJ)) continue;
                int newBits = jnI.datasetBits | jnJ.datasetBits;
                if (k > 0 && newBits == (Integer)this.buildSets.get((int)k).first) {
                    this.buildSets.get((int)k).third = false;
                }
                JoinNode jnNewBits = this.jnArray[newBits];
                jnNewBits.jnArrayIndex = newBits;
                if (jnNewBits.jnIndex == 0) {
                    JoinNode jn = this.jnArray[++jnNumber];
                    jn.jnArrayIndex = jnNumber;
                    jn.datasetBits = newBits;
                    if (newBits > this.maxBits) {
                        this.maxBits = newBits;
                        this.allTabsJnNum = jnNumber;
                    }
                    jnNewBits.jnIndex = addPlansToThisJn = jnNumber;
                    jn.level = level;
                    jn.highestDatasetId = Math.max(jnI.highestDatasetId, j);
                    jn.datasetIndexes = new ArrayList<Integer>();
                    jn.datasetIndexes.addAll(jnI.datasetIndexes);
                    jn.datasetIndexes.addAll(jnJ.datasetIndexes);
                    Collections.sort(jn.datasetIndexes);
                    jn.datasetNames = new ArrayList<String>();
                    jn.datasetNames.addAll(jnI.datasetNames);
                    jn.datasetNames.addAll(jnJ.datasetNames);
                    Collections.sort(jn.datasetNames);
                    jn.aliases = new ArrayList<String>();
                    jn.aliases.addAll(jnI.aliases);
                    jn.aliases.addAll(jnJ.aliases);
                    Collections.sort(jn.aliases);
                    jn.size = jnI.size + jnJ.size;
                    jn.setCardinality(jn.computeJoinCardinality(), true);
                    jn.setSizeVarsAfterScan(jnI.getSizeVarsAfterScan() + jnJ.getSizeVarsAfterScan());
                } else {
                    addPlansToThisJn = jnNewBits.jnIndex;
                }
                JoinNode jnIJ = this.jnArray[addPlansToThisJn];
                jnIJ.jnArrayIndex = addPlansToThisJn;
                jnIJ.addMultiDatasetPlans(jnI, jnJ);
                if (this.forceJoinOrderMode && level > this.cboFullEnumLevel) break;
            }
            if (this.forceJoinOrderMode && level > this.cboFullEnumLevel) break;
        }
        return jnNumber;
    }

    private int enumerateHigherLevelJoinNodes() throws AlgebricksException {
        int jnNumber = this.numberOfTerms;
        int[] firstJnAtLevel = new int[this.numberOfTerms + 1];
        firstJnAtLevel[1] = 1;
        IPlanPrettyPrinter pp = this.optCtx.getPrettyPrinter();
        int startLevel = 2;
        if (LOGGER.isTraceEnabled()) {
            EnumerateJoinsRule.printPlan(pp, this.op, "Original Whole plan in JN 4");
        }
        for (int level = startLevel; level <= this.numberOfTerms; ++level) {
            firstJnAtLevel[level] = jnNumber + 1;
            jnNumber = this.addNonBushyJoinNodes(level, jnNumber, firstJnAtLevel);
        }
        if (LOGGER.isTraceEnabled()) {
            EnumerateJoinsRule.printPlan(pp, this.op, "Original Whole plan in JN 5");
        }
        double grpInputCard = (double)Math.round(this.jnArray[jnNumber].getCardinality() * 100.0) / 100.0;
        double grpOutputCard = (double)Math.round(Math.min(grpInputCard, this.jnArray[jnNumber].distinctCardinality) * 100.0) / 100.0;
        if (!this.cboTestMode && this.rootGroupByDistinctOp != null) {
            this.rootGroupByDistinctOp.getAnnotations().put("INPUT_CARDINALITY", grpInputCard);
            this.rootGroupByDistinctOp.getAnnotations().put("OUTPUT_CARDINALITY", grpOutputCard);
        }
        if (!this.cboTestMode && this.rootOrderByOp != null) {
            if (this.rootGroupByDistinctOp != null) {
                this.rootOrderByOp.getAnnotations().put("INPUT_CARDINALITY", grpOutputCard);
                this.rootOrderByOp.getAnnotations().put("OUTPUT_CARDINALITY", grpOutputCard);
            } else {
                this.rootOrderByOp.getAnnotations().put("INPUT_CARDINALITY", grpInputCard);
                this.rootOrderByOp.getAnnotations().put("OUTPUT_CARDINALITY", grpInputCard);
            }
        }
        return jnNumber;
    }

    private int initializeBaseLevelJoinNodes() throws AlgebricksException {
        PlanNode pn = new PlanNode(0, this);
        this.allPlans.add(pn);
        boolean noCards = false;
        int i = 1;
        while (i <= this.numberOfTerms) {
            JoinNode jn = this.jnArray[i];
            jn.jnArrayIndex = i;
            jn.datasetBits = 1 << i - 1;
            jn.datasetIndexes = new ArrayList<Integer>(Collections.singleton(i));
            ILogicalOperator leafInput = this.leafInputs.get(i - 1);
            DataSourceScanOperator scanOp = this.findDataSourceScanOperator(leafInput);
            if (scanOp != null) {
                DataSourceId id = (DataSourceId)scanOp.getDataSource().getId();
                jn.aliases = new ArrayList<String>(Collections.singleton(this.findAlias(scanOp)));
                jn.datasetNames = new ArrayList<String>(Collections.singleton(id.getDatasourceName()));
                Index index = this.stats.findSampleIndex(scanOp, this.optCtx);
                Index.SampleIndexDetails idxDetails = index != null ? (Index.SampleIndexDetails)index.getIndexDetails() : null;
                jn.idxDetails = idxDetails;
                if (this.cboTestMode) {
                    jn.origCardinality = 1000000.0;
                    jn.size = 500.0;
                } else {
                    if (idxDetails == null) {
                        return PlanNode.NO_PLAN;
                    }
                    jn.setOrigCardinality(idxDetails.getSourceCardinality(), false);
                    jn.setAvgDocSize(idxDetails.getSourceAvgItemSize());
                    jn.setSizeVarsFromDisk(10.0);
                    jn.setSizeVarsAfterScan(10.0);
                }
                jn.setCardinality(jn.origCardinality * this.stats.getSelectivity(leafInput, false), false);
            } else {
                jn.datasetNames = new ArrayList<String>(Collections.singleton("unnestOrAssign"));
                jn.aliases = new ArrayList<String>(Collections.singleton("unnestOrAssign"));
                double card = this.findInListCard(leafInput);
                jn.setOrigCardinality(card, false);
                jn.setCardinality(card, false);
                jn.size = 10.0;
            }
            if (jn.origCardinality >= 1.0E200) {
                noCards = true;
            }
            jn.leafInput = this.leafInputs.get(i - 1);
            jn.highestDatasetId = i++;
            jn.level = 1;
        }
        if (noCards) {
            return PlanNode.NO_PLAN;
        }
        return this.numberOfTerms;
    }

    protected DataSourceScanOperator findDataSourceScanOperator(ILogicalOperator op) {
        ILogicalOperator origOp = op;
        while (op != null && op.getOperatorTag() != LogicalOperatorTag.EMPTYTUPLESOURCE) {
            if (op.getOperatorTag().equals((Object)LogicalOperatorTag.DATASOURCESCAN)) {
                return (DataSourceScanOperator)op;
            }
            op = (ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue();
        }
        return null;
    }

    private int enumerateBaseLevelJoinNodes() throws AlgebricksException {
        int lastBaseLevelJnNum = this.initializeBaseLevelJoinNodes();
        if (lastBaseLevelJnNum == PlanNode.NO_PLAN) {
            return PlanNode.NO_PLAN;
        }
        JoinNode[] jnArray = this.getJnArray();
        int limit = -1;
        if (this.numberOfTerms == 1) {
            jnArray[1].setLimitVal(this.findLimitValue(this.op));
        }
        for (int i = 1; i <= this.numberOfTerms; ++i) {
            int dataScanPlan;
            JoinNode jn = jnArray[i];
            Index.SampleIndexDetails idxDetails = jn.getIdxDetails();
            ILogicalOperator leafInput = this.leafInputs.get(i - 1);
            if (!this.cboTestMode) {
                if (idxDetails == null) {
                    dataScanPlan = jn.addSingleDatasetPlans();
                    if (dataScanPlan != PlanNode.NO_PLAN) continue;
                    return PlanNode.NO_PLAN;
                }
                jn.setCardsAndSizes(idxDetails, leafInput);
                DataSourceScanOperator scanOp = this.findDataSourceScanOperator(leafInput);
                ILogicalOperator grpByDistinctOp = this.dataScanAndGroupByDistinctOps.get(scanOp);
                if (grpByDistinctOp != null) {
                    long distinctCardinality = this.stats.findDistinctCardinality(grpByDistinctOp);
                    jn.distinctCardinality = distinctCardinality;
                    double grpInputCard = (double)Math.round(jn.cardinality * 100.0) / 100.0;
                    double grpOutputCard = (double)Math.round(Math.min(grpInputCard, (double)distinctCardinality) * 100.0) / 100.0;
                    grpByDistinctOp.getAnnotations().put("INPUT_CARDINALITY", grpInputCard);
                    grpByDistinctOp.getAnnotations().put("OUTPUT_CARDINALITY", grpOutputCard);
                }
            }
            if ((dataScanPlan = jn.addSingleDatasetPlans()) == PlanNode.NO_PLAN) {
                return PlanNode.NO_PLAN;
            }
            jn.addIndexAccessPlans(leafInput);
        }
        return this.numberOfTerms;
    }

    private int findLimitValue(AbstractLogicalOperator oper) {
        AbstractLogicalOperator op = oper;
        int limit = -1;
        while (op.getOperatorTag() != LogicalOperatorTag.EMPTYTUPLESOURCE) {
            if (op.getOperatorTag() == LogicalOperatorTag.LIMIT) {
                LimitOperator lop = (LimitOperator)op;
                ILogicalExpression expr = (ILogicalExpression)lop.getMaxObjects().getValue();
                if (expr != null && expr.getExpressionTag() == LogicalExpressionTag.CONSTANT) {
                    limit = Integer.parseInt(((ILogicalExpression)lop.getMaxObjects().getValue()).toString());
                }
            } else {
                if (op.getOperatorTag() == LogicalOperatorTag.ORDER) {
                    return -1;
                }
                if (op.getOperatorTag() == LogicalOperatorTag.GROUP) {
                    return -1;
                }
            }
            op = (ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue();
        }
        return limit;
    }

    private boolean isPredicateCardinalityAnnotationPresent(ILogicalExpression leExpr) {
        AbstractFunctionCallExpression afcExpr;
        PredicateCardinalityAnnotation pca;
        return leExpr.getExpressionTag().equals((Object)LogicalExpressionTag.FUNCTION_CALL) && (pca = (PredicateCardinalityAnnotation)(afcExpr = (AbstractFunctionCallExpression)leExpr).getAnnotation(PredicateCardinalityAnnotation.class)) != null;
    }

    protected ILogicalOperator findDataSourceScanOperatorParent(ILogicalOperator op) {
        ILogicalOperator parent = op;
        while (op != null && op.getOperatorTag() != LogicalOperatorTag.EMPTYTUPLESOURCE) {
            if (op.getOperatorTag().equals((Object)LogicalOperatorTag.DATASOURCESCAN)) {
                return parent;
            }
            parent = op;
            op = (ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue();
        }
        return null;
    }

    protected SampleDataSource getSampleDataSource(DataSourceScanOperator scanOp) throws AlgebricksException {
        DataSource ds = (DataSource)scanOp.getDataSource();
        DataSourceId dsid = ds.getId();
        MetadataProvider mdp = (MetadataProvider)this.optCtx.getMetadataProvider();
        Index index = mdp.findSampleIndex(dsid.getDatabaseName(), dsid.getDataverseName(), dsid.getDatasourceName());
        DatasetDataSource dds = (DatasetDataSource)ds;
        return new SampleDataSource(dds.getDataset(), index.getIndexName(), ds.getItemType(), ds.getMetaItemType(), ds.getDomain());
    }

    protected ILogicalOperator findASelectOp(ILogicalOperator op) {
        while (op != null && op.getOperatorTag() != LogicalOperatorTag.EMPTYTUPLESOURCE) {
            if (op.getOperatorTag() == LogicalOperatorTag.SELECT) {
                return op;
            }
            op = (ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue();
        }
        return null;
    }

    protected boolean findUnnestOp(ILogicalOperator op) {
        ILogicalOperator currentOp = op;
        while (currentOp != null && currentOp.getOperatorTag() != LogicalOperatorTag.EMPTYTUPLESOURCE) {
            if (currentOp.getOperatorTag().equals((Object)LogicalOperatorTag.UNNEST)) {
                return true;
            }
            currentOp = (ILogicalOperator)((Mutable)currentOp.getInputs().get(0)).getValue();
        }
        return false;
    }

    private void findJoinConditions() throws AlgebricksException {
        this.findJoinConditionsAndAssignSels();
        for (ILogicalExpression exp : this.singleDatasetPreds) {
            SelectOperator selOp;
            if (this.isPredicateCardinalityAnnotationPresent(exp)) continue;
            ArrayList<LogicalVariable> vars = new ArrayList<LogicalVariable>();
            exp.getUsedVariables(vars);
            if (vars.size() != 1) continue;
            ILogicalOperator leafInput = this.findLeafInput(vars);
            if (leafInput.getOperatorTag().equals((Object)LogicalOperatorTag.SELECT)) {
                selOp = this.getStatsHandle().findSelectOpWithExpr(leafInput, exp);
                if (selOp == null) {
                    selOp = (SelectOperator)leafInput;
                }
            } else {
                selOp = new SelectOperator((Mutable)new MutableObject((Object)exp));
                selOp.getInputs().add(new MutableObject((Object)leafInput));
            }
            double sel = this.getStatsHandle().findSelectivityForThisPredicate(selOp, (AbstractFunctionCallExpression)exp, this.findUnnestOp((ILogicalOperator)selOp));
            sel = Math.min(sel, 0.9999);
            PredicateCardinalityAnnotation anno = new PredicateCardinalityAnnotation(sel);
            AbstractFunctionCallExpression afce = (AbstractFunctionCallExpression)exp;
            afce.putAnnotation((IExpressionAnnotation)anno);
        }
        if (this.singleDatasetPreds.size() > 0) {
            for (JoinCondition jc : this.joinConditions) {
                double sel = this.stats.getSelectivityFromAnnotationMain(jc.getJoinCondition(), false, true);
                if (sel == -1.0) continue;
                jc.selectivity = sel;
            }
        }
    }

    protected int enumerateJoins() throws AlgebricksException {
        InnerJoinOperator dummyInput = new InnerJoinOperator(null, null, null);
        this.localJoinOp = new InnerJoinOperator((Mutable)new MutableObject((Object)ConstantExpression.TRUE), (Mutable)new MutableObject((Object)dummyInput), (Mutable)new MutableObject((Object)dummyInput));
        int lastBaseLevelJnNum = this.enumerateBaseLevelJoinNodes();
        if (lastBaseLevelJnNum == PlanNode.NO_PLAN) {
            return PlanNode.NO_PLAN;
        }
        IPlanPrettyPrinter pp = this.optCtx.getPrettyPrinter();
        if (LOGGER.isTraceEnabled()) {
            EnumerateJoinsRule.printPlan(pp, this.op, "Original Whole plan in JN 1");
        }
        this.findJoinConditions();
        this.findIfJoinGraphIsConnected();
        if (LOGGER.isTraceEnabled()) {
            EnumerateJoinsRule.printPlan(pp, this.op, "Original Whole plan in JN 2");
        }
        this.markCompositeJoinPredicates();
        int lastJnNum = this.enumerateHigherLevelJoinNodes();
        JoinNode lastJn = this.jnArray[this.allTabsJnNum];
        if (LOGGER.isTraceEnabled()) {
            EnumerateJoinsRule.printPlan(pp, this.op, "Original Whole plan in JN END");
            LOGGER.trace(this.dumpJoinNodes(lastJnNum));
        }
        return lastJn.cheapestPlanIndex;
    }

    private String dumpJoinNodes(int numJoinNodes) {
        StringBuilder sb = new StringBuilder(128);
        sb.append(LocalDateTime.now());
        this.dumpContext(sb);
        for (int i = 1; i <= numJoinNodes; ++i) {
            JoinNode jn = this.jnArray[i];
            sb.append(jn);
        }
        sb.append("Number of terms is ").append(this.numberOfTerms).append(", Number of Join Nodes is ").append(numJoinNodes).append('\n');
        sb.append("Printing cost of all Final Plans").append('\n');
        this.jnArray[numJoinNodes].printCostOfAllPlans(sb);
        return sb.toString();
    }

    private void dumpContext(StringBuilder sb) {
        sb.append("\n\nCBO CONTEXT").append('\n');
        sb.append("----------------------------------------\n");
        sb.append("BLOCK SIZE = ").append(this.getCostMethodsHandle().getBufferCachePageSize()).append('\n');
        sb.append("DOP = ").append(this.getCostMethodsHandle().getDOP()).append('\n');
        sb.append("MAX MEMORY SIZE FOR JOIN = ").append(this.getCostMethodsHandle().getMaxMemorySizeForJoin()).append('\n');
        sb.append("MAX MEMORY SIZE FOR GROUP = ").append(this.getCostMethodsHandle().getMaxMemorySizeForGroup()).append('\n');
        sb.append("MAX MEMORY SIZE FOR SORT = ").append(this.getCostMethodsHandle().getMaxMemorySizeForSort()).append('\n');
        sb.append("----------------------------------------\n");
    }

    private static boolean getForceJoinOrderMode(IOptimizationContext context) {
        PhysicalOptimizationConfig physOptConfig = context.getPhysicalOptimizationConfig();
        return physOptConfig.getForceJoinOrderMode();
    }

    private static String getQueryPlanShape(IOptimizationContext context) {
        PhysicalOptimizationConfig physOptConfig = context.getPhysicalOptimizationConfig();
        return physOptConfig.getQueryPlanShapeMode();
    }
}

