/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.pushdown.schema;

import java.util.HashMap;
import java.util.Map;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.optimizer.rules.pushdown.schema.AbstractComplexExpectedSchemaNode;
import org.apache.asterix.optimizer.rules.pushdown.schema.ExpectedSchemaNodeType;
import org.apache.asterix.optimizer.rules.pushdown.schema.IExpectedSchemaNode;
import org.apache.asterix.optimizer.rules.pushdown.schema.IExpectedSchemaNodeVisitor;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class ObjectExpectedSchemaNode
extends AbstractComplexExpectedSchemaNode {
    private final Map<String, IExpectedSchemaNode> children = new HashMap<String, IExpectedSchemaNode>();

    public ObjectExpectedSchemaNode(AbstractComplexExpectedSchemaNode parent, SourceLocation sourceLocation, String functionName) {
        super(parent, sourceLocation, functionName);
    }

    public boolean isRoot() {
        return false;
    }

    public Map<String, IExpectedSchemaNode> getChildren() {
        return this.children;
    }

    public void addChild(String fieldName, IExpectedSchemaNode child) {
        this.children.put(fieldName, child);
    }

    @Override
    public ExpectedSchemaNodeType getType() {
        return ExpectedSchemaNodeType.OBJECT;
    }

    @Override
    public <R, T> R accept(IExpectedSchemaNodeVisitor<R, T> visitor, T arg) {
        return visitor.visit(this, arg);
    }

    @Override
    public void replaceChild(IExpectedSchemaNode oldNode, IExpectedSchemaNode newNode) {
        String fieldName = this.getChildFieldName(oldNode);
        this.children.replace(fieldName, newNode);
    }

    public String getChildFieldName(IExpectedSchemaNode requestedChild) {
        String key = null;
        for (Map.Entry<String, IExpectedSchemaNode> child : this.children.entrySet()) {
            if (child.getValue() != requestedChild) continue;
            key = child.getKey();
            break;
        }
        if (key == null) {
            throw new IllegalStateException("Node " + requestedChild.getType() + " is not a child");
        }
        return key;
    }

    protected IAType getType(IAType childType, IExpectedSchemaNode childNode, String typeName) {
        String key = this.getChildFieldName(childNode);
        IAType[] fieldTypes = new IAType[]{childType};
        String[] fieldNames = new String[]{key};
        return new ARecordType("typeName", fieldNames, fieldTypes, false);
    }
}

