/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.pushdown.visitor;

import java.util.Map;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.ProjectionFiltrationTypeUtil;
import org.apache.asterix.optimizer.rules.pushdown.schema.AnyExpectedSchemaNode;
import org.apache.asterix.optimizer.rules.pushdown.schema.ArrayExpectedSchemaNode;
import org.apache.asterix.optimizer.rules.pushdown.schema.IExpectedSchemaNode;
import org.apache.asterix.optimizer.rules.pushdown.schema.IExpectedSchemaNodeVisitor;
import org.apache.asterix.optimizer.rules.pushdown.schema.ObjectExpectedSchemaNode;
import org.apache.asterix.optimizer.rules.pushdown.schema.RootExpectedSchemaNode;
import org.apache.asterix.optimizer.rules.pushdown.schema.UnionExpectedSchemaNode;
import org.apache.asterix.runtime.projection.FunctionCallInformation;
import org.apache.asterix.runtime.projection.ProjectionFiltrationWarningFactoryProvider;

public class ColumnFilterPathBuilderVisitor
implements IExpectedSchemaNodeVisitor<IAType, IExpectedSchemaNode> {
    private IAType type;
    private Map<String, FunctionCallInformation> sourceInformationMap;
    private int counter = 0;

    public ARecordType buildPath(AnyExpectedSchemaNode anyNode) {
        return this.buildPath(anyNode, (IAType)BuiltinType.ANY, null, null);
    }

    public ARecordType buildPath(AnyExpectedSchemaNode anyNode, IAType constType, Map<String, FunctionCallInformation> sourceInformationMap, FunctionCallInformation compareFunctionInfo) {
        this.sourceInformationMap = sourceInformationMap;
        this.type = constType;
        if (sourceInformationMap != null) {
            this.type = ProjectionFiltrationTypeUtil.renameType((IAType)constType, (String)this.getTypeName());
            sourceInformationMap.put(this.type.getTypeName(), compareFunctionInfo);
        }
        return (ARecordType)anyNode.accept(this, anyNode);
    }

    @Override
    public IAType visit(RootExpectedSchemaNode node, IExpectedSchemaNode arg) {
        this.type = ColumnFilterPathBuilderVisitor.getRecordType(node, this.type, arg, this.getTypeName());
        return this.type;
    }

    @Override
    public IAType visit(ObjectExpectedSchemaNode node, IExpectedSchemaNode arg) {
        this.type = ColumnFilterPathBuilderVisitor.getRecordType(node, this.type, arg, this.getTypeName());
        this.putCallInfo(this.type, arg);
        return node.getParent().accept(this, node);
    }

    @Override
    public IAType visit(ArrayExpectedSchemaNode node, IExpectedSchemaNode arg) {
        this.type = new AOrderedListType(this.type, this.getTypeName());
        this.putCallInfo(this.type, arg);
        return node.getParent().accept(this, node);
    }

    @Override
    public IAType visit(UnionExpectedSchemaNode node, IExpectedSchemaNode arg) {
        this.putCallInfo(this.type, arg);
        return node.getParent().accept(this, arg);
    }

    @Override
    public IAType visit(AnyExpectedSchemaNode node, IExpectedSchemaNode arg) {
        return node.getParent().accept(this, node);
    }

    private void putCallInfo(IAType type, IExpectedSchemaNode node) {
        if (this.sourceInformationMap != null) {
            this.sourceInformationMap.put(type.getTypeName(), this.createFunctionCallInformation(node));
        }
    }

    private static ARecordType getRecordType(ObjectExpectedSchemaNode objectNode, IAType childType, IExpectedSchemaNode childNode, String typeName) {
        String key = objectNode.getChildFieldName(childNode);
        IAType[] fieldTypes = new IAType[]{childType};
        String[] fieldNames = new String[]{key};
        return new ARecordType(typeName, fieldNames, fieldTypes, true);
    }

    private String getTypeName() {
        return "FilterPath" + this.counter++;
    }

    private FunctionCallInformation createFunctionCallInformation(IExpectedSchemaNode node) {
        return new FunctionCallInformation(node.getFunctionName(), node.getSourceLocation(), ProjectionFiltrationWarningFactoryProvider.TYPE_MISMATCH_FACTORY);
    }
}

