/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.pushdown.visitor;

import java.util.List;
import org.apache.asterix.metadata.utils.PushdownUtil;
import org.apache.asterix.optimizer.rules.pushdown.schema.ExpectedSchemaBuilder;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;

public class ExpressionValueAccessPushdownVisitor {
    private final ExpectedSchemaBuilder builder;

    public ExpressionValueAccessPushdownVisitor(ExpectedSchemaBuilder builder) {
        this.builder = builder;
    }

    public boolean transform(ILogicalExpression expr, LogicalVariable producedVar, IVariableTypeEnvironment typeEnv) throws AlgebricksException {
        if (this.skipPushdown(expr)) {
            return false;
        }
        AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)expr;
        if (this.isSuccessfullyPushedDown(funcExpr, producedVar, typeEnv)) {
            return true;
        }
        return this.pushValueAccessExpressionArg(funcExpr.getArguments(), producedVar, typeEnv);
    }

    private boolean skipPushdown(ILogicalExpression expr) {
        if (expr.getExpressionTag() == LogicalExpressionTag.VARIABLE) {
            LogicalVariable variable = VariableUtilities.getVariable((ILogicalExpression)expr);
            this.unregisterVariableIfNeeded(variable);
            return true;
        }
        return expr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL || this.builder.isEmpty() || this.shouldYieldVariables(expr);
    }

    private boolean shouldYieldVariables(ILogicalExpression expression) {
        AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)expression;
        return PushdownUtil.YIELDABLE_FUNCTIONS.contains(funcExpr.getFunctionIdentifier()) && PushdownUtil.isAllVariableExpressions((List)funcExpr.getArguments());
    }

    private boolean pushValueAccessExpressionArg(List<Mutable<ILogicalExpression>> exprList, LogicalVariable producedVar, IVariableTypeEnvironment typeEnv) throws AlgebricksException {
        boolean changed = false;
        for (Mutable<ILogicalExpression> exprRef : exprList) {
            changed |= this.transform((ILogicalExpression)exprRef.getValue(), null, typeEnv);
        }
        return changed;
    }

    private boolean isSuccessfullyPushedDown(AbstractFunctionCallExpression funcExpr, LogicalVariable producedVar, IVariableTypeEnvironment typeEnv) throws AlgebricksException {
        return PushdownUtil.SUPPORTED_FUNCTIONS.contains(funcExpr.getFunctionIdentifier()) && this.builder.setSchemaFromExpression(funcExpr, producedVar, typeEnv);
    }

    private void unregisterVariableIfNeeded(LogicalVariable variable) {
        if (this.builder.isVariableRegistered(variable)) {
            this.builder.unregisterVariable(variable);
        }
    }
}

