/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.translator;

import java.util.List;
import java.util.Map;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.external.feed.management.FeedConnectionRequest;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.Statement;
import org.apache.asterix.lang.common.clause.OrderbyClause;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.statement.CopyToStatement;
import org.apache.asterix.lang.common.statement.ExternalDetailsDecl;
import org.apache.asterix.lang.common.statement.Query;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Datatype;
import org.apache.asterix.metadata.entities.Index;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class CompiledStatements {

    public static class CompiledCopyToStatement
    extends AbstractCompiledStatement {
        private final Query query;
        private final VariableExpr sourceVariable;
        private final String adapter;
        private final Map<String, String> properties;
        private final List<Expression> pathExpressions;
        private final List<Expression> partitionExpressions;
        private final Map<Integer, VariableExpr> partitionsVariables;
        private final List<Expression> orderbyList;
        private final List<OrderbyClause.OrderModifier> orderByModifiers;
        private final List<OrderbyClause.NullOrderModifier> orderByNullModifierList;
        private final List<Expression> keyExpressions;
        private final boolean autogenerated;

        public CompiledCopyToStatement(CopyToStatement copyToStatement) {
            this.query = copyToStatement.getQuery();
            this.sourceVariable = copyToStatement.getSourceVariable();
            ExternalDetailsDecl eddDecl = copyToStatement.getExternalDetailsDecl();
            this.adapter = eddDecl.getAdapter();
            this.properties = eddDecl.getProperties();
            this.pathExpressions = copyToStatement.getPathExpressions();
            this.partitionExpressions = copyToStatement.getPartitionExpressions();
            this.partitionsVariables = copyToStatement.getPartitionsVariables();
            this.orderbyList = copyToStatement.getOrderByList();
            this.orderByModifiers = copyToStatement.getOrderByModifiers();
            this.orderByNullModifierList = copyToStatement.getOrderByNullModifierList();
            this.keyExpressions = copyToStatement.getKeyExpressions();
            this.autogenerated = copyToStatement.isAutogenerated();
        }

        @Override
        public Statement.Kind getKind() {
            return Statement.Kind.COPY_TO;
        }

        public Query getQuery() {
            return this.query;
        }

        public VariableExpr getSourceVariable() {
            return this.sourceVariable;
        }

        public String getAdapter() {
            return this.adapter;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public List<Expression> getPathExpressions() {
            return this.pathExpressions;
        }

        public boolean isPartitioned() {
            return !this.partitionExpressions.isEmpty();
        }

        public boolean isOrdered() {
            return !this.orderbyList.isEmpty();
        }

        public List<Expression> getPartitionExpressions() {
            return this.partitionExpressions;
        }

        public VariableExpr getPartitionsVariables(int index) {
            return this.partitionsVariables.get(index);
        }

        public List<Expression> getOrderByExpressions() {
            return this.orderbyList;
        }

        public List<OrderbyClause.OrderModifier> getOrderByModifiers() {
            return this.orderByModifiers;
        }

        public List<OrderbyClause.NullOrderModifier> getOrderByNullModifiers() {
            return this.orderByNullModifierList;
        }

        public List<Expression> getKeyExpressions() {
            return this.keyExpressions;
        }

        public boolean isAutogenerated() {
            return this.autogenerated;
        }
    }

    public static class CompiledIndexCompactStatement
    extends CompiledCompactStatement {
        private final Dataset dataset;
        private final Index index;

        public CompiledIndexCompactStatement(Dataset dataset, Index index) {
            super(dataset.getDatabaseName(), dataset.getDataverseName(), dataset.getDatasetName());
            this.dataset = dataset;
            this.index = index;
        }

        public Dataset getDataset() {
            return this.dataset;
        }

        public Index getIndex() {
            return this.index;
        }
    }

    public static class CompiledCompactStatement
    extends AbstractCompiledStatement {
        private final String databaseName;
        private final DataverseName dataverseName;
        private final String datasetName;

        public CompiledCompactStatement(String databaseName, DataverseName dataverseName, String datasetName) {
            this.databaseName = databaseName;
            this.dataverseName = dataverseName;
            this.datasetName = datasetName;
        }

        public String getDatabaseName() {
            return this.databaseName;
        }

        public DataverseName getDataverseName() {
            return this.dataverseName;
        }

        public String getDatasetName() {
            return this.datasetName;
        }

        @Override
        public Statement.Kind getKind() {
            return Statement.Kind.COMPACT;
        }
    }

    public static class CompiledDeleteStatement
    extends AbstractCompiledStatement
    implements ICompiledDmlStatement {
        private final String databaseName;
        private final DataverseName dataverseName;
        private final String datasetName;
        private final Expression condition;
        private final int varCounter;
        private final Query query;

        public CompiledDeleteStatement(VariableExpr var, String databaseName, DataverseName dataverseName, String datasetName, Expression condition, int varCounter, Query query) {
            this.databaseName = databaseName;
            this.dataverseName = dataverseName;
            this.datasetName = datasetName;
            this.condition = condition;
            this.varCounter = varCounter;
            this.query = query;
        }

        @Override
        public String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public String getDatasetName() {
            return this.datasetName;
        }

        @Override
        public DataverseName getDataverseName() {
            return this.dataverseName;
        }

        public int getVarCounter() {
            return this.varCounter;
        }

        public Expression getCondition() {
            return this.condition;
        }

        public Query getQuery() throws AlgebricksException {
            return this.query;
        }

        @Override
        public Statement.Kind getKind() {
            return Statement.Kind.DELETE;
        }

        @Override
        public byte getCategory() {
            return 2;
        }
    }

    public static class CompiledSubscribeFeedStatement
    extends AbstractCompiledStatement
    implements ICompiledDmlStatement {
        private final FeedConnectionRequest request;
        private final int varCounter;

        public CompiledSubscribeFeedStatement(FeedConnectionRequest request, int varCounter) {
            this.request = request;
            this.varCounter = varCounter;
        }

        @Override
        public String getDatabaseName() {
            return this.request.getReceivingFeedId().getDatabaseName();
        }

        @Override
        public DataverseName getDataverseName() {
            return this.request.getReceivingFeedId().getDataverseName();
        }

        public String getFeedName() {
            return this.request.getReceivingFeedId().getEntityName();
        }

        @Override
        public String getDatasetName() {
            return this.request.getTargetDataset();
        }

        public int getVarCounter() {
            return this.varCounter;
        }

        @Override
        public Statement.Kind getKind() {
            return Statement.Kind.SUBSCRIBE_FEED;
        }

        @Override
        public byte getCategory() {
            return 2;
        }
    }

    public static class CompiledUpsertStatement
    extends CompiledInsertStatement {
        public CompiledUpsertStatement(String databaseName, DataverseName dataverseName, String datasetName, Query query, int varCounter, VariableExpr var, Expression returnExpression) {
            super(databaseName, dataverseName, datasetName, query, varCounter, var, returnExpression);
        }

        @Override
        public Statement.Kind getKind() {
            return Statement.Kind.UPSERT;
        }
    }

    public static class CompiledInsertStatement
    extends AbstractCompiledStatement
    implements ICompiledDmlStatement {
        private final String databaseName;
        private final DataverseName dataverseName;
        private final String datasetName;
        private final Query query;
        private final int varCounter;
        private final VariableExpr var;
        private final Expression returnExpression;

        public CompiledInsertStatement(String databaseName, DataverseName dataverseName, String datasetName, Query query, int varCounter, VariableExpr var, Expression returnExpression) {
            this.databaseName = databaseName;
            this.dataverseName = dataverseName;
            this.datasetName = datasetName;
            this.query = query;
            this.varCounter = varCounter;
            this.var = var;
            this.returnExpression = returnExpression;
        }

        @Override
        public String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public DataverseName getDataverseName() {
            return this.dataverseName;
        }

        @Override
        public String getDatasetName() {
            return this.datasetName;
        }

        public int getVarCounter() {
            return this.varCounter;
        }

        public Query getQuery() {
            return this.query;
        }

        public VariableExpr getVar() {
            return this.var;
        }

        public Expression getReturnExpression() {
            return this.returnExpression;
        }

        @Override
        public Statement.Kind getKind() {
            return Statement.Kind.INSERT;
        }

        @Override
        public byte getCategory() {
            return 2;
        }
    }

    public static class CompiledCopyFromFileStatement
    extends AbstractCompiledStatement
    implements ICompiledDmlStatement {
        private final String databaseName;
        private final DataverseName dataverseName;
        private final String datasetName;
        private final Datatype itemType;
        private final String adapter;
        private final Map<String, String> properties;

        public CompiledCopyFromFileStatement(String databaseName, DataverseName dataverseName, String datasetName, Datatype itemType, String adapter, Map<String, String> properties) {
            this.databaseName = databaseName;
            this.dataverseName = dataverseName;
            this.datasetName = datasetName;
            this.itemType = itemType;
            this.adapter = adapter;
            this.properties = properties;
        }

        @Override
        public String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public DataverseName getDataverseName() {
            return this.dataverseName;
        }

        @Override
        public String getDatasetName() {
            return this.datasetName;
        }

        public String getAdapter() {
            return this.adapter;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public Datatype getItemType() {
            return this.itemType;
        }

        @Override
        public Statement.Kind getKind() {
            return Statement.Kind.COPY_FROM;
        }

        @Override
        public byte getCategory() {
            return 2;
        }
    }

    public static class CompiledLoadFromFileStatement
    extends AbstractCompiledStatement
    implements ICompiledDmlStatement {
        private final String databaseName;
        private final DataverseName dataverseName;
        private final String datasetName;
        private final boolean alreadySorted;
        private final String adapter;
        private final Map<String, String> properties;

        public CompiledLoadFromFileStatement(String databaseName, DataverseName dataverseName, String datasetName, String adapter, Map<String, String> properties, boolean alreadySorted) {
            this.databaseName = databaseName;
            this.dataverseName = dataverseName;
            this.datasetName = datasetName;
            this.alreadySorted = alreadySorted;
            this.adapter = adapter;
            this.properties = properties;
        }

        @Override
        public String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public DataverseName getDataverseName() {
            return this.dataverseName;
        }

        @Override
        public String getDatasetName() {
            return this.datasetName;
        }

        public boolean alreadySorted() {
            return this.alreadySorted;
        }

        public String getAdapter() {
            return this.adapter;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        @Override
        public Statement.Kind getKind() {
            return Statement.Kind.LOAD;
        }

        @Override
        public byte getCategory() {
            return 2;
        }
    }

    public static class CompiledCreateIndexStatement
    extends AbstractCompiledStatement
    implements ICompiledDmlStatement {
        private final Dataset dataset;
        private final Index index;

        public CompiledCreateIndexStatement(Dataset dataset, Index index) {
            this.dataset = dataset;
            this.index = index;
        }

        @Override
        public String getDatasetName() {
            return this.index.getDatasetName();
        }

        @Override
        public DataverseName getDataverseName() {
            return this.index.getDataverseName();
        }

        @Override
        public String getDatabaseName() {
            return this.index.getDatabaseName();
        }

        public Index getIndex() {
            return this.index;
        }

        public Dataset getDataset() {
            return this.dataset;
        }

        @Override
        public Statement.Kind getKind() {
            return Statement.Kind.CREATE_INDEX;
        }

        @Override
        public byte getCategory() {
            return 4;
        }
    }

    public static interface ICompiledDmlStatement
    extends ICompiledStatement {
        public String getDatabaseName();

        public DataverseName getDataverseName();

        public String getDatasetName();

        public byte getCategory();
    }

    public static class CompiledTypeDropStatement
    extends AbstractCompiledStatement {
        private final String typeName;

        public CompiledTypeDropStatement(String nodeGroupName) {
            this.typeName = nodeGroupName;
        }

        public String getTypeName() {
            return this.typeName;
        }

        @Override
        public Statement.Kind getKind() {
            return Statement.Kind.TYPE_DROP;
        }
    }

    public static class CompiledDataverseDropStatement
    extends AbstractCompiledStatement {
        private final String dataverseName;
        private final boolean ifExists;

        public CompiledDataverseDropStatement(String dataverseName, boolean ifExists) {
            this.dataverseName = dataverseName;
            this.ifExists = ifExists;
        }

        public String getDataverseName() {
            return this.dataverseName;
        }

        public boolean getIfExists() {
            return this.ifExists;
        }

        @Override
        public Statement.Kind getKind() {
            return Statement.Kind.DATAVERSE_DROP;
        }
    }

    public static class CompiledIndexDropStatement
    extends AbstractCompiledStatement {
        private final String dataverseName;
        private final String datasetName;
        private final String indexName;

        public CompiledIndexDropStatement(String dataverseName, String datasetName, String indexName) {
            this.dataverseName = dataverseName;
            this.datasetName = datasetName;
            this.indexName = indexName;
        }

        public String getDataverseName() {
            return this.dataverseName;
        }

        public String getDatasetName() {
            return this.datasetName;
        }

        public String getIndexName() {
            return this.indexName;
        }

        @Override
        public Statement.Kind getKind() {
            return Statement.Kind.INDEX_DROP;
        }
    }

    public static class CompiledNodeGroupDropStatement
    extends AbstractCompiledStatement {
        private final String nodeGroupName;

        public CompiledNodeGroupDropStatement(String nodeGroupName) {
            this.nodeGroupName = nodeGroupName;
        }

        public String getNodeGroupName() {
            return this.nodeGroupName;
        }

        @Override
        public Statement.Kind getKind() {
            return Statement.Kind.NODEGROUP_DROP;
        }
    }

    public static class CompiledCreateDataverseStatement
    extends AbstractCompiledStatement {
        private final String dataverseName;
        private final String format;

        public CompiledCreateDataverseStatement(String dataverseName, String format) {
            this.dataverseName = dataverseName;
            this.format = format;
        }

        public String getDataverseName() {
            return this.dataverseName;
        }

        public String getFormat() {
            return this.format;
        }

        @Override
        public Statement.Kind getKind() {
            return Statement.Kind.CREATE_DATAVERSE;
        }
    }

    public static class CompiledDatasetDropStatement
    extends AbstractCompiledStatement {
        private final String dataverseName;
        private final String datasetName;

        public CompiledDatasetDropStatement(String dataverseName, String datasetName) {
            this.dataverseName = dataverseName;
            this.datasetName = datasetName;
        }

        public String getDataverseName() {
            return this.dataverseName;
        }

        public String getDatasetName() {
            return this.datasetName;
        }

        @Override
        public Statement.Kind getKind() {
            return Statement.Kind.DATASET_DROP;
        }
    }

    public static abstract class AbstractCompiledStatement
    implements ICompiledStatement {
        private SourceLocation sourceLoc;

        public void setSourceLocation(SourceLocation sourceLoc) {
            this.sourceLoc = sourceLoc;
        }

        @Override
        public SourceLocation getSourceLocation() {
            return this.sourceLoc;
        }
    }

    public static interface ICompiledStatement {
        public Statement.Kind getKind();

        public SourceLocation getSourceLocation();
    }
}

