/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.auto.value.AutoValue;
import com.google.cloud.hadoop.gcsio.AutoValue_CreateFileOptions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;

@AutoValue
public abstract class CreateFileOptions {
    public static final CreateFileOptions DEFAULT_NO_OVERWRITE = CreateFileOptions.builder().build();
    public static final CreateFileOptions DEFAULT_OVERWRITE = CreateFileOptions.builder().setOverwriteExisting(true).build();

    public static Builder builder() {
        return new AutoValue_CreateFileOptions.Builder().setAttributes((Map<String, byte[]>)ImmutableMap.of()).setContentType("application/octet-stream").setEnsureNoDirectoryConflict(true).setOverwriteExisting(false).setOverwriteGenerationId(-1L);
    }

    public abstract Builder toBuilder();

    public abstract ImmutableMap<String, byte[]> getAttributes();

    @Nullable
    public abstract String getContentType();

    public abstract boolean isEnsureNoDirectoryConflict();

    public abstract boolean isOverwriteExisting();

    public abstract long getOverwriteGenerationId();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setAttributes(Map<String, byte[]> var1);

        public abstract Builder setContentType(String var1);

        public abstract Builder setEnsureNoDirectoryConflict(boolean var1);

        public abstract Builder setOverwriteGenerationId(long var1);

        public abstract Builder setOverwriteExisting(boolean var1);

        abstract CreateFileOptions autoBuild();

        public CreateFileOptions build() {
            CreateFileOptions options = this.autoBuild();
            Preconditions.checkArgument((!options.getAttributes().containsKey((Object)"Content-Type") ? 1 : 0) != 0, (Object)"The Content-Type attribute must be provided explicitly via the 'contentType' parameter");
            return options;
        }
    }
}

