/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.message;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import org.apache.asterix.app.message.AtomicJobCompletionMessage;
import org.apache.asterix.common.api.IDatasetLifecycleManager;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.context.IndexInfo;
import org.apache.asterix.common.context.PrimaryIndexOperationTracker;
import org.apache.asterix.common.messaging.api.INcAddressedMessage;
import org.apache.asterix.messaging.NCMessageBroker;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.JobId;

public class AtomicJobCommitMessage
implements INcAddressedMessage {
    private static final long serialVersionUID = 1L;
    private final JobId jobId;
    private final List<Integer> datasetIds;

    public AtomicJobCommitMessage(JobId jobId, List<Integer> datasetIds) {
        this.jobId = jobId;
        this.datasetIds = datasetIds;
    }

    public void handle(INcApplicationContext appCtx) throws HyracksDataException, InterruptedException {
        IDatasetLifecycleManager datasetLifecycleManager = appCtx.getDatasetLifecycleManager();
        ForkJoinPool commonPool = ForkJoinPool.commonPool();
        ArrayList<Future> futures = new ArrayList<Future>();
        for (Integer datasetId : this.datasetIds) {
            for (IndexInfo indexInfo : datasetLifecycleManager.getDatasetInfo(datasetId.intValue()).getIndexes().values()) {
                if (!indexInfo.getIndex().isPrimaryIndex()) continue;
                futures.add(commonPool.submit(() -> {
                    try {
                        ((PrimaryIndexOperationTracker)indexInfo.getIndex().getOperationTracker()).commit();
                    }
                    catch (HyracksDataException e) {
                        throw new RuntimeException(e);
                    }
                }));
            }
        }
        for (Future f : futures) {
            try {
                f.get();
            }
            catch (ExecutionException e) {
                futures.forEach(future -> future.cancel(true));
                throw HyracksDataException.create((Throwable)e);
            }
        }
        AtomicJobCompletionMessage message = new AtomicJobCompletionMessage(this.jobId, appCtx.getServiceContext().getNodeId());
        NCMessageBroker mb = (NCMessageBroker)appCtx.getServiceContext().getMessageBroker();
        try {
            mb.sendRealTimeMessageToCC(this.jobId.getCcId(), message);
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public String toString() {
        return "AtomicJobCommitMessage{jobId=" + this.jobId + ", datasetIds=" + this.datasetIds + "}";
    }
}

