/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.nc.task;

import java.util.Arrays;
import java.util.Set;
import org.apache.asterix.common.api.INCLifecycleTask;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.cloud.IPartitionBootstrapper;
import org.apache.asterix.transaction.management.resource.PersistentLocalResourceRepository;
import org.apache.hyracks.api.control.CcId;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.service.IControllerService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CloudToLocalStorageCachingTask
implements INCLifecycleTask {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long serialVersionUID = 1L;
    private final Set<Integer> storagePartitions;
    private final boolean metadataNode;
    private final int metadataPartitionId;
    private final boolean cleanup;

    public CloudToLocalStorageCachingTask(Set<Integer> storagePartitions, boolean metadataNode, int metadataPartitionId, boolean cleanup) {
        this.storagePartitions = storagePartitions;
        this.metadataNode = metadataNode;
        this.metadataPartitionId = metadataPartitionId;
        this.cleanup = cleanup;
    }

    public void perform(CcId ccId, IControllerService cs) throws HyracksDataException {
        INcApplicationContext applicationContext = (INcApplicationContext)cs.getApplicationContext();
        PersistentLocalResourceRepository lrs = (PersistentLocalResourceRepository)applicationContext.getLocalResourceRepository();
        String nodeId = applicationContext.getServiceContext().getNodeId();
        LOGGER.info("Initializing Node {} with storage partitions: {}", (Object)nodeId, this.storagePartitions);
        IPartitionBootstrapper bootstrapper = applicationContext.getPartitionBootstrapper();
        bootstrapper.bootstrap(this.storagePartitions, lrs.getOnDiskPartitions(), this.metadataNode, this.metadataPartitionId, this.cleanup);
    }

    public String toString() {
        return "{ \"class\" : \"" + this.getClass().getSimpleName() + "\", \"partitions\" : " + Arrays.toString(this.storagePartitions.toArray()) + " }";
    }
}

