/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.buffermanager;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.std.buffermanager.ISimpleFrameBufferManager;

public class BufferManagerBackedVSizeFrame
implements IFrame {
    protected final int minFrameSize;
    protected final IHyracksFrameMgrContext ctx;
    protected final ISimpleFrameBufferManager bufferManager;
    protected ByteBuffer frame;

    public BufferManagerBackedVSizeFrame(IHyracksFrameMgrContext ctx, ISimpleFrameBufferManager bufferManager) throws HyracksDataException {
        this(ctx, ctx.getInitialFrameSize(), bufferManager);
    }

    public BufferManagerBackedVSizeFrame(IHyracksFrameMgrContext ctx, int frameSize, ISimpleFrameBufferManager bufferManager) throws HyracksDataException {
        this.ctx = ctx;
        this.minFrameSize = ctx.getInitialFrameSize();
        this.bufferManager = bufferManager;
        this.frame = bufferManager.acquireFrame(frameSize);
    }

    public ByteBuffer getBuffer() {
        return this.frame;
    }

    public void ensureFrameSize(int newSize) throws HyracksDataException {
        if (newSize > this.getFrameSize()) {
            this.bufferManager.releaseFrame(this.frame);
            this.frame = this.bufferManager.acquireFrame(newSize);
        }
    }

    public void resize(int frameSize) throws HyracksDataException {
        if (this.getFrameSize() != frameSize) {
            this.bufferManager.releaseFrame(this.frame);
            this.frame = this.bufferManager.acquireFrame(frameSize);
        }
    }

    public int getFrameSize() {
        return this.frame.capacity();
    }

    public int getMinSize() {
        return this.minFrameSize;
    }

    public void reset() throws HyracksDataException {
        this.resize(this.minFrameSize);
        Arrays.fill(this.frame.array(), (byte)0);
        this.frame.clear();
    }

    public void acquireFrame() throws HyracksDataException {
        if (this.frame == null) {
            this.frame = this.bufferManager.acquireFrame(this.minFrameSize);
        }
        this.reset();
    }

    public void destroy() throws HyracksDataException {
        if (this.frame != null) {
            this.bufferManager.releaseFrame(this.frame);
            this.frame = null;
        }
    }
}

