/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.bytes.decoder;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.asterix.column.bytes.ParquetDeltaBinaryPackingConfig;
import org.apache.asterix.column.bytes.decoder.AbstractParquetValuesReader;
import org.apache.asterix.column.bytes.stream.in.AbstractBytesInputStream;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.column.values.bitpacking.BytePackerForLong;
import org.apache.parquet.column.values.bitpacking.Packer;
import org.apache.parquet.io.ParquetDecodingException;

public class ParquetDeltaBinaryPackingValuesReader
extends AbstractParquetValuesReader {
    private int totalValueCount;
    private int valuesBufferedRead;
    private int valuesRead;
    private long[] valuesBuffer;
    private int valuesBuffered;
    private AbstractBytesInputStream in;
    private ParquetDeltaBinaryPackingConfig config;
    private int[] bitWidths;
    private ByteBuffer bitWidthBuffer;
    private long lastElement;

    @Override
    public void initFromPage(AbstractBytesInputStream stream) throws IOException {
        this.in = stream;
        this.config = ParquetDeltaBinaryPackingConfig.readConfig(this.in, this.config);
        this.totalValueCount = BytesUtils.readUnsignedVarInt((InputStream)this.in);
        this.allocateValuesBuffer();
        this.bitWidths = this.allocate(this.bitWidths, this.config.getMiniBlockNumInABlock());
        this.valuesBuffered = 0;
        this.valuesBufferedRead = 0;
        this.valuesRead = 0;
        this.valuesBuffer[this.valuesBuffered++] = BytesUtils.readZigZagVarLong((InputStream)this.in);
        this.lastElement = this.valuesBuffer[0];
        if (this.valuesBuffered < this.totalValueCount) {
            this.loadNewBlockToBuffer();
        }
    }

    private void allocateValuesBuffer() {
        int bufferSize = this.config.getMiniBlockSizeInValues() * this.config.getMiniBlockNumInABlock() + 1;
        if (this.valuesBuffer == null || this.valuesBuffer.length < bufferSize) {
            this.valuesBuffer = new long[bufferSize];
        } else {
            Arrays.fill(this.valuesBuffer, 0L);
        }
    }

    private int[] allocate(int[] array, int size) {
        if (array == null || array.length < size) {
            return new int[size];
        }
        return array;
    }

    @Override
    public void skip() {
        this.checkRead();
        ++this.valuesRead;
    }

    @Override
    public int readInteger() {
        return (int)this.readLong();
    }

    @Override
    public long readLong() {
        this.checkRead();
        ++this.valuesRead;
        return this.valuesBuffer[this.valuesBufferedRead++];
    }

    private void checkRead() {
        if (this.valuesRead >= this.totalValueCount) {
            throw new ParquetDecodingException("no more value to read, total value count is " + this.totalValueCount);
        }
        if (this.valuesBufferedRead >= this.valuesBuffered) {
            this.lastElement = this.valuesBuffer[this.valuesBufferedRead - 1];
            this.valuesBufferedRead = 0;
            this.valuesBuffered = 0;
            Arrays.fill(this.valuesBuffer, 0L);
            try {
                this.loadNewBlockToBuffer();
            }
            catch (IOException e) {
                throw new ParquetDecodingException("can not load next block", (Throwable)e);
            }
        }
    }

    private void loadNewBlockToBuffer() throws IOException {
        int i;
        long minDeltaInCurrentBlock;
        try {
            minDeltaInCurrentBlock = BytesUtils.readZigZagVarLong((InputStream)this.in);
        }
        catch (IOException e) {
            throw new ParquetDecodingException("can not read min delta in current block", (Throwable)e);
        }
        this.readBitWidthsForMiniBlocks();
        for (i = 0; i < this.config.getMiniBlockNumInABlock() && this.valuesRead + this.valuesBuffered < this.totalValueCount; ++i) {
            BytePackerForLong packer = Packer.LITTLE_ENDIAN.newBytePackerForLong(this.bitWidths[i]);
            this.unpackMiniBlock(packer);
        }
        int valueUnpacked = i * this.config.getMiniBlockSizeInValues();
        long prev = this.lastElement;
        for (int j = this.valuesBuffered - valueUnpacked; j < this.valuesBuffered; ++j) {
            int n = j;
            this.valuesBuffer[n] = this.valuesBuffer[n] + (minDeltaInCurrentBlock + prev);
            prev = this.valuesBuffer[j];
        }
    }

    private void unpackMiniBlock(BytePackerForLong packer) throws IOException {
        for (int j = 0; j < this.config.getMiniBlockSizeInValues(); j += 8) {
            this.unpack8Values(packer);
        }
    }

    private void unpack8Values(BytePackerForLong packer) throws IOException {
        ByteBuffer buffer = this.readBitWidth(packer.getBitWidth());
        packer.unpack8Values(buffer, buffer.position(), this.valuesBuffer, this.valuesBuffered);
        this.valuesBuffered += 8;
    }

    private void readBitWidthsForMiniBlocks() {
        for (int i = 0; i < this.config.getMiniBlockNumInABlock(); ++i) {
            try {
                this.bitWidths[i] = BytesUtils.readIntLittleEndianOnOneByte((InputStream)this.in);
                continue;
            }
            catch (IOException e) {
                throw new ParquetDecodingException("Can not decode bit width in block header", (Throwable)e);
            }
        }
    }

    private ByteBuffer prepareBitWidthBuffer(int length) {
        if (this.bitWidthBuffer == null || this.bitWidthBuffer.capacity() < length) {
            this.bitWidthBuffer = ByteBuffer.allocate(length);
        }
        this.bitWidthBuffer.clear();
        this.bitWidthBuffer.limit(length);
        return this.bitWidthBuffer;
    }

    private ByteBuffer readBitWidth(int length) throws IOException {
        ByteBuffer buffer = this.prepareBitWidthBuffer(length);
        int read = this.in.read(buffer);
        if (read != length) {
            throw new EOFException("Reached end of stream");
        }
        buffer.position(0);
        return buffer;
    }
}

