/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.bytes.encoder;

import java.io.IOException;
import org.apache.asterix.column.bytes.encoder.AbstractParquetValuesWriter;
import org.apache.asterix.column.bytes.stream.out.AbstractBytesOutputStream;
import org.apache.asterix.column.bytes.stream.out.GrowableBytesOutputStream;
import org.apache.asterix.column.bytes.stream.out.MultiTemporaryBufferBytesOutputStream;
import org.apache.asterix.column.bytes.stream.out.ValueOutputStream;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.storage.am.lsm.btree.column.api.IColumnWriteMultiPageOp;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.io.ParquetEncodingException;

public class ParquetPlainVariableLengthValuesWriter
extends AbstractParquetValuesWriter {
    private final GrowableBytesOutputStream offsetStream = new GrowableBytesOutputStream();
    private final AbstractBytesOutputStream valueStream;
    private final ValueOutputStream offsetWriterStream;

    public ParquetPlainVariableLengthValuesWriter(Mutable<IColumnWriteMultiPageOp> multiPageOpRef) {
        this.valueStream = new MultiTemporaryBufferBytesOutputStream(multiPageOpRef);
        this.offsetWriterStream = new ValueOutputStream(this.offsetStream);
    }

    @Override
    public void writeBytes(IValueReference v, boolean skipLengthBytes) {
        try {
            this.offsetWriterStream.writeInt(this.valueStream.size());
            this.valueStream.write(v);
        }
        catch (IOException e) {
            throw new ParquetEncodingException("could not write bytes", (Throwable)e);
        }
    }

    @Override
    public BytesInput getBytes() {
        try {
            this.offsetStream.flush();
            this.valueStream.flush();
        }
        catch (IOException e) {
            throw new ParquetEncodingException("could not write page", (Throwable)e);
        }
        return BytesInput.concat((BytesInput[])new BytesInput[]{this.offsetStream.asBytesInput(), this.valueStream.asBytesInput()});
    }

    @Override
    public void reset() throws HyracksDataException {
        this.offsetStream.reset();
        this.valueStream.reset();
    }

    @Override
    public void close() {
        this.offsetStream.finish();
        this.valueStream.finish();
    }

    @Override
    public int getEstimatedSize() {
        return this.offsetStream.size() + this.valueStream.size();
    }

    @Override
    public int calculateEstimatedSize(int length) {
        return length + 4;
    }

    @Override
    public int getAllocatedSize() {
        return this.offsetStream.capacity() + this.valueStream.size();
    }
}

