/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.filter.iterable.evaluator;

import java.util.List;
import org.apache.asterix.column.filter.FilterAccessorProvider;
import org.apache.asterix.column.filter.iterable.ColumnFilterEvaluatorContext;
import org.apache.asterix.column.filter.iterable.IColumnIterableFilterEvaluator;
import org.apache.asterix.column.filter.iterable.IColumnIterableFilterEvaluatorFactory;
import org.apache.asterix.column.filter.iterable.evaluator.ColumnIterableFilterEvaluator;
import org.apache.asterix.column.filter.iterable.evaluator.ColumnarRepeatedIterableFilterEvaluator;
import org.apache.asterix.column.values.IColumnValuesReader;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class ColumnIterableFilterEvaluatorFactory
implements IColumnIterableFilterEvaluatorFactory {
    private static final long serialVersionUID = 171140626152211361L;
    private final IScalarEvaluatorFactory evaluatorFactory;

    public ColumnIterableFilterEvaluatorFactory(IScalarEvaluatorFactory evaluatorFactory) {
        this.evaluatorFactory = evaluatorFactory;
    }

    @Override
    public IColumnIterableFilterEvaluator create(ColumnFilterEvaluatorContext context) throws HyracksDataException {
        IScalarEvaluator evaluator = this.evaluatorFactory.createScalarEvaluator((IEvaluatorContext)context);
        FilterAccessorProvider filterAccessorProvider = context.getFilterAccessorProvider();
        List<IColumnValuesReader> readers = filterAccessorProvider.getFilterColumnReaders();
        if (readers.isEmpty()) {
            throw new NullPointerException("Readers are empty");
        }
        if (readers.stream().anyMatch(IColumnValuesReader::isRepeated)) {
            return new ColumnarRepeatedIterableFilterEvaluator(evaluator, readers);
        }
        return new ColumnIterableFilterEvaluator(evaluator, readers);
    }
}

